/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.monitor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.agent.AgentChannel;
import org.lsst.ccs.gconsole.agent.AgentChannelsFilter;
import org.lsst.ccs.gconsole.agent.AgentStatusEvent;
import org.lsst.ccs.gconsole.plugins.monitor.AbstractMonitorView;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorView;

public class CompoundView
extends AbstractMonitorView {
    private final JComponent panel;
    private final ArrayList<MonitorView> children1 = new ArrayList(0);
    private final ArrayList<MonitorView> children2 = new ArrayList(0);
    private final ArrayList<AbstractMonitorView> children3 = new ArrayList(0);

    public CompoundView(JComponent panel) {
        this.panel = panel;
    }

    @Override
    public JComponent getPanel() {
        return this.panel;
    }

    @Override
    public void setFilter(AgentChannelsFilter filter) {
        super.setFilter(filter);
        this.children1.forEach(child -> child.setFilter(filter));
        this.children2.forEach(child -> child.setFilter(filter));
    }

    public void addView(MonitorView view, Mode mode) {
        switch (mode) {
            case INDEPENDENT: {
                this.children1.add(view);
                break;
            }
            case FORWARD: {
                this.children2.add(view);
                break;
            }
            case HOOK: {
                try {
                    this.children3.add((AbstractMonitorView)view);
                    break;
                }
                catch (ClassCastException x) {
                    throw new IllegalArgumentException("HOOK mode can only be used to manage views of types that extend AbstractMonitorView", x);
                }
            }
        }
    }

    @Override
    public void connect(AgentStatusEvent event) {
        super.connect(event);
        this.children2.forEach(view -> view.connect(event.filter(view.getFilter())));
    }

    @Override
    public void configure(AgentStatusEvent event) {
        super.configure(event);
        this.children2.forEach(view -> view.configure(event.filter(view.getFilter())));
    }

    @Override
    public void statusChanged(AgentStatusEvent event) {
        super.statusChanged(event);
        this.children2.forEach(view -> view.statusChanged(event.filter(view.getFilter())));
    }

    @Override
    public void disconnect(AgentStatusEvent event) {
        super.disconnect(event);
        this.children2.forEach(view -> view.disconnect(event.filter(view.getFilter())));
    }

    @Override
    protected void connect(AgentInfo agent) {
        this.children3.forEach(view -> view.connect(agent));
    }

    @Override
    protected void disconnect(AgentInfo agent) {
        this.children3.forEach(view -> view.disconnect(agent));
    }

    @Override
    protected void addChannels(AgentInfo agent, Map<String, AgentChannel> channels) {
        this.children3.forEach(view -> view.addChannels(agent, channels));
    }

    @Override
    protected void removeChannels(AgentInfo agent, List<String> paths) {
        this.children3.forEach(view -> view.removeChannels(agent, paths));
    }

    @Override
    protected void updateChannels(AgentInfo agent, Map<String, Map.Entry<AgentChannel, List<String>>> channels) {
        this.children3.forEach(view -> view.updateChannels(agent, channels));
    }

    @Override
    public void install() {
        super.install();
        this.children1.forEach(view -> view.install());
    }

    @Override
    public void uninstall() {
        super.uninstall();
        this.children1.forEach(view -> view.uninstall());
    }

    @Override
    public Descriptor save() {
        if (this.descriptor == null) {
            this.descriptor = new Descriptor();
        }
        List<MonitorView> views = this.getChildren();
        MonitorView.Descriptor[] descriptors = new MonitorView.Descriptor[views.size()];
        for (int i = 0; i < descriptors.length; ++i) {
            descriptors[i] = views.get(i).save();
        }
        ((Descriptor)this.descriptor).setChildren(descriptors);
        return (Descriptor)this.descriptor;
    }

    @Override
    public void restore(MonitorView.Descriptor descriptor) {
        if (descriptor instanceof Descriptor) {
            List<MonitorView> vv;
            Descriptor desc = (Descriptor)descriptor;
            this.descriptor = desc;
            MonitorView.Descriptor[] dd = desc.getChildren();
            if (dd != null && dd.length == (vv = this.getChildren()).size()) {
                for (int i = 0; i < dd.length; ++i) {
                    vv.get(i).restore(dd[i]);
                }
            }
        }
    }

    private List<MonitorView> getChildren() {
        ArrayList<MonitorView> out = new ArrayList<MonitorView>(this.children1.size() + this.children2.size() + this.children3.size());
        out.addAll(this.children1);
        out.addAll(this.children2);
        out.addAll(this.children3);
        return out;
    }

    public static class Descriptor
    extends AbstractMonitorView.Descriptor {
        private MonitorView.Descriptor[] children;

        public MonitorView.Descriptor[] getChildren() {
            return this.children;
        }

        public void setChildren(MonitorView.Descriptor[] children) {
            this.children = children;
        }
    }

    public static enum Mode {
        INDEPENDENT,
        FORWARD,
        HOOK;

    }
}

