/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.lsst.ccs.Agent;
import org.lsst.ccs.ComponentConfigurationEnvironment;
import org.lsst.ccs.ServiceLifecycle;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.ConfigurationParameterInfo;
import org.lsst.ccs.bus.messages.StatusConfigurationInfo;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.states.AgentState;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.config.BulkSettingException;
import org.lsst.ccs.config.ConfigurationDAO;
import org.lsst.ccs.config.ConfigurationDescription;
import org.lsst.ccs.config.ConfigurationHandlerSet;
import org.lsst.ccs.config.ConfigurationServiceException;
import org.lsst.ccs.config.ConfigurationView;
import org.lsst.ccs.config.LocalConfigurationDAO;
import org.lsst.ccs.config.remote.CCSBusesConfigurationDAO;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.description.ComponentNode;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.framework.TreeWalkerUtils;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.utilities.conv.TypeUtils;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.structs.ParameterPath;

public final class ConfigurationService
implements ServiceLifecycle,
ClearAlertHandler,
AgentPresenceListener {
    private final Agent agent;
    private ConfigurationDAO configurationProxy;
    private ConfigurationInfo currentConfigInfo;
    private ConfigurationHandlerSet configurationHandler;
    private final Set<String> categories = new HashSet<String>();
    private static final Logger conf_sub_log = Logger.getLogger((String)"org.lsst.ccs.config");
    private static final Alert CS_ALERT_1 = new Alert("CCSCFGSRV", "configuration service unavailable");
    private static final Alert CS_ALERT_2 = new Alert("CCSCFGOP", "operator error");
    private final Lock configLock = new ReentrantLock();
    private final Map<String, ComponentConfigurationEnvironment> keyEnvironmentMap = new HashMap<String, ComponentConfigurationEnvironment>();
    private String descriptionName;
    private String agentName;

    ConfigurationService(Agent a) {
        this.agent = a;
        if (BootstrapResourceUtils.getBootstrapSystemProperties().getOrDefault((Object)"org.lsst.ccs.config.remote", "false").equals("true")) {
            a.setAgentProperty("org.lsst.ccs.config.remote", "true");
        }
        ComponentLookup lookup = a.getComponentLookup();
        lookup.addComponentNodeToLookup(lookup.getTopComponentNode().getKey(), new ComponentNode(lookup.getTopComponentNode(), "configurationService", (Object)this));
    }

    @Override
    public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert) {
        if (CS_ALERT_1.getAlertId().equals(alert.getAlertId())) {
            return this.configurationProxy.isAvailable() ? ClearAlertHandler.ClearAlertCode.CLEAR_ALERT : ClearAlertHandler.ClearAlertCode.DONT_CLEAR_ALERT;
        }
        if (CS_ALERT_2.getAlertId().equals(alert.getAlertId())) {
            return this.agent.isInState((Enum)ConfigurationState.CONFIGURED) ? ClearAlertHandler.ClearAlertCode.CLEAR_ALERT : ClearAlertHandler.ClearAlertCode.DONT_CLEAR_ALERT;
        }
        return ClearAlertHandler.ClearAlertCode.UNKWNOWN_ALERT;
    }

    @Override
    public void preInit() {
        this.configurationHandler = new ConfigurationHandlerSet();
        ComponentLookup lookup = this.agent.getComponentLookup();
        ComponentNode topNode = lookup.getTopComponentNode();
        TreeWalkerUtils.proceduralNodeWalk(lookup, null, n -> {
            Object component;
            String nodeName = n.getKey();
            if (this.configurationHandler.addConfigurationHandlerForObject(nodeName, component = n.getComponent())) {
                ComponentConfigurationEnvironment cce = new ComponentConfigurationEnvironment(nodeName, this);
                this.keyEnvironmentMap.put(nodeName, cce);
                this.agent.addCommandsFromObject(cce, lookup.getFullPathFor(nodeName));
            }
        }, null);
        String descName = (String)topNode.getTag("descriptionName");
        this.descriptionName = descName == null ? this.agent.getClass().getSimpleName() : descName;
        this.agentName = this.agent.getName();
        this.configurationProxy = new LocalConfigurationDAO(this.agent.getName());
        ConfigurationView initialView = new ConfigurationView();
        Map topNodeTags = topNode.getTags();
        for (Map.Entry entry : topNodeTags.entrySet()) {
            if (!(entry.getKey() instanceof String)) continue;
            try {
                String value = TypeUtils.stringify(entry.getValue());
                ParameterPath path = ParameterPath.valueOf((String)((String)entry.getKey()));
                if (!this.isParameterConfigurable(path.getComponentName(), path.getParameterName())) continue;
                initialView.putParameterValue(path.toString(), value);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        this.categories.addAll(this.configurationHandler.getCategorySet());
        ConfigurationView safeValuesFromFile = this.configurationProxy.loadConfiguration(this.agentName, ConfigurationDescription.safeConfiguration(this.categories));
        initialView.putAll(safeValuesFromFile);
        this.currentConfigInfo = this.configurationHandler.initialize(this.descriptionName, initialView);
    }

    @Override
    public void preStart() {
        String startupConfig;
        this.updateStateAndSendStatusConfigurationInfo(this.currentConfigInfo);
        this.agent.getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)this);
        if (this.agent.getAgentInfo().hasAgentProperty("org.lsst.ccs.config.remote")) {
            conf_sub_log.info((Object)"switching to remote configuration service");
            this.configurationProxy = new CCSBusesConfigurationDAO(this.agent.getMessagingAccess());
        }
        if ((startupConfig = (String)this.agent.getComponentLookup().getTopComponentNode().getTag("startupConfig")) != null) {
            this.loadConfiguration(startupConfig.isEmpty() ? null : startupConfig.split(","));
        }
    }

    @Command(description="Saves all changes in the current configurations", type=Command.CommandType.CONFIGURATION)
    public void saveAllChanges() {
        this.saveAllChanges(null);
    }

    @Command(description="Saves all changes in the current configurations", type=Command.CommandType.CONFIGURATION)
    public void saveAllChanges(String configName) {
        ConfigurationDescription cd = this.getPartialConfigurationDescription(this.categories.toArray(new String[1]));
        cd.setName(configName, -1);
        this.saveChangesForCategoriesInternal(cd);
    }

    @Command(description="Saves the specified categories with a name", type=Command.CommandType.CONFIGURATION)
    public void saveChangesForCategories(String ... categories) {
        try (ConfigurationLock lock = this.acquireConfigurationLock();){
            ConfigurationDescription cd = this.getPartialConfigurationDescription(categories);
            this.saveChangesForCategoriesInternal(cd);
        }
    }

    @Command(description="Saves the specified categories with a name", type=Command.CommandType.CONFIGURATION)
    public void saveChangesForCategoriesAs(String ... taggedCategories) {
        try (ConfigurationLock lock = this.acquireConfigurationLock();){
            ConfigurationDescription cd = new ConfigurationDescription(this.categories);
            cd.parseConfigurationString(taggedCategories);
            this.saveChangesForCategoriesInternal(cd);
        }
    }

    private void saveChangesForCategoriesInternal(ConfigurationDescription configDesc) {
        this.checkValidStates(true, true);
        if (configDesc.isEmpty()) {
            return;
        }
        try {
            ConfigurationView currentView = this.configurationHandler.getLiveConfigurationView();
            ConfigurationView diff = this.extractConfigurationViewFromCurrentConfigurationInfo().diff(currentView);
            if (!diff.isEmpty()) {
                StringBuilder sb = new StringBuilder("the following parameters have had their valie changed without notifying the configuration service : \n");
                for (ParameterPath parm : diff.getAsParameterPathMap().keySet()) {
                    sb.append(parm).append(" expected ").append(this.currentConfigInfo.getCurrentValueForParameter(parm.toString())).append(" was ").append(currentView.getPathValue(parm)).append("\n");
                }
                throw new BulkSettingException(sb.toString());
            }
            currentView.setConfigurationDescription(configDesc);
            ConfigurationInfo.Builder ciBuilder = this.buildConfigurationInfo(currentView);
            ConfigurationDescription desc = this.configurationProxy.saveChangesForCategoriesAs(this.agentName, configDesc, ciBuilder.build());
            ciBuilder.updateVersions(desc.getVersion(), desc.getCategoryVersions());
            this.updateStateAndSendStatusConfigurationInfo(ciBuilder.build());
        }
        catch (RuntimeException ex) {
            this.handleException(ex);
        }
    }

    private ConfigurationDescription getPartialConfigurationDescription(String ... categories) {
        ConfigurationDescription configDesc = new ConfigurationDescription(this.categories);
        for (String cat : categories) {
            configDesc.putTagForCategory(cat, this.currentConfigInfo.getConfigNameForCategory(cat), this.currentConfigInfo.getConfigVersion(cat));
        }
        return configDesc;
    }

    @Command(description="drop all unsaved changes", type=Command.CommandType.CONFIGURATION)
    public void dropAllChanges() {
        this.dropChangesInternal(this.categories);
    }

    @Command(description="drop unsaved changes for the specified categories", type=Command.CommandType.CONFIGURATION)
    public void dropChangesForCategories(String ... categories) {
        HashSet<String> catSet = new HashSet<String>();
        catSet.addAll(Arrays.asList(categories));
        this.dropChangesInternal(catSet);
    }

    private void dropChangesInternal(Set<String> categories) {
        try (ConfigurationLock lock = this.acquireConfigurationLock();){
            this.checkValidStates(true, true);
            try {
                ConfigurationView view = new ConfigurationView(this.getPartialConfigurationDescription(categories.toArray(new String[1])));
                for (ConfigurationParameterInfo cpi : this.currentConfigInfo.getAllParameterInfo()) {
                    if (!categories.contains(cpi.getCategoryName())) continue;
                    view.putParameterValue(cpi.getComponentName(), cpi.getParameterName(), cpi.getConfiguredValue());
                }
                ConfigurationView res = this.configurationHandler.loadCategories(view);
                ConfigurationInfo.Builder ciBuilder = this.buildConfigurationInfo(res);
                ConfigurationDescription desc = this.configurationProxy.registerConfiguration(this.agentName, ciBuilder.build());
                ciBuilder.updateVersions(desc.getVersion(), desc.getCategoryVersions());
                this.updateStateAndSendStatusConfigurationInfo(ciBuilder.build());
            }
            catch (RuntimeException ex) {
                this.handleException(ex);
            }
        }
    }

    @Command(description="loads a new configuration", type=Command.CommandType.CONFIGURATION)
    public void loadConfiguration(String ... taggedCategories) {
        try (ConfigurationLock lock = this.acquireConfigurationLock();){
            this.checkValidStates(false, false);
            ConfigurationDescription configDesc = new ConfigurationDescription(this.categories).parseConfigurationString(taggedCategories).withDefaults(true);
            this.loadCategoriesInternal(configDesc);
        }
    }

    @Command(description="loads all categories for a given configuration", type=Command.CommandType.CONFIGURATION)
    public void loadGlobalConfiguration(@Argument(description="a name that defines a combination of tagegd categories") String globalName, int version) {
        try (ConfigurationLock lock = this.acquireConfigurationLock();){
            this.checkValidStates(false, false);
            ConfigurationView configView = this.configurationProxy.loadGlobalConfiguration(this.agentName, globalName, version);
            if (!configView.getConfigurationDescription().getCategoryTags().keySet().containsAll(this.categories)) {
                throw new IllegalArgumentException("the named configuration " + globalName + "does not define a named configuration for all categories");
            }
            try {
                ConfigurationView res = this.configurationHandler.loadCategories(configView);
                ConfigurationInfo.Builder ciBuilder = this.buildConfigurationInfo(res);
                ConfigurationDescription desc = this.configurationProxy.registerConfiguration(this.agentName, ciBuilder.build());
                ciBuilder.updateVersions(desc.getVersion(), desc.getCategoryVersions());
                this.updateStateAndSendStatusConfigurationInfo(ciBuilder.build());
            }
            catch (RuntimeException ex) {
                this.handleException(ex);
            }
        }
    }

    @Command(description="loads the configuration for the specified categories", type=Command.CommandType.CONFIGURATION)
    public void loadCategories(String ... taggedCategories) {
        if (taggedCategories.length == 0) {
            return;
        }
        try (ConfigurationLock lock = this.acquireConfigurationLock();){
            this.checkValidStates(true, true);
            ConfigurationDescription configDesc = new ConfigurationDescription(this.categories).parseConfigurationString(taggedCategories);
            this.loadCategoriesInternal(configDesc);
        }
    }

    private void loadCategoriesInternal(ConfigurationDescription configDesc) {
        try {
            ConfigurationView cv = this.configurationProxy.loadConfiguration(this.agentName, configDesc);
            ConfigurationView res = this.configurationHandler.loadCategories(cv);
            ConfigurationInfo.Builder ciBuilder = this.buildConfigurationInfo(res);
            ConfigurationDescription desc = this.configurationProxy.registerConfiguration(this.agentName, ciBuilder.build());
            ciBuilder.updateVersions(desc.getVersion(), desc.getCategoryVersions());
            this.updateStateAndSendStatusConfigurationInfo(ciBuilder.build());
        }
        catch (RuntimeException ex) {
            this.handleException(ex);
        }
    }

    @Command(description="return a ConfigurationInfo object", type=Command.CommandType.CONFIGURATION)
    public ConfigurationInfo getConfigurationInfo() {
        try (ConfigurationLock lock = this.acquireConfigurationLock();){
            ConfigurationInfo configurationInfo = this.currentConfigInfo;
            return configurationInfo;
        }
    }

    @Command(description="Submits a single change to be processed immediately", type=Command.CommandType.CONFIGURATION)
    public void change(String componentName, String parameterName, Object value) {
        this.checkValidStates(true, true);
        if (!this.isParameterConfigurable(componentName, parameterName)) {
            throw new IllegalArgumentException(componentName + "/" + parameterName + " is not a configuration parameter");
        }
        try (ConfigurationLock lock = this.acquireConfigurationLock();){
            try {
                ConfigurationView view = this.configurationHandler.setSingleParameter(componentName, parameterName, value);
                ConfigurationInfo.Builder ciBuilder = this.buildConfigurationInfo(view);
                ConfigurationDescription desc = this.configurationProxy.registerConfiguration(this.agentName, ciBuilder.build());
                ciBuilder.updateVersions(desc.getVersion(), desc.getCategoryVersions());
                this.updateStateAndSendStatusConfigurationInfo(ciBuilder.build());
            }
            catch (RuntimeException ex) {
                this.handleException(ex);
            }
        }
    }

    @Command(description="Submits a change of parameter to be validated later", type=Command.CommandType.CONFIGURATION)
    public void submitChange(String componentName, String parameterName, Object value) {
        this.checkValidStates(true, true);
        try (ConfigurationLock lock = this.acquireConfigurationLock();){
            this.configurationHandler.submitChange(componentName, parameterName, value);
        }
    }

    @Command(description="Submits changes of parameters to be validated later", type=Command.CommandType.CONFIGURATION)
    public void submitChanges(String componentName, Map<String, Object> changes) {
        this.checkValidStates(true, true);
        try (ConfigurationLock lock = this.acquireConfigurationLock();){
            for (Map.Entry<String, Object> entry : changes.entrySet()) {
                this.configurationHandler.submitChange(componentName, entry.getKey(), entry.getValue());
            }
        }
    }

    @Command(description="processes the bulk change", type=Command.CommandType.CONFIGURATION)
    public void commitBulkChange() {
        try (ConfigurationLock lock = this.acquireConfigurationLock();){
            this.checkValidStates(true, true);
            try {
                ConfigurationView view = this.configurationHandler.commitBulkChange(null);
                ConfigurationInfo.Builder ciBuilder = this.buildConfigurationInfo(view);
                ConfigurationDescription cd = this.configurationProxy.registerConfiguration(this.agentName, ciBuilder.build());
                ciBuilder.updateVersions(cd.getVersion(), cd.getCategoryVersions());
                this.updateStateAndSendStatusConfigurationInfo(ciBuilder.build());
                conf_sub_log.info((Object)(this.currentConfigInfo.getLatestChanges().size() + " successfully set parameters"));
            }
            catch (RuntimeException ex) {
                this.handleException(ex);
            }
        }
    }

    @Command(description="Drops the submitted changes for all components", type=Command.CommandType.CONFIGURATION)
    public void dropAllSubmittedChanges() {
        try (ConfigurationLock lock = this.acquireConfigurationLock();){
            this.configurationHandler.dropAllSubmittedChanges();
        }
    }

    @Command(description="Drops the submitted changes for the given component", type=Command.CommandType.CONFIGURATION)
    public void dropSubmittedChangesForComponent(@Argument(description="the component name") String name) {
        try (ConfigurationLock lock = this.acquireConfigurationLock();){
            this.configurationHandler.dropSubmittedChangesForComponent(name);
        }
    }

    @Command(description="Returns the current submitted changes for the given component", type=Command.CommandType.CONFIGURATION)
    public Map<String, String> getSubmittedChangesForComponent(@Argument(description="the component name") String name) {
        try (ConfigurationLock lock = this.acquireConfigurationLock();){
            Map map = this.configurationHandler.getSubmittedChangesForComponent(name);
            return map;
        }
    }

    @Command(description="Returns the current submitted changes for each component", type=Command.CommandType.CONFIGURATION)
    public Map<String, Map<String, String>> getAllSubmittedChanges() {
        try (ConfigurationLock lock = this.acquireConfigurationLock();){
            Map map = this.configurationHandler.getAllSubmittedChanges();
            return map;
        }
    }

    @Command(description="returns the categories of this subsystem")
    public Set<String> getCategories() {
        return Collections.unmodifiableSet(this.categories);
    }

    @Command(description="returns the available configurations for the given category")
    public Set<String> findAvailableConfigurationsForCategory(String category) {
        try {
            return this.configurationProxy.findAvailableConfigurationsForCategory(this.agentName, category);
        }
        catch (ConfigurationServiceException ex) {
            this.agent.getAlertService().raiseAlert(CS_ALERT_1, AlertState.ALARM, ex.getMessage());
            throw ex;
        }
    }

    @Command(description="returns the current values for a given component that belong to the specified categories")
    public Map<String, String> getCurrentValuesForComponent(String componentName, Set<String> categorySet) {
        try (ConfigurationLock lock = this.acquireConfigurationLock();){
            Map map = this.configurationHandler.getCurrentValuesForComponent(componentName, categorySet);
            return map;
        }
    }

    @Command
    public boolean isParameterConfigurable(String componentName, String parameterName) {
        return this.configurationHandler.isParameterConfigurable(componentName, parameterName);
    }

    public String getTag() {
        return this.descriptionName;
    }

    public void connecting(AgentInfo ai) {
        if ("true".equals(ai.getAgentProperty("org.lsst.ccs.config.service"))) {
            this.agent.getMessagingAccess().sendStatusMessage((StatusMessage)new StatusConfigurationInfo(this.currentConfigInfo, this.agent.getState()));
        }
    }

    public void disconnecting(AgentInfo agent) {
    }

    public ConfigurationLock acquireConfigurationLock() {
        return new ConfigurationLock();
    }

    public ConfigurationLock tryAcquireConfigurationLock(long time, TimeUnit unit) throws InterruptedException, TimeoutException {
        return new ConfigurationLock(time, unit);
    }

    public ComponentConfigurationEnvironment getComponentConfigurationEnvironment(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Provided name cannot be null.");
        }
        ComponentConfigurationEnvironment environment = this.keyEnvironmentMap.get(name);
        if (environment == null) {
            throw new IllegalArgumentException("No Component with name \"" + name + "\" containing configuration parameters.");
        }
        return environment;
    }

    private void updateStateAndSendStatusConfigurationInfo(ConfigurationInfo ci) {
        this.currentConfigInfo = ci;
        this.agent.updateInternalState(new AgentState[]{this.currentConfigInfo.getConfigurationState()});
        this.agent.getMessagingAccess().sendStatusMessage((StatusMessage)new StatusConfigurationInfo(this.currentConfigInfo, this.agent.getState()));
    }

    private ConfigurationInfo.Builder buildConfigurationInfo(ConfigurationView newView) {
        ConfigurationDescription configDesc = newView.getConfigurationDescription();
        if (configDesc == null) {
            configDesc = new ConfigurationDescription(this.categories);
        }
        ConfigurationDescription cd = new ConfigurationDescription(this.categories);
        for (String cat : this.currentConfigInfo.getCategorySet()) {
            cd.putTagForCategory(cat, this.currentConfigInfo.getConfigNameForCategory(cat), this.currentConfigInfo.getConfigVersion(cat));
        }
        cd.merge(configDesc);
        ConfigurationInfo.Builder ciBuilder = new ConfigurationInfo.Builder().setDescription(this.descriptionName);
        ConfigurationState nextState = ConfigurationState.CONFIGURED;
        for (Map.Entry entry : ConfigurationInfo.getParameterInfoGroupByCategory((List)this.currentConfigInfo.getAllParameterInfo()).entrySet()) {
            String category = (String)entry.getKey();
            boolean categoryCommitted = configDesc.containsCategory(category);
            boolean dirtyCat = false;
            for (ConfigurationParameterInfo cpi : (List)entry.getValue()) {
                String configuredValue;
                ParameterPath path = ParameterPath.valueOf((String)cpi.getPathName());
                String currentValue = newView.getPathValue(path);
                String string = configuredValue = categoryCommitted ? currentValue : cpi.getConfiguredValue();
                if (!currentValue.equals(this.currentConfigInfo.getCurrentValueForParameter(path.toString()))) {
                    ciBuilder.addRecentChange(path.toString());
                }
                ciBuilder.addParameter(ParameterPath.valueOf((String)cpi.getPathName()), cpi.getType(), cpi.getCategoryName(), cpi.getDescription(), cpi.isFinal());
                boolean dirtyParm = !currentValue.equals(configuredValue);
                ciBuilder.updateParameter(ParameterPath.valueOf((String)cpi.getPathName()), configuredValue, currentValue, dirtyParm);
                if (!dirtyParm) continue;
                dirtyCat = true;
                nextState = ConfigurationState.DIRTY;
            }
            ciBuilder.updateCategoryInformation(category, (String)cd.getCategoryTags().get(category), (Integer)cd.getCategoryVersions().get(category), dirtyCat);
        }
        if (cd.equals((Object)ConfigurationDescription.safeConfiguration(this.categories)) && nextState != ConfigurationState.DIRTY) {
            nextState = ConfigurationState.INITIAL_SAFE;
        }
        return ciBuilder.setConfigurationState(nextState).setGlobalConfigurationInformation(configDesc.getName(), Integer.valueOf(configDesc.getVersion())).setTime(System.currentTimeMillis());
    }

    private ConfigurationView extractConfigurationViewFromCurrentConfigurationInfo() {
        List list = this.currentConfigInfo.getAllParameterInfo();
        ConfigurationView cv = new ConfigurationView();
        for (ConfigurationParameterInfo cpi : list) {
            cv.putParameterValue(cpi.getComponentName(), cpi.getParameterName(), cpi.getCurrentValue());
        }
        return cv;
    }

    private void checkValidStates(boolean failIfNotEM, boolean failIfInitialSafe) {
        ConfigurationState configState;
        if (this.configurationHandler == null) {
            throw new IllegalStateException("the configuration service is not initialized yet");
        }
        if (this.agent.getState(PhaseState.class) == null) {
            throw new IllegalStateException("Configuration commands are accepted only when the subsystem is connected on the buses");
        }
        if (failIfInitialSafe && ((configState = (ConfigurationState)this.agent.getState(ConfigurationState.class)) == null || configState == ConfigurationState.INITIAL_SAFE)) {
            throw new IllegalStateException("A full configuration load must be performed first, using loadConfiguration");
        }
        if (failIfNotEM && !this.agent.isInEngineeringMode()) {
            throw new IllegalStateException("Fine grained configuration actions are accepted only in engineering mode");
        }
    }

    private void handleException(RuntimeException ex) {
        ConfigurationView view = this.configurationHandler.getLiveConfigurationView();
        this.updateStateAndSendStatusConfigurationInfo(this.buildConfigurationInfo(view).build());
        if (ex instanceof ConfigurationServiceException) {
            this.agent.getAlertService().raiseAlert(CS_ALERT_1, AlertState.ALARM, ex.getMessage());
        } else if (ex instanceof BulkSettingException) {
            this.agent.getAlertService().raiseAlert(CS_ALERT_2, AlertState.ALARM, ex.getMessage());
        }
        throw ex;
    }

    public class ConfigurationLock
    implements AutoCloseable {
        private ConfigurationLock(long time, TimeUnit unit) throws InterruptedException, TimeoutException {
            if (!ConfigurationService.this.configLock.tryLock(time, unit)) {
                throw new TimeoutException("could not acquire lock within given time");
            }
        }

        private ConfigurationLock() {
            ConfigurationService.this.configLock.lock();
        }

        @Override
        public void close() {
            ConfigurationService.this.configLock.unlock();
        }
    }
}

