/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.rafts.ui.jas;

import java.awt.Component;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.freehep.application.studio.Studio;
import org.freehep.xml.menus.XMLMenuBuilder;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.Plugin;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.jas3.Jas3Console;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.subsystem.rafts.data.RaftsAgentProperties;
import org.lsst.ccs.subsystem.rafts.ui.RaftsControlGui;
import org.lsst.ccs.subsystem.rafts.ui.RaftsMonitorGui;
import org.xml.sax.SAXException;

@Plugin(name="CCS Rafts Console Plugin", description="CCS Rafts Console Plugin")
public class RaftsConsolePlugin
extends ConsolePlugin {
    private final Map<String, RaftsMonitorGui> mapOfMonitorGuis = new HashMap<String, RaftsMonitorGui>();
    private final Map<String, RaftsControlGui> mapOfControlGuis = new HashMap<String, RaftsControlGui>();
    private final Object guiCreationLock = new Object();

    public void initialize() {
        Studio studio = ((Jas3Console)this.getConsole()).getApplication();
        try {
            XMLMenuBuilder builder = studio.getXMLMenuBuilder();
            URL xml = ((Object)((Object)this)).getClass().getResource("VST.menus");
            builder.build(xml);
        }
        catch (IOException | SAXException ex) {
            ex.printStackTrace();
        }
        this.getConsole().getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener(new AgentPresenceListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void connecting(AgentInfo agent) {
                if (agent.hasAgentProperty(RaftsAgentProperties.RAFT_TYPE_AGENT_PROPERTY)) {
                    Object object = RaftsConsolePlugin.this.guiCreationLock;
                    synchronized (object) {
                        if (RaftsConsolePlugin.this.mapOfControlGuis.get(agent.getName()) == null) {
                            RaftsConsolePlugin.this.mapOfControlGuis.put(agent.getName(), RaftsConsolePlugin.openControlGui(agent.getName(), RaftsConsolePlugin.this.getConsole()));
                        }
                    }
                    object = RaftsConsolePlugin.this.guiCreationLock;
                    synchronized (object) {
                        if (RaftsConsolePlugin.this.mapOfMonitorGuis.get(agent.getName()) == null) {
                            RaftsConsolePlugin.this.mapOfMonitorGuis.put(agent.getName(), RaftsConsolePlugin.openMonitorGui(agent.getName(), RaftsConsolePlugin.this.getConsole()));
                        }
                    }
                }
            }

            public void disconnecting(AgentInfo agent) {
            }
        });
    }

    private static RaftsControlGui openControlGui(String agentName, Console console) {
        RaftsControlGui gui = new RaftsControlGui(agentName);
        String title = agentName.replace("ccs-", "").replace("ccs", "").toUpperCase() + " Raft Controls";
        ((Jas3Console)console).getApplication().getPageManager().openPage((Component)gui.getGuiLayout(), title, null);
        gui.initGui();
        return gui;
    }

    private static RaftsMonitorGui openMonitorGui(String agentName, Console console) {
        RaftsMonitorGui gui = new RaftsMonitorGui(agentName);
        String title = agentName.replace("ccs-", "").replace("ccs", "").toUpperCase() + " Monitor";
        ((Jas3Console)console).getApplication().getPageManager().openPage((Component)gui.getGuiLayout(), title, null);
        gui.initGui();
        return gui;
    }
}

