/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.lsst.ccs.Agent;
import org.lsst.ccs.ServiceLifecycle;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.Persist;
import org.lsst.ccs.commons.annotations.scanner.FieldAnnotationScanner;
import org.lsst.ccs.commons.annotations.scanner.ReflectObject;
import org.lsst.ccs.config.WriterProvider;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.description.ComponentNode;
import org.lsst.ccs.framework.TreeWalkerUtils;
import org.lsst.ccs.utilities.conv.InputConversionEngine;
import org.lsst.ccs.utilities.conv.TypeUtils;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.structs.ParameterPath;

class SubsystemPersistencyService
implements ServiceLifecycle {
    private static final Logger log = Logger.getLogger((String)"org.lsst.ccs");
    private final Agent agent;
    private String persistencyFileName;
    private final WriterProvider wp = WriterProvider.getInstance();
    private final Map<String, ObjectPersistensyService> objectMap = new HashMap<String, ObjectPersistensyService>();

    private SubsystemPersistencyService(Agent a) {
        this.agent = a;
    }

    public static SubsystemPersistencyService create(Agent a) {
        SubsystemPersistencyService sps = new SubsystemPersistencyService(a);
        FieldAnnotationScanner fas = new FieldAnnotationScanner(Persist.class);
        ComponentLookup lookup = a.getComponentLookup();
        TreeWalkerUtils.proceduralBiWalk(lookup, null, Object.class, (n, o) -> {
            ReflectObject so = fas.scan(o);
            if (so != null) {
                ObjectPersistensyService ops = new ObjectPersistensyService(o);
                ops.fields.putAll(so.getFields());
                sps.objectMap.put(n.getKey(), ops);
            }
        }, null);
        if (sps.objectMap.isEmpty()) {
            return null;
        }
        lookup.addComponentNodeToLookup(lookup.getTopComponentNode().getKey(), new ComponentNode(lookup.getTopComponentNode(), "persistencyService", (Object)sps));
        return sps;
    }

    @Override
    public void preStart() {
        this.persistencyFileName = "persist_" + this.agent.getDescription();
        this.load();
    }

    @Command(description="writes persistent data in local file")
    public void persistNow() throws IOException {
        PrintWriter printWriter = this.wp.getPrintWriter(this.persistencyFileName);
        for (Map.Entry<String, ObjectPersistensyService> objEntry : this.objectMap.entrySet()) {
            ObjectPersistensyService obj = objEntry.getValue();
            for (Map.Entry field : obj.fields.entrySet()) {
                Field f = (Field)field.getValue();
                try {
                    f.setAccessible(true);
                    Object val = f.get(obj.target);
                    f.setAccessible(false);
                    String strVal = TypeUtils.stringify((Object)val);
                    printWriter.println(objEntry.getKey() + "/" + (String)field.getKey() + " = " + strVal);
                }
                catch (IllegalAccessException ex) {
                    log.error((Object)("could not persist field : " + objEntry.getKey() + "/" + (String)field.getKey()), (Throwable)ex);
                }
            }
        }
        printWriter.flush();
        printWriter.close();
    }

    public void load() {
        Properties props = null;
        try {
            props = this.wp.getProperties(this.persistencyFileName);
        }
        catch (IOException ex) {
            throw new RuntimeException("could not open persisted data file");
        }
        if (props == null) {
            return;
        }
        for (Map.Entry<Object, Object> prop : props.entrySet()) {
            Field f;
            String name = (String)prop.getKey();
            String val = (String)prop.getValue();
            ParameterPath pp = ParameterPath.valueOf((String)name);
            ObjectPersistensyService ops = this.objectMap.get(pp.getComponentName());
            if (ops == null || (f = (Field)ops.fields.get(pp.getParameterName())) == null) continue;
            Object objVal = InputConversionEngine.convertArgToType((String)val, (Type)f.getGenericType());
            try {
                f.setAccessible(true);
                f.set(ops.target, objVal);
                f.setAccessible(false);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException("cannot set " + pp, ex);
            }
        }
    }

    private static class ObjectPersistensyService {
        private final Object target;
        private final Map<String, Field> fields = new HashMap<String, Field>();

        private ObjectPersistensyService(Object obj) {
            this.target = obj;
        }
    }
}

