/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.tripplitepdu;

import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;

public class TrippLitePDU
extends Ascii {
    public static int timeout = 200;
    public static final int DEFAULT_BAUD = 9600;
    public static final String DEFAULT_DEV = "/dev/ttyS1";
    private final Ascii.Terminator terminator = Ascii.Terminator.CR;
    private final Thread readW = new Thread(new TLReader());
    private boolean readWstarted = false;
    private int last_state = -1;
    private int nRead = 0;
    private int nByte = 0;
    private int nTimeout = 0;
    private boolean open = false;

    public void open(DriverConstants.ConnType connType, String devName, int parm, int dataChar) throws DriverException {
        super.open(connType, devName, parm, 0);
        this.setTimeout(timeout);
    }

    public void open(String devname, int baud) throws DriverException {
        this.openSerial(devname, baud);
    }

    public void openserial(String devname, int baud) throws DriverException {
        System.out.println("openning connection to the PDU");
        this.openSerial(devname, baud);
        this.setTerminator(this.terminator);
        System.out.println("Sending returns to get its attention.");
        this.writeTrippLite("");
        System.out.println("Sending username.");
        this.writeTrippLite("localadmin");
        System.out.println("Sending password.");
        this.writeTrippLite("localadmin");
    }

    public void openftdi(String devname, int baud, int major_version) throws DriverException {
        System.out.println("openning connection to the PDU");
        this.openFtdi(devname, baud);
        this.setTerminator(this.terminator);
        System.out.println("Sending esc to get its attention.");
        System.out.println("Sending username.");
        this.writeTrippLite("localadmin");
        System.out.println("Sending password.");
        this.writeTrippLite("localadmin");
    }

    public void opennet(String netaddress, int port, int major_version) throws DriverException {
        System.out.println("openning connection to the PDU");
        this.openNet(netaddress, port);
        this.setTerminator(this.terminator);
        System.out.println("#1:" + this.readTrippLite(""));
        this.sleep(1.0);
        System.out.println("#2:" + this.readTrippLite());
        System.out.println("#2.1:" + this.readTrippLite());
        System.out.println("#2.2:" + this.readTrippLite());
        System.out.println("Sending username.");
        System.out.println("#2.3:" + this.readTrippLite("localadmin"));
        this.sleep(1.0);
        System.out.println("Sending password.");
        System.out.println("#3:" + this.readTrippLite("localadmin"));
        System.out.println(this.readTrippLite(""));
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException ex) {
            System.out.println("Sleep was interrupted:" + ex);
        }
        System.out.println(this.readTrippLite(""));
        System.out.println("Done");
        this.open = true;
        if (!this.readWstarted) {
            this.readW.setDaemon(true);
            this.readW.start();
            this.readWstarted = true;
        }
        this.flush();
    }

    public void close() throws DriverException {
        super.close();
        this.open = false;
    }

    public boolean isOutletOn(int chan) throws DriverException, DriverTimeoutException {
        this.setTimeout(timeout);
        this.writeTrippLite("M");
        this.sleep(1.0);
        this.flush();
        this.writeTrippLite("1");
        this.sleep(1.0);
        this.flush();
        this.writeTrippLite("5");
        this.sleep(1.0);
        this.flush();
        this.writeTrippLite("1");
        this.sleep(1.0);
        this.flush();
        this.last_state = -1;
        this.writeTrippLite(String.valueOf(chan));
        for (int i = 0; i < 5 && this.last_state <= -1; ++i) {
            this.sleep(1.0);
            this.flush();
        }
        if (this.last_state < 0) {
            throw new DriverTimeoutException("Failed to retrieve outlet state.");
        }
        return this.last_state == 1;
    }

    public void setOutletState(int chan, boolean state) throws DriverException {
        Object response = null;
        this.setTimeout(timeout);
        System.out.println("SetOutletState called for outlet " + chan + " to be set to state " + state);
        this.writeTrippLite("M");
        this.sleep(1.0);
        this.flush();
        this.writeTrippLite("1");
        this.sleep(1.0);
        this.flush();
        this.writeTrippLite("5");
        this.sleep(1.0);
        this.flush();
        this.writeTrippLite("1");
        this.sleep(1.0);
        this.flush();
        this.last_state = -1;
        this.writeTrippLite(String.valueOf(chan));
        this.sleep(1.0);
        this.flush();
        System.out.println("checking state");
        for (int i = 0; i < 5 && this.last_state <= -1; ++i) {
            this.sleep(1.0);
        }
        if (this.last_state < 0) {
            throw new DriverTimeoutException("Failed to retrieve outlet state.");
        }
        if (this.last_state == 1 && !state || this.last_state == 0 && state) {
            System.out.println("toggling to desired state");
            this.writeTrippLite("3");
            this.sleep(1.0);
            this.flush();
            System.out.println("confirming:");
            this.writeTrippLite("YES");
            this.sleep(1.0);
            this.flush();
        }
    }

    public void setOutletState2(int chan, boolean state) throws DriverException {
        String response = null;
        System.out.println("SetOutletState called for outlet " + chan + " to be set to state " + state);
        System.out.println("going to main menu:" + this.readTrippLite("M"));
        this.sleep(1.0);
        System.out.println(this.readTrippLite(""));
        this.sleep(1.0);
        System.out.println("device manager" + this.readTrippLite("1"));
        this.sleep(1.0);
        System.out.println(this.readTrippLite(""));
        this.sleep(1.0);
        System.out.println("load manager" + this.readTrippLite("5"));
        this.sleep(2.0);
        System.out.println(this.readTrippLite(""));
        this.sleep(2.0);
        System.out.println("control load" + this.readTrippLite("1"));
        this.sleep(2.0);
        System.out.println(this.readTrippLite(""));
        this.sleep(1.0);
        System.out.println("specifying outlet to control");
        response = this.readTrippLite(String.valueOf(chan));
        System.out.println(response);
        this.sleep(1.0);
        System.out.println(this.readTrippLite(""));
        this.sleep(1.0);
        System.out.println("checking state");
        if (this.last_state == 1 && !state || this.last_state == 0 && state) {
            System.out.println("toggling to desired state" + this.readTrippLite("3"));
            System.out.println(this.readTrippLite(""));
            System.out.println("confirming: " + this.readTrippLite("YES"));
            System.out.println(this.readTrippLite(""));
        }
    }

    public synchronized void writeTrippLite(String command) throws DriverException {
        this.write(command);
    }

    public synchronized String readTrippLite() throws DriverException {
        return this.read();
    }

    public synchronized String readTrippLite(String command) throws DriverException {
        this.writeTrippLite(command);
        return this.readTrippLite();
    }

    private void sleep(double secs) {
        try {
            Thread.sleep((int)(secs * 1000.0));
        }
        catch (InterruptedException ex) {
            System.out.println("Rude awakening!" + ex);
        }
    }

    private class TLReader
    implements Runnable {
        private TLReader() {
        }

        @Override
        public void run() {
            System.out.println(TrippLitePDU.this.open);
            while (true) {
                if (TrippLitePDU.this.open) {
                    try {
                        String reply = TrippLitePDU.this.read();
                        if (reply.contains("Turn Load")) {
                            System.out.println("***** FOUND LOAD STATE *****");
                            TrippLitePDU.this.last_state = 1;
                            if (reply.indexOf("On") >= 1) {
                                TrippLitePDU.this.last_state = 0;
                            }
                        }
                        System.out.println(reply);
                        TrippLitePDU.this.nRead++;
                        TrippLitePDU.this.nByte = TrippLitePDU.this.nByte + reply.length();
                    }
                    catch (DriverTimeoutException e) {
                        TrippLitePDU.this.nTimeout++;
                    }
                    catch (DriverException e) {
                        if (!TrippLitePDU.this.open) continue;
                        System.out.println((Object)e);
                    }
                    continue;
                }
                TrippLitePDU.this.sleep(0.2);
            }
        }
    }
}

