/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.doorman.main;

import java.util.Optional;
import java.util.stream.Stream;
import org.lsst.ccs.subsystem.doorman.main.DoorChannelType;

public enum DoorChannel {
    AIR_OUTLET_TEMP("airOutletTemp", DoorChannelType.ANALOG, 2),
    RETURN_WATER_TEMP("returnWaterTemp", DoorChannelType.ANALOG, 6),
    VALVE_OUTPUT("valveOutput", DoorChannelType.ANALOG, 9),
    ROOM_TEMP("roomTemp", DoorChannelType.ANALOG, 10),
    SERVER_OUTLET_AIR_TEMP("serverOutletAirTemp", DoorChannelType.ANALOG, 17),
    FAN1_SPEED("fan1Speed", DoorChannelType.INTEGER, 5016),
    FAN2_SPEED("fan2Speed", DoorChannelType.INTEGER, 5017),
    FAN3_SPEED("fan3Speed", DoorChannelType.INTEGER, 5018),
    FAN4_SPEED("fan4Speed", DoorChannelType.INTEGER, 5019),
    FAN5_SPEED("fan5Speed", DoorChannelType.INTEGER, 5020),
    CLOCK_DAY("clockDay", DoorChannelType.INTEGER, 5032),
    CLOCK_MONTH("clockMonth", DoorChannelType.INTEGER, 5033),
    CLOCK_YEAR("clockYear", DoorChannelType.INTEGER, 5034),
    CLOCK_HOUR("clockHour", DoorChannelType.INTEGER, 5035),
    CLOCK_MINUTE("clockMinute", DoorChannelType.INTEGER, 5036),
    HIGH_AIR_TEMP("highAirTemp", DoorChannelType.DIGITAL, 14),
    HIGH_WATER_TEMP("highWaterTemp", DoorChannelType.DIGITAL, 15),
    LOW_WATER_TEMP("lowWaterTemp", DoorChannelType.DIGITAL, 16),
    UNIT_STATE("unitState", DoorChannelType.DIGITAL, 17),
    WATER_DETECTED("waterDetected", DoorChannelType.DIGITAL, 22),
    GENERAL_ALARM("generalAlarm", DoorChannelType.DIGITAL, 23),
    CLOCK_ALARM("clockAlarm", DoorChannelType.DIGITAL, 24),
    HIGH_ROOM_TEMP("highRoomTemp", DoorChannelType.DIGITAL, 25),
    LOW_ROOM_TEMP("lowRoomTemp", DoorChannelType.DIGITAL, 26),
    FAN1_ALARM("fan1Alarm", DoorChannelType.DIGITAL, 30),
    FAN2_ALARM("fan2Alarm", DoorChannelType.DIGITAL, 31),
    FAN3_ALARM("fan2Alarm", DoorChannelType.DIGITAL, 32),
    FAN4_ALARM("fan3Alarm", DoorChannelType.DIGITAL, 33),
    FAN5_ALARM("fan4Alarm", DoorChannelType.DIGITAL, 34),
    HIGH_SERVER_OUTLET_TEMP("highServerOutletTemp", DoorChannelType.DIGITAL, 37),
    HIGH_FAN_PRESSURE("highFanPressure", DoorChannelType.DIGITAL, 40),
    B4_ALARM("b4Alarm", DoorChannelType.DIGITAL, 58),
    LOW_AIR_SUPPLY_TEMP("lowAirSupplyTemp", DoorChannelType.DIGITAL, 59),
    DOOR_OPEN("doorOpen", DoorChannelType.DIGITAL, 60);

    private final String key;
    private final DoorChannelType type;
    private final int register;

    private DoorChannel(String key, DoorChannelType type, int register) {
        this.key = key;
        this.type = type;
        this.register = register;
    }

    public String getKey() {
        return this.key;
    }

    public DoorChannelType getType() {
        return this.type;
    }

    public int getRegister() {
        return this.register;
    }

    public static Optional<DoorChannel> parse(String key) {
        return Stream.of(DoorChannel.values()).filter(chan -> key.equalsIgnoreCase(chan.getKey())).findAny();
    }
}

