/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.rotator;

import java.io.Serializable;

public class RotatorState
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int HEX_FOLLOWING_ERROR_MASK = 1;
    public static final int HEX_MOVE_COMPLETE_MASK = 2;
    public static final int COMMAND_REJECT_MASK = 32;
    public static final int SAFETY_INTERLOCK = 64;
    public static final int EXTEND_LIMIT_SWITCH = 128;
    public static final int RETRACT_LIMIT_SWITCH = 256;
    public static final int ETHERCAT_PROBLEM = 512;
    public static final int DDS_COMMAND_SOURCE = 1024;
    public static final int MOTION_TIMEOUT = 2048;
    public static final int DRIVE_FAULT = 8192;
    public static final int SIMULINK_FAULT = 16384;
    public static final int ENCODER_FAULT = 32768;
    private final RotatorSummaryState rotatorSummaryState;
    private final OfflineState offlineState;
    private final EnabledState enabledState;
    private final int applicationStatus;

    RotatorState(RotatorSummaryState rotatorSummaryState, OfflineState offlineState, EnabledState enabledState, int applicationStatus) {
        this.rotatorSummaryState = rotatorSummaryState;
        this.offlineState = offlineState;
        this.enabledState = enabledState;
        this.applicationStatus = applicationStatus;
    }

    public RotatorSummaryState getRotatorSummaryState() {
        return this.rotatorSummaryState;
    }

    public OfflineState getOfflineState() {
        return this.offlineState;
    }

    public EnabledState getEnabledState() {
        return this.enabledState;
    }

    public int getApplicationStatus() {
        return this.applicationStatus;
    }

    public String toString() {
        return "RotatorState{controllerState=" + (Object)((Object)this.rotatorSummaryState) + ", offlineState=" + (Object)((Object)this.offlineState) + ", enabledState=" + (Object)((Object)this.enabledState) + ", applicationStatus=" + Integer.toHexString(this.applicationStatus) + '}';
    }

    public static enum EnabledState {
        STATIONARY,
        MOVING_POINT_TO_POINT,
        SLEWING_OR_TRACKING,
        CONTROLLED_STOP,
        INITIALIZING,
        RELATIVE,
        CONSTANT_VOLOCITY;

    }

    public static enum OfflineState {
        PUBLISH_ONLY,
        AVAILABLE;

    }

    public static enum RotatorSummaryState {
        STANDBY,
        DISABLED,
        ENABLED,
        OFFLINE,
        FAULT;

    }
}

