/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.keithley;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.keithley.Model2231A;
import org.lsst.ccs.drivers.scpi.Scpi;
import org.lsst.ccs.drivers.scpi.TestScpi;

public class Test2231A
extends TestScpi {
    private final Model2231A ps = (Model2231A)this.scpi;
    private int chanNum = 1;

    public Test2231A() {
        super((Scpi)new Model2231A());
    }

    @Command(name="setchannel", description="Set the current channel")
    public void setChannel(@Argument(description="Channel number") int chan) {
        this.chanNum = chan;
    }

    @Command(name="showchannel", description="Show the set channel")
    public String showChannel() {
        return "Channel = " + this.chanNum;
    }

    @Command(name="setvoltage", description="Set the voltage")
    public void setVoltage(@Argument(description="Voltage to set") double value) throws DriverException {
        this.ps.setVoltage(value, this.chanNum);
    }

    @Command(name="setvoltage", description="Set the voltage")
    public void setVoltage(@Argument(description="Voltage to set") double value, @Argument(description="Channel number") int chan) throws DriverException {
        this.ps.setVoltage(value, chan);
    }

    @Command(name="setvoltages", description="Set all the voltages")
    public void setVoltages(double ... values) throws DriverException {
        this.ps.setVoltage(values);
    }

    @Command(name="setmaxvoltage", description="Set the voltage to maximum")
    public void setMaxVoltage() throws DriverException {
        this.ps.setVoltage(Double.POSITIVE_INFINITY, this.chanNum);
    }

    @Command(name="setmaxvoltage", description="Set the voltage to maximum")
    public void setMaxVoltage(@Argument(description="Channel number") int chan) throws DriverException {
        this.ps.setVoltage(Double.POSITIVE_INFINITY, chan);
    }

    @Command(name="showmaxvoltage", description="Show the maximum voltage")
    public String showMaxVoltage() throws DriverException {
        return "Maximum voltage = " + this.ps.getMaximumVoltage(this.chanNum);
    }

    @Command(name="showmaxvoltage", description="Show the maximum voltage")
    public String showMaxVoltage(@Argument(description="Channel number") int chan) throws DriverException {
        return "Maximum voltage = " + this.ps.getMaximumVoltage(chan);
    }

    @Command(name="showvoltage", description="Show the set voltage")
    public String showVoltage() throws DriverException {
        return "Voltage = " + this.ps.getVoltage(this.chanNum);
    }

    @Command(name="showvoltage", description="Show the set voltage")
    public String showVoltage(@Argument(description="Channel number") int chan) throws DriverException {
        return "Voltage = " + this.ps.getVoltage(chan);
    }

    @Command(name="showvoltages", description="Show all the set voltages")
    public String showVoltages() throws DriverException {
        return "Voltages = " + Test2231A.getString(this.ps.getVoltage());
    }

    @Command(name="readvoltage", description="Read the actual voltage")
    public String readVoltage() throws DriverException {
        return "Voltage = " + this.ps.readVoltage(this.chanNum);
    }

    @Command(name="readvoltage", description="Read the actual voltage")
    public String readVoltage(@Argument(description="Channel number") int chan) throws DriverException {
        return "Voltage = " + this.ps.readVoltage(chan);
    }

    @Command(name="setvoltlim", description="Set the soft voltage limit")
    public void setVoltageLimit(@Argument(description="Voltage limit to set") double value) throws DriverException {
        this.ps.setVoltageLimit(value, this.chanNum);
    }

    @Command(name="setvoltlim", description="Set the soft voltage limit")
    public void setVoltageLimit(@Argument(description="Voltage limit to set") double value, @Argument(description="Channel number") int chan) throws DriverException {
        this.ps.setVoltageLimit(value, chan);
    }

    @Command(name="showvoltlim", description="Show the soft voltage limit")
    public String showVoltageLimit() throws DriverException {
        return "Voltage limit = " + this.ps.getVoltageLimit(this.chanNum);
    }

    @Command(name="showvoltlim", description="Show the soft voltage limit")
    public String showVoltageLimit(@Argument(description="Channel number") int chan) throws DriverException {
        return "Voltage limit = " + this.ps.getVoltageLimit(chan);
    }

    @Command(name="setcurrent", description="Set the current")
    public void setCurrent(@Argument(description="Current to set") double value) throws DriverException {
        this.ps.setCurrent(value, this.chanNum);
    }

    @Command(name="setcurrent", description="Set the current")
    public void setCurrent(@Argument(description="Current to set") double value, @Argument(description="Channel number") int chan) throws DriverException {
        this.ps.setCurrent(value, chan);
    }

    @Command(name="setcurrents", description="Set all the currents")
    public void setCurrents(double ... values) throws DriverException {
        this.ps.setCurrent(values);
    }

    @Command(name="setmaxcurrent", description="Set the current to maximum")
    public void setMaxCurrent() throws DriverException {
        this.ps.setVoltage(Double.POSITIVE_INFINITY, this.chanNum);
    }

    @Command(name="setmaxcurrent", description="Set the current to maximum")
    public void setMaxCurrent(@Argument(description="Channel number") int chan) throws DriverException {
        this.ps.setVoltage(Double.POSITIVE_INFINITY, chan);
    }

    @Command(name="showmaxcurrent", description="Show the set current")
    public String showMaxCurrent() throws DriverException {
        return "Maximum current = " + this.ps.getMaximumCurrent(this.chanNum);
    }

    @Command(name="showmaxcurrent", description="Show the set current")
    public String showMaxCurrent(@Argument(description="Channel number") int chan) throws DriverException {
        return "Maximum current = " + this.ps.getMaximumCurrent(chan);
    }

    @Command(name="showcurrent", description="Show the set current")
    public String showCurrent() throws DriverException {
        return "Current = " + this.ps.getCurrent(this.chanNum);
    }

    @Command(name="showcurrent", description="Show the set current")
    public String showCurrent(@Argument(description="Channel number") int chan) throws DriverException {
        return "Current = " + this.ps.getCurrent(chan);
    }

    @Command(name="showcurrents", description="Show the set current")
    public String showCurrents() throws DriverException {
        return "Currents = " + Test2231A.getString(this.ps.getCurrent());
    }

    @Command(name="readcurrent", description="Read the actual current")
    public String readCurrent() throws DriverException {
        return "Current = " + this.ps.readCurrent(this.chanNum);
    }

    @Command(name="readcurrent", description="Read the actual current")
    public String readCurrent(@Argument(description="Channel number") int chan) throws DriverException {
        return "Current = " + this.ps.readCurrent(chan);
    }

    @Command(name="setondelay", description="Set output on delay")
    public void setOnDelay(@Argument(description="Output on delay") double delay) throws DriverException {
        this.ps.setOnDelay(delay, this.chanNum);
    }

    @Command(name="setondelay", description="Set output on delay")
    public void setOnDelay(@Argument(description="Output on delay") double delay, @Argument(description="Channel number") int chan) throws DriverException {
        this.ps.setOnDelay(delay, chan);
    }

    @Command(name="setoffdelay", description="Set output off delay")
    public void setOffDelay(@Argument(description="Output off delay") double delay) throws DriverException {
        this.ps.setOffDelay(delay, this.chanNum);
    }

    @Command(name="setoffdelay", description="Set output off delay")
    public void setOffDelay(@Argument(description="Output off delay") double delay, @Argument(description="Channel number") int chan) throws DriverException {
        this.ps.setOffDelay(delay, chan);
    }

    @Command(name="setoutput", description="Turn output on or off")
    public void setOutput(@Argument(description="Output state: on or off") OnOff state) throws DriverException {
        this.ps.setOutput(state == OnOff.ON, this.chanNum);
    }

    @Command(name="setoutput", description="Turn output on or off")
    public void setOutput(@Argument(description="Output state: on or off") OnOff state, @Argument(description="Channel number") int chan) throws DriverException {
        this.ps.setOutput(state == OnOff.ON, chan);
    }

    @Command(name="showoutput", description="Show the output state")
    public String showOutput() throws DriverException {
        return "Output state = " + Test2231A.getOnOff(this.ps.getOutput(this.chanNum));
    }

    @Command(name="showoutput", description="Show the output state")
    public String showOutput(@Argument(description="Channel number") int chan) throws DriverException {
        return "Output state = " + Test2231A.getOnOff(this.ps.getOutput(chan));
    }

    @Command(name="lock", description="Lock the front panel")
    public void lock() throws DriverException {
        this.ps.lockPanel(true);
    }

    @Command(name="unlock", description="Unlock the front panel")
    public void unlock() throws DriverException {
        this.ps.lockPanel(false);
    }

    @Command(name="timeread", description="Time voltage reading")
    public void timeRead(@Argument(description="Channel number") int chan, @Argument(description="Read count") int count) throws DriverException {
        for (int j = 0; j < 4; ++j) {
            double volts = 0.5 * (double)j;
            this.ps.setVoltage(volts, chan);
            long startTime = System.currentTimeMillis();
            System.out.println("Voltage set: " + volts);
            for (int k = 0; k < count; ++k) {
                double value = this.ps.readVoltage(chan);
                System.out.println("Voltage read at " + (System.currentTimeMillis() - startTime) + " ms: " + value);
            }
        }
    }

    private static StringBuilder getString(double[] values) {
        StringBuilder text = new StringBuilder();
        text.append(values[0]);
        for (int j = 1; j < values.length; ++j) {
            text.append(", ").append(values[j]);
        }
        return text;
    }

    private static StringBuilder getString(boolean[] values) {
        StringBuilder text = new StringBuilder();
        text.append(values[0] ? "on" : "off");
        for (int j = 1; j < values.length; ++j) {
            text.append(", ").append(values[j] ? "on" : "off");
        }
        return text;
    }

    private static String getOnOff(boolean on) {
        return on ? "on" : "off";
    }

    public static enum OnOff {
        OFF,
        ON;

    }
}

