/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.airwatch.main;

import java.io.Serializable;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.airwatch.main.Alerts;
import org.lsst.ccs.subsystem.airwatch.main.DataPoint;

public class CounterPoint
extends DataPoint {
    private final Double absolute;
    private final Double density;

    public CounterPoint(Double absolute, Double density, boolean limitViolation, boolean malfunction, String quality, String time) {
        super(limitViolation, malfunction, quality, time);
        this.absolute = absolute;
        this.density = density;
    }

    CounterPoint() {
        this(0.0, 0.0, false, false, "Good", "2021-05-22T13:55:21-07:00");
    }

    public final Double getAbsolute() {
        return this.absolute;
    }

    public final Double getDensity() {
        return this.density;
    }

    @Override
    public final KeyValueDataList makeKvdList(String locName, String chanName) {
        KeyValueDataList kvdl = super.makeKvdList(locName, chanName);
        kvdl.addData(kvdl.getKey() + "/density", (Serializable)this.getDensity());
        kvdl.addData(kvdl.getKey() + "/absolute", (Serializable)this.getAbsolute());
        return kvdl;
    }

    @Override
    public final void checkData(AlertService alsvc, String locName, String chanName) {
        if (!this.getQuality().equals("Good") || this.hasMalfunction()) {
            alsvc.raiseAlert(Alerts.dataQualityAlert(locName, chanName), AlertState.WARNING, String.format("Data quality = %s, malfunction = %s.", this.getQuality(), this.hasMalfunction()), AlertService.RaiseAlertStrategy.ON_SEVERITY_CHANGE);
        }
        if (this.hasLimitViolation()) {
            alsvc.raiseAlert(Alerts.limitViolationAlert(locName, chanName), AlertState.WARNING, String.format("Particle density of %.4g/ft^3 is above the operating limit.", this.getDensity()), AlertService.RaiseAlertStrategy.ON_SEVERITY_CHANGE);
        }
    }

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CounterPoint{absolute=").append(this.absolute);
        sb.append(", density=").append(this.density);
        sb.append(", ");
        sb.append(super.toString());
        sb.append('}');
        return sb.toString();
    }
}

