/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.camera.rotator;

import java.util.logging.Logger;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.drivers.rotator.RotatorState;
import org.lsst.ccs.drivers.rotator.RotatorStateChangeListener;
import org.lsst.ccs.drivers.rotator.RotatorStateChangedEvent;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.camera.rotator.CameraRotatorSubsystem;
import org.lsst.ccs.subsystem.camera.rotator.alerts.CameraRotatorAlerts;
import org.lsst.ccs.subsystem.camera.rotator.states.CameraRotatorState;

public class RotatorSubsystemSetState
implements RotatorStateChangeListener {
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private CameraRotatorSubsystem subsys;
    private static final Logger LOG = Logger.getLogger(RotatorSubsystemSetState.class.getName());
    private RotatorState.RotatorSummaryState summaryState = RotatorState.RotatorSummaryState.ENABLED;
    private RotatorState.EnabledState enabledState = RotatorState.EnabledState.STATIONARY;

    public void stateChanged(RotatorStateChangedEvent event) {
        RotatorState newState = event.getRotatorState();
        LOG.info("RotatorSubsystem received state change: " + newState.toString());
        RotatorState.RotatorSummaryState newSummary = newState.getRotatorSummaryState();
        RotatorState.EnabledState newEnabled = newState.getEnabledState();
        if (newSummary != this.summaryState) {
            boolean fault = this.summaryState.equals((Object)RotatorState.RotatorSummaryState.FAULT);
            boolean not_en = !fault && !this.summaryState.equals((Object)RotatorState.RotatorSummaryState.ENABLED);
            this.summaryState = newSummary;
            switch (newSummary) {
                case FAULT: {
                    if (!fault) {
                        this.alertService.raiseAlert(CameraRotatorAlerts.ROTATOR_FAULT.newAlert(), AlertState.ALARM, "StateChange to FAULT");
                        this.subsys.publishState(CameraRotatorState.FAULT);
                        if (not_en) {
                            this.restore(CameraRotatorAlerts.NOT_ENABLED);
                        }
                    }
                    return;
                }
                case ENABLED: {
                    if (not_en) {
                        this.restore(CameraRotatorAlerts.NOT_ENABLED);
                    }
                    if (!fault) break;
                    this.restore(CameraRotatorAlerts.ROTATOR_FAULT);
                    break;
                }
                default: {
                    if (!not_en) {
                        this.alertService.raiseAlert(CameraRotatorAlerts.NOT_ENABLED.newAlert(), AlertState.ALARM, "StateChange, not enabled");
                        this.subsys.publishState(CameraRotatorState.NOT_ENABLED);
                    }
                    if (fault) {
                        this.restore(CameraRotatorAlerts.ROTATOR_FAULT);
                    }
                    return;
                }
            }
        }
        if (!newEnabled.equals((Object)this.enabledState)) {
            switch (newEnabled) {
                case STATIONARY: {
                    this.subsys.publishState(CameraRotatorState.STOPPED);
                    this.subsys.publishData(this.subsys.getPosition());
                    break;
                }
                case MOVING_POINT_TO_POINT: 
                case CONTROLLED_STOP: {
                    this.subsys.publishState(CameraRotatorState.ROTATING);
                    break;
                }
                default: {
                    this.subsys.publishState(CameraRotatorState.OTHER);
                }
            }
            this.enabledState = newEnabled;
        }
    }

    private void restore(CameraRotatorAlerts alert) {
        this.alertService.raiseAlert(alert.newAlert(), AlertState.NOMINAL, "StateChange, reset Alert");
    }
}

