/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.teststand;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.agilent.E3631;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.subsystem.teststand.LEDDevice;
import org.lsst.ccs.subsystem.teststand.data.TSConfig;
import org.lsst.ccs.subsystem.teststand.data.TSState;
import org.lsst.ccs.utilities.logging.Logger;

public class AgilentDevice
extends Device
implements LEDDevice {
    private static final Map<String, Integer> typeMap = new HashMap<String, Integer>();
    private E3631 agips = null;
    private boolean isconnected = false;
    TSConfig cfg = new TSConfig();
    private String outname = "";
    private double[] runBias = new double[TSConfig.MAXSTATES];
    TSState.pwrstates kstate = TSState.pwrstates.NOTCONFIGURED;
    boolean failedToInitialize = false;

    public AgilentDevice(String host, int port) throws DriverException {
        this.isconnected = true;
        try {
            this.agips = new E3631();
            if (this.agips != null) {
                this.agips.openftdi(host, port);
            }
        }
        catch (DriverException f) {
            System.out.println("Failed to open connection to Agilent device!");
            this.isconnected = false;
        }
        if (this.isconnected) {
            if (this.agips != null) {
                for (E3631.OutputName outname : E3631.OutputName.values()) {
                    this.agips.setVoltage(outname.getValue(), 0.0);
                }
            }
            if (this.agips != null) {
                for (E3631.OutputName outname : E3631.OutputName.values()) {
                    this.agips.outputOff(outname.getValue());
                }
                this.kstate = TSState.pwrstates.OFF;
            }
        }
    }

    public AgilentDevice() {
        try {
            this.agips = new E3631();
        }
        catch (DriverException f) {
            System.out.println("Failed to create to Agilent device instance!");
        }
    }

    protected void initDevice() {
        this.fullName = "Agilent module";
    }

    protected void close() {
        try {
            if (this.agips != null) {
                this.agips.close();
            }
            this.kstate = TSState.pwrstates.NOTCONFIGURED;
        }
        catch (DriverException e) {
            this.log.error((Object)"Agilent device failed to close!!!");
        }
    }

    protected void initialize() {
        if (this.isconnected) {
            this.log.debug((Object)"Agilent device is already initialized and connected to:");
            try {
                this.log.debug((Object)this.agips.getID());
            }
            catch (Exception e) {
                if (!this.failedToInitialize) {
                    this.log.error((Object)"Agilent device failed to respond to ident request! The initialization has FAILED.");
                    this.failedToInitialize = true;
                }
                this.isconnected = false;
            }
            this.log.debug((Object)"Setting device online.");
            this.kstate = TSState.pwrstates.OK;
            this.setOnline(true);
        } else if (!this.failedToInitialize) {
            this.log.error((Object)"Tried to initialize unconnected LED device!");
            this.failedToInitialize = true;
        }
    }

    @Command(name="openftdi", description="Open FTDI connection to device")
    public String openftdi(@Argument(name="serialname", description="Serial device name") String host, @Argument(name="baud", description="baud rate") int port) throws DriverException {
        this.agips.openftdi(host, port);
        this.kstate = TSState.pwrstates.OK;
        return this.agips.getID();
    }

    @Override
    @Command(name="setvoltagerange", description="Set the voltage range. Can be 10V, 50V or 500V")
    public void setVoltageRange(@Argument(name="value", description="Voltage Range to set") double value) {
        this.log.error((Object)"function not available!");
    }

    @Command(name="selectoutput", description="Select the output for control")
    public void selectOutput(@Argument(name="value", description="outname : P6V,P25V,N25V") String value) {
        this.outname = value;
        try {
            if (this.agips != null) {
                this.agips.selectOutput(this.outname);
            }
        }
        catch (DriverException f) {
            this.log.error((Object)"Failed to select the Agilent output for control");
        }
    }

    @Override
    @Command(name="setvoltage", description="Set the voltage")
    public void setVoltage(@Argument(name="value", description="Voltage to set") double value) {
        try {
            if ((this.kstate.equals((Object)TSState.pwrstates.OK) || this.kstate.equals((Object)TSState.pwrstates.OFF)) && this.agips != null) {
                this.agips.setVoltage(this.outname, value);
            }
        }
        catch (DriverException f) {
            this.log.error((Object)"Failed to set the Agilent voltage!");
        }
    }

    @Override
    @Command(name="setvoltageacq", description="Set the voltage to the acquisition set point")
    public void setVoltageAcq(int cfgstate) {
        double value = this.getRunBias(cfgstate);
        this.rampVolts(5.0, value);
    }

    @Command(name="setrunbias", description="Sets the bias value for acquisition")
    public void setRunBias(double runBias, int cfgstate) {
        this.runBias[cfgstate] = runBias;
    }

    @Command(name="getrunbias", description="Returns the bias value for acquisition")
    public double getRunBias(int cfgstate) {
        return this.runBias[cfgstate];
    }

    @Override
    @Command(name="rampvolts", description="ramp the voltage")
    public void rampVolts(@Argument(name="duration", description="number of seconds to ramp from current voltage to desired voltage") double duration, @Argument(name="value", description="Voltage to ramp to") double value) {
        this.log.error((Object)"function not available yet!");
    }

    @Override
    @Command(name="rampvolts", description="ramp the voltage")
    public void rampVolts(@Argument(name="duration", description="number of seconds to ramp from current voltage to desired voltage") double duration, @Argument(name="value", description="Voltage to ramp to") double value, @Argument(name="nsteps", description="number of steps") int nsteps) {
        this.log.error((Object)"function not available");
    }

    @Command(name="showvoltage", description="Show the set voltage")
    public String getVoltage() throws DriverException {
        return "Voltage = " + this.agips.getVoltage();
    }

    @Override
    @Command(name="readvoltage", description="Read the actual voltage")
    public double readVoltage() {
        double volt = 0.0;
        try {
            volt = this.agips.getVoltage(this.outname);
        }
        catch (DriverException e) {
            this.log.error((Object)"Agilent driver failed to read voltage!");
        }
        return volt;
    }

    @Command(name="setvoltlim", description="Set the soft voltage limit")
    public void setVoltageLimit(@Argument(name="value", description="Voltage limit to set") double value) throws DriverException {
        this.log.error((Object)"function not available!");
    }

    @Command(name="showvoltlim", description="Show the soft voltage limit")
    public String getVoltageLimit() throws DriverException {
        return "function not available";
    }

    @Command(name="setcurrentrange", description="Set the current range")
    public void setCurrentRange(@Argument(name="value", description="Current Range to set") double value) throws DriverException {
        if (this.agips != null) {
            this.log.error((Object)"function not available!");
        }
    }

    @Command(name="setcurrent", description="Set the current")
    public void setCurrent(@Argument(name="value", description="Current to set") double value) {
        try {
            if (this.agips != null) {
                this.agips.setCurrent(this.outname, value);
            }
        }
        catch (DriverException f) {
            this.log.error((Object)"Agilent driver failed to set current!");
        }
    }

    @Command(name="zerocorrectcurrent", description="Zero correct the current")
    public void zeroCorrectCurrent() throws DriverException {
        if (this.agips != null) {
            this.log.error((Object)"function not available!");
        }
    }

    @Command(name="showcurrent", description="Show the set current")
    public double getCurrent() {
        double curr = 0.0;
        this.log.error((Object)"can only show the current measurement");
        return curr;
    }

    @Command(type=Command.CommandType.ACTION, name="readcurrent", description="Read the actual current")
    public double readCurrent() {
        this.log.debug((Object)"AgilentDevice executing readcurrent operation:");
        double curr = 0.0;
        try {
            curr = this.agips.getCurrent();
        }
        catch (DriverException e) {
            this.log.error((Object)"Agilent driver failed to retrieve the current measurement!");
        }
        return curr;
    }

    @Command(name="setcurrlim", description="Set the soft current limit")
    public void setCurrentLimit(@Argument(name="value", description="Current limit to set") double value) throws DriverException {
        if (this.agips != null) {
            this.log.error((Object)"function not available");
        }
    }

    @Command(name="showcurrlim", description="Show the soft current limit")
    public String getCurrentLimit() throws DriverException {
        return "function not available";
    }

    @Override
    @Command(name="setoutput", description="Turn output on or off. 1 ==> ON")
    public void setOutput(@Argument(name="state", description="Output state: on or off") int state) {
        try {
            if ((this.kstate.equals((Object)TSState.pwrstates.OK) || this.kstate.equals((Object)TSState.pwrstates.OFF)) && this.agips != null) {
                if (state == 1) {
                    this.agips.outputOn(this.outname);
                } else {
                    this.agips.outputOff(this.outname);
                }
            }
        }
        catch (DriverException e) {
            this.log.error((Object)"Agilent driver failed to set the output state!");
        }
    }

    @Override
    @Command(name="showoutput", description="Show the output state")
    public boolean showOutput() {
        boolean state = false;
        this.log.error((Object)"function not available");
        return state;
    }

    private StringBuilder getString(double[] values) {
        StringBuilder text = new StringBuilder();
        text.append(values[0]);
        for (int j = 1; j < values.length; ++j) {
            text.append(", ").append(values[j]);
        }
        return text;
    }

    private String getOnOff(boolean on) {
        return on ? "on" : "off";
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        Integer iType = typeMap.get(type.toUpperCase());
        if (iType == null) {
            MonitorLogUtils.reportError((Logger)this.log, (String)name, (String)"type", (Object)type);
        } else if (iType != 1 && iType != 2) {
            MonitorLogUtils.reportError((Logger)this.log, (String)name, (String)"Wrong channel type specified! type = ", (Object)type);
        }
        return new int[]{iType, 0};
    }

    protected void initChannel(int chan, int type, int subtype) {
        try {
            if (type == 1) {
                this.log.debug((Object)("setting channel online - chan=" + chan));
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Error configuring channel type " + type + ": " + e));
        }
    }

    @Command(name="reset", description="reset trips etc...")
    public void reset() throws DriverException {
        if (this.agips != null) {
            this.agips.reset();
        }
        this.kstate = TSState.pwrstates.OFF;
    }

    protected double readChannel(int chan, int type) {
        double value = 0.0;
        this.log.debug((Object)("AgilentDevice readChannel called! chan=" + chan + " type=" + type));
        try {
            if (type == 1) {
                value = this.readVoltage();
            }
        }
        catch (Exception e) {
            this.log.debug((Object)("Error reading channel type " + type + ": " + e));
        }
        return value;
    }

    @Override
    @Command(name="setstate", description="set agilent device status")
    public void setState(int istate) {
        this.kstate = TSState.pwrstates.values()[istate];
    }

    @Override
    @Command(name="getstate", description="get agilent device status")
    public int getState() {
        return this.kstate.ordinal();
    }

    static {
        typeMap.put("VOLTS", 1);
    }
}

