/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.lsst.ccs.command.BasicCommand;
import org.lsst.ccs.command.CommandArgumentMatchException;
import org.lsst.ccs.command.CommandArgumentTypeException;
import org.lsst.ccs.command.CommandInvocationException;
import org.lsst.ccs.command.CommandSet;
import org.lsst.ccs.command.DefaultDictionaryCompleter;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.DictionaryArgument;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.command.DictionaryCompleter;
import org.lsst.ccs.command.DictionaryHelpGenerator;
import org.lsst.ccs.command.DictionaryUtils;
import org.lsst.ccs.command.RouteSelectionCommandSet;
import org.lsst.ccs.command.TokenizedCommand;
import org.lsst.ccs.command.annotations.Command;

public class RoutingCommandSet
implements CommandSet {
    private final RoutingDictionary dict;
    private final String route;
    private final String path;
    private final CommandSet cs;
    private final RouteSelectionCommandSet routeSelection;

    public RoutingCommandSet(String route, CommandSet cs) {
        this(null, route, route, cs);
    }

    public RoutingCommandSet(RouteSelectionCommandSet routeSelection, String route, CommandSet cs) {
        this(routeSelection, route, route, cs);
    }

    public RoutingCommandSet(RouteSelectionCommandSet routeSelection, String route, String path, CommandSet cs) {
        this.route = route;
        this.path = path;
        this.cs = cs;
        this.dict = new RoutingDictionary(routeSelection, route, cs.getCommandDictionary());
        this.routeSelection = routeSelection;
    }

    String getRoute() {
        return this.route;
    }

    String getPath() {
        return this.path;
    }

    CommandSet getRouteCommandSet() {
        return this.cs;
    }

    @Override
    public Dictionary getCommandDictionary() {
        return this.dict;
    }

    @Override
    public Object invoke(BasicCommand command) throws CommandInvocationException, CommandArgumentMatchException, CommandArgumentTypeException {
        DictionaryCommand dc = this.dict.findCommand(command);
        if (dc == null) {
            throw new CommandInvocationException("Error: Could not invoke command " + command.getCommand() + " on target " + this.getRoute(), new Object[0]);
        }
        if (command.getArgumentCount() == 0) {
            throw new CommandInvocationException("Error: To change target type the command \"set target TARGET_NAME\"", new Object[0]);
        }
        String route = command.getCommand();
        TokenizedCommand tc = (TokenizedCommand)command;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < tc.getArgumentCount(); ++i) {
            String arg = tc.getArgument(i);
            if (arg.contains(" ")) {
                arg = "\"" + arg + "\"";
            }
            sb.append(arg);
            sb.append(" ");
        }
        for (String opt : tc.getOptions().getOptions()) {
            sb.append("--").append(opt).append(" ");
        }
        TokenizedCommand routedCommand = new TokenizedCommand(sb.toString());
        return this.getRouteCommandSet().invoke(routedCommand);
    }

    static class RoutingCommand
    implements DictionaryCommand {
        private static final long serialVersionUID = 5566879570663731785L;
        private final String route;
        private final Dictionary dict;
        private final DictionaryArgument[] routingArgument;
        private final int level;

        RoutingCommand(String route, Dictionary dict) {
            this.route = route;
            this.dict = dict;
            this.routingArgument = new DictionaryArgument[]{new RoutingCommandArgument(dict), new RoutingCommandArgumentsArgument()};
            int l = 99999;
            for (DictionaryCommand dc : dict) {
                if (dc.getLevel() >= l) continue;
                l = dc.getLevel();
            }
            this.level = l;
        }

        Dictionary getDictionary() {
            return this.dict;
        }

        @Override
        public DictionaryArgument[] getArguments() {
            return this.routingArgument;
        }

        @Override
        public String getCommandName() {
            return this.route;
        }

        @Override
        public String getDescription() {
            return "Sends commands to target's (" + this.route + ") dictionary";
        }

        @Override
        public Command.CommandType getType() {
            return Command.CommandType.QUERY;
        }

        @Override
        public boolean isVarArgs() {
            return true;
        }

        @Override
        public int getLevel() {
            return this.level;
        }

        @Override
        public Command.CommandCategory getCategory() {
            return Command.CommandCategory.USER;
        }

        @Override
        public boolean isAutoAck() {
            return true;
        }

        @Override
        public Duration getTimeout() {
            return null;
        }

        private static class RoutingCommandArgument
        implements DictionaryArgument {
            private static final long serialVersionUID = -7280662026390377893L;
            private final Dictionary dict;

            RoutingCommandArgument(Dictionary dict) {
                this.dict = dict;
            }

            @Override
            public String getDescription() {
                return "The command to execute";
            }

            @Override
            public String getName() {
                return "command";
            }

            @Override
            public String getSimpleType() {
                return "String";
            }

            @Override
            public String getType() {
                return "java.lang.String";
            }

            @Override
            public List<String> getAllowedValues() {
                ArrayList<String> allowedValues = new ArrayList<String>();
                for (DictionaryCommand command : this.dict.filterByVisibilityIterator()) {
                    allowedValues.add(command.getCommandName());
                }
                return allowedValues;
            }

            @Override
            public String getDefaultValue() {
                return null;
            }
        }

        private static class RoutingCommandArgumentsArgument
        implements DictionaryArgument {
            private static final long serialVersionUID = 6523660726535011547L;

            private RoutingCommandArgumentsArgument() {
            }

            @Override
            public String getDescription() {
                return "The arguments for the command";
            }

            @Override
            public String getName() {
                return "arguments...";
            }

            @Override
            public String getSimpleType() {
                return "String";
            }

            @Override
            public String getType() {
                return "java.lang.String";
            }

            @Override
            public List<String> getAllowedValues() {
                return Collections.EMPTY_LIST;
            }

            @Override
            public String getDefaultValue() {
                return null;
            }
        }
    }

    private static class RoutingDictionaryHelpGenerator
    implements DictionaryHelpGenerator {
        private static final long serialVersionUID = 2986754545846150826L;
        private final RoutingCommand routingCommand;

        RoutingDictionaryHelpGenerator(RoutingCommand routingCommand) {
            this.routingCommand = routingCommand;
        }

        @Override
        public boolean hasHelp(DictionaryCommand command) {
            return this.routingCommand.equals(command);
        }

        @Override
        public String modifyHelpForCommand(DictionaryCommand command, String help, boolean compact) {
            help = "(t) " + help;
            if (!compact) {
                help = help + "Available commands: \n";
                help = help + DictionaryUtils.basicHelpForDictionary(((RoutingCommand)command).getDictionary(), "     ");
            }
            return help;
        }
    }

    private static class RoutingDictionaryCompleter
    implements DictionaryCompleter {
        private static final long serialVersionUID = 5979780403613106536L;
        private final DictionaryCompleter routingDictionaryCompleter;
        private final DictionaryCompleter innerDictionaryCompleter;
        private final String route;

        RoutingDictionaryCompleter(RoutingDictionary dict) {
            this.routingDictionaryCompleter = new DefaultDictionaryCompleter(dict);
            this.innerDictionaryCompleter = dict.getInnerDictionary().getDictionaryCompleter();
            this.route = dict.getRoute();
        }

        @Override
        public int complete(String buffer, int index, List<CharSequence> list) {
            boolean completingOption;
            TokenizedCommand tc = new TokenizedCommand(buffer.substring(0, index));
            int argCount = tc.getArgumentCount();
            boolean endsWithWhiteSpace = !tc.isEmpty() && Character.isWhitespace(buffer.charAt(index - 1));
            boolean bl = completingOption = tc.getLastToken() != null ? tc.getLastToken().isOption() : false;
            if (endsWithWhiteSpace || completingOption) {
                ++argCount;
            }
            if (argCount > 1 && buffer.startsWith(this.route)) {
                if (this.innerDictionaryCompleter != null) {
                    int newIndex;
                    int extraIndex = this.route.length() + 1;
                    String newBuffer = buffer.substring(extraIndex);
                    int completionValue = this.innerDictionaryCompleter.complete(newBuffer, newIndex = index - extraIndex, list);
                    return completionValue == -1 ? completionValue : completionValue + this.route.length() + 1;
                }
            } else {
                int ret = this.routingDictionaryCompleter.complete(buffer, index, list);
                return ret;
            }
            return index;
        }
    }

    static class RoutingDictionary
    implements Dictionary {
        private static final long serialVersionUID = 1001943350979114050L;
        private final RoutingDictionaryHelpGenerator helpGenerator;
        private final Dictionary innerDictionary;
        private final RoutingDictionaryCompleter completer;
        private final RoutingCommand routingCommand;
        private final RouteSelectionCommandSet routeSelection;
        private final String route;

        RoutingDictionary(RouteSelectionCommandSet routeSelection, String route, Dictionary dict) {
            this.routingCommand = new RoutingCommand(route, dict);
            this.innerDictionary = dict;
            this.completer = new RoutingDictionaryCompleter(this);
            this.helpGenerator = new RoutingDictionaryHelpGenerator(this.routingCommand);
            this.routeSelection = routeSelection;
            this.route = route;
        }

        DictionaryCommand getRouteCommand(String route) {
            return this.routingCommand;
        }

        Dictionary getInnerDictionary() {
            return this.innerDictionary;
        }

        String getRoute() {
            return this.routingCommand.route;
        }

        @Override
        public boolean containsCommand(BasicCommand tc) {
            return this.routingCommand.route.equals(tc.getCommand());
        }

        @Override
        public DictionaryCommand findCommand(BasicCommand tc) {
            return this.containsCommand(tc) ? this.routingCommand : null;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public Iterator<DictionaryCommand> iterator() {
            HashSet<RoutingCommand> set = new HashSet<RoutingCommand>();
            set.add(this.routingCommand);
            return set.iterator();
        }

        @Override
        public DictionaryHelpGenerator getHelpGenerator() {
            return this.helpGenerator;
        }

        @Override
        public DictionaryCompleter getDictionaryCompleter() {
            return this.completer;
        }

        @Override
        public void setLevelForTypes(int level, Command.CommandType ... types) {
            this.innerDictionary.setLevelForTypes(level, types);
        }

        @Override
        public int getLevelForType(Command.CommandType type) {
            return this.innerDictionary.getLevelForType(type);
        }

        @Override
        public void setCategoryVisible(Command.CommandCategory category, boolean isVisible) {
            this.innerDictionary.setCategoryVisible(category, isVisible);
        }

        @Override
        public boolean isCategoryVisible(Command.CommandCategory category) {
            return this.innerDictionary.isCategoryVisible(category);
        }

        @Override
        public boolean isDictionaryCommandVisible(DictionaryCommand dc) {
            if (dc instanceof RoutingCommand) {
                return ((RoutingCommand)dc).getArguments()[0].getAllowedValues().size() > 0;
            }
            return this.innerDictionary.isDictionaryCommandVisible(dc);
        }

        public boolean hasVisibleCommands() {
            Iterable<DictionaryCommand> iter = this.innerDictionary.filterByVisibilityIterator();
            return iter.iterator().hasNext();
        }

        public boolean isRouteAvailable() {
            String selectedRoute;
            String string = selectedRoute = this.routeSelection != null ? this.routeSelection.getActiveRoute() : "";
            if (selectedRoute.isEmpty()) {
                return !this.route.contains("/");
            }
            if (this.route.startsWith(selectedRoute)) {
                String partialRoute = this.route.replace(selectedRoute, "");
                if (partialRoute.startsWith("/")) {
                    partialRoute = partialRoute.substring(1);
                }
                return !partialRoute.contains("/");
            }
            return false;
        }
    }
}

