/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.motorplatform.ts8;

import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.subsystem.motorplatform.bus.AxisStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.ChangeAxisEnable;
import org.lsst.ccs.subsystem.motorplatform.bus.ChangeOutputLine;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearAllFaults;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearAxisFaults;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearCapture;
import org.lsst.ccs.subsystem.motorplatform.bus.ControllerStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.EnableAllAxes;
import org.lsst.ccs.subsystem.motorplatform.bus.HomeAxis;
import org.lsst.ccs.subsystem.motorplatform.bus.MotorCommandListener;
import org.lsst.ccs.subsystem.motorplatform.bus.MotorplatformType;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisAbsolute;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisRelative;
import org.lsst.ccs.subsystem.motorplatform.bus.SendAxisStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.SendConfiguration;
import org.lsst.ccs.subsystem.motorplatform.bus.SendControllerStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.SetupCapture;
import org.lsst.ccs.subsystem.motorplatform.bus.ShellCommandListener;
import org.lsst.ccs.subsystem.motorplatform.bus.StopAllMotion;
import org.lsst.ccs.subsystem.motorplatform.ts8.ACR9000;

public class TS8Main
extends Subsystem
implements MotorCommandListener,
ShellCommandListener,
HasLifecycle {
    private ExecutorService publisher;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private ACR9000 controller;
    private final Map<String, AxisStatus> lastAxisStatus = new ConcurrentHashMap<String, AxisStatus>(3);
    private final AtomicReference<ControllerStatus> lastControllerStatus = new AtomicReference();

    TS8Main() {
        super("ts8", AgentInfo.AgentType.WORKER);
    }

    private void publishOrPerish(ACR9000 ctrl, Subsystem subsys, ExecutorService exec) {
        try {
            KeyValueData result = ctrl.getNextResult();
            if (result.getValue().getClass() == AxisStatus.class) {
                AxisStatus status = (AxisStatus)result.getValue();
                this.lastAxisStatus.put(status.getAxisName().toUpperCase(), status);
            } else if (result.getValue().getClass() == ControllerStatus.class) {
                this.lastControllerStatus.set((ControllerStatus)result.getValue());
            }
            subsys.publishSubsystemDataOnStatusBus(result);
            exec.submit(() -> this.publishOrPerish(ctrl, subsys, exec));
        }
        catch (InterruptedException ex) {
            return;
        }
    }

    public void postInit() {
        ((AgentPropertiesService)this.getAgentService(AgentPropertiesService.class)).setAgentProperty("motorplatform.type", MotorplatformType.TS8.name());
    }

    public void postStart() {
        this.publisher = Executors.newSingleThreadExecutor();
        ACR9000 ctrl = this.controller;
        TS8Main subsys = this;
        ExecutorService exec = this.publisher;
        exec.submit(() -> this.publishOrPerish(ctrl, subsys, exec));
    }

    public void shutdown() {
        this.publisher.shutdownNow();
    }

    @Command(description="(GUI/Jython) Enables or disables an axis.")
    public void changeAxisEnable(@Argument(name="cmd", description="An instance of ChangeAxisEnable.") ChangeAxisEnable cmd) {
        this.controller.changeAxisEnable(cmd);
    }

    @Command(description="(GUI/Jython) Change a motor controller output line state.")
    public void changeOutputLine(@Argument(name="cmd", description=")An instance of ChangeOutputLine.") ChangeOutputLine cmd) {
        this.controller.changeOutputLine(cmd);
    }

    @Command(description="(GUI/Jython) Attempt to clear all extant faults, general and axis.")
    public void clearAllFaults(@Argument(name="cmd", description="An instance of ClearAllFaults.") ClearAllFaults cmd) {
        this.controller.clearAllFaults(cmd);
    }

    @Command(description="(GUI/Jython) Attempt to clear the faults on a specific axis.")
    public void clearAxisFaults(@Argument(name="cmd", description="An instance of ClearAxisFaults.") ClearAxisFaults cmd) {
        this.controller.clearAxisFaults(cmd);
    }

    @Command(description="(GUI/Jython) Turn off data capture for subsequent motions.")
    public void clearCapture(@Argument(name="cmd", description="An instance of ClearCapture.") ClearCapture cmd) {
        this.controller.clearCapture(cmd);
    }

    @Command(description="(GUI/Jython) Enable the X and Y axes.")
    public void enableAllAxes(@Argument(name="cmd", description="An instance of EnableAllExes.") EnableAllAxes cmd) {
        this.controller.enableAllAxes(cmd);
    }

    @Command(description="(GUI/Jython) Move the axis to its low-end limit switch and set the axis position to zero.")
    public void homeAxis(@Argument(name="cmd", description="An instance of HomeAxis.") HomeAxis cmd) {
        this.controller.homeAxis(cmd);
    }

    @Command(description="(GUI/Jython) Change the axis position by the given amount in the given time.")
    public void moveAxisRelative(@Argument(name="cmd", description="An instance of MoveAxisRelative.") MoveAxisRelative cmd) {
        this.controller.moveAxisRelative(cmd);
    }

    @Command(description="(GUI/Jython) Move the axis to an absolute position at a given speed.")
    public void moveAxisAbsolute(@Argument(name="cmd", description="An instance of MoveAxisAbsolute.") MoveAxisAbsolute cmd) {
        this.controller.moveAxisAbsolute(cmd);
    }

    @Command(description="(GUI/Jython) Send an axis report on the status bus.")
    public void sendAxisStatus(@Argument(name="cmd", description="An instance of SendAxisStatus.") SendAxisStatus cmd) {
        this.controller.sendAxisStatus(cmd);
    }

    @Command(description="(GUI/Jython) Send the platform configuration on the status bus.")
    public void sendConfiguration(@Argument(name="cmd", description="An instance of SendConfiguration.") SendConfiguration cmd) {
        this.controller.sendConfiguration(cmd);
    }

    @Command(description="(GUI/Jython) Send a controller report on the status bus.")
    public void sendControllerStatus(@Argument(name="cmd", description="An instance of SendControllerStatus.") SendControllerStatus cmd) {
        this.controller.sendControllerStatus(cmd);
    }

    @Command(description="(GUI/Jython) Set up data capture for subsequent moves.")
    public void setupCapture(@Argument(name="cmd", description="An instance of SetupCapture.") SetupCapture cmd) {
        this.controller.setupCapture(cmd);
    }

    @Command(description="(GUI/Jython) Kill all motion on the platform.")
    public void stopAllMotion(@Argument(name="cmd", description="An instance of StopAllMotion.") StopAllMotion cmd) {
        this.controller.stopAllMotion(cmd);
    }

    @Command(description="(Shell) Clear all axis and global controller faults.")
    public void clearFaults() {
        this.controller.clearAllFaults(new ClearAllFaults());
    }

    @Command(description="(Shell) Stop motion on all axes and discard queued commands.")
    public void stopAll() {
        this.controller.stopAllMotion(new StopAllMotion());
    }

    @Command(description="(Shell) Enable an axis.")
    public void enable(@Argument(name="axisName", description="The name of the axis.") String axisName) {
        this.controller.changeAxisEnable(new ChangeAxisEnable(this.checkAxis(axisName), true));
    }

    @Command(description="(Shell) Disable an axis.")
    public void disable(@Argument(name="axisName", description="The name of the axis.") String axisName) {
        this.controller.changeAxisEnable(new ChangeAxisEnable(this.checkAxis(axisName), false));
    }

    @Command(description="(Shell) Send an axis to its home position, set coordinate to zero.")
    public void home(@Argument(name="axisName", description="The name of the axis.") String axisName) {
        this.controller.homeAxis(new HomeAxis(this.checkAxis(axisName)));
    }

    @Command(description="(Shell) Move an axis to a new absolute position.")
    public void moveTo(@Argument(name="axisName", description="The name of the axis.") String axisName, @Argument(name="newPosition", description="The target position in mm.") double newPosition, @Argument(name="speed", description="The top speed of the move in mm/sec. Default is 20.", defaultValue="20.0") double speed) {
        this.controller.moveAxisAbsolute(new MoveAxisAbsolute(this.checkAxis(axisName), newPosition, speed));
    }

    @Command(description="(Shell) Move an axis by a given amount from the position at the start of command execution.")
    public void moveBy(@Argument(name="axisName", description="The name of the axis.") String axisName, @Argument(name="positionChange", description="The desired coordinate change in mm.") double positionChange, @Argument(name="speed", description="The top speed of the move in mm/sec. Default is 20.", defaultValue="20.0") double speed) {
        double time = Math.abs(positionChange) / speed;
        this.controller.moveAxisRelative(new MoveAxisRelative(this.checkAxis(axisName), positionChange, Duration.ofMillis((long)(1000.0 * time))));
    }

    @Command(description="(Shell) Get a short status report for an axis.")
    public String status(@Argument(name="axisName", description="The name of the axis.") String axisName) {
        StringBuilder buff = new StringBuilder(1024);
        buff.append("Controller motion enable: %s%n");
        buff.append("Controller comm link: %s%n");
        buff.append("Axis %s%n");
        buff.append("Enabled %s, Moving %s, At Home %s, At Low %s, At High %s%n");
        buff.append("Position %6.1f%n");
        ControllerStatus ctlstat = this.lastControllerStatus.get();
        AxisStatus axstat = this.lastAxisStatus.get(this.checkAxis(axisName));
        if (ctlstat == null || axstat == null) {
            return "Not available at present.";
        }
        for (String fault : axstat.getFaults()) {
            buff.append(fault);
            buff.append("%n");
        }
        return String.format(buff.toString(), ctlstat.isMotionEnabled(), ctlstat.getCommLinkStatus(), axstat.getAxisName(), axstat.isEnabled(), axstat.isMoving(), axstat.isAtHome(), axstat.isAtLowLimit(), axstat.isAtHighLimit(), axstat.getPosition());
    }

    private String checkAxis(String axisName) {
        String uname = axisName.toUpperCase();
        if (uname.equals("X") || uname.equals("Y") || uname.equals("Z")) {
            return uname;
        }
        throw new IllegalArgumentException(String.format("Illegal axis name '%s'. Use X, Y or Z. Lower case is OK.", axisName));
    }
}

