/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.messaging.StatusMessageListener;

public class ChillerSubsystem
extends Subsystem
implements HasLifecycle,
StatusMessageListener,
AgentPresenceListener {
    private static final Logger LOG = Logger.getLogger(ChillerSubsystem.class.getName());
    private volatile boolean isListeningToThermal = false;
    private volatile String thermalName = null;
    private final Object listeningLock = new Object();

    public ChillerSubsystem() {
        super("chiller", AgentInfo.AgentType.WORKER);
    }

    public void init() {
        this.getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)this);
    }

    public void shutdown() {
        this.getMessagingAccess().getAgentPresenceManager().removeAgentPresenceListener((AgentPresenceListener)this);
    }

    public void onStatusMessage(StatusMessage msg) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connected(AgentInfo ... agents) {
        for (AgentInfo agent : agents) {
            if (!agent.hasAgentProperty("thermalType")) continue;
            Object object = this.listeningLock;
            synchronized (object) {
                if (!this.isListeningToThermal) {
                    this.isListeningToThermal = true;
                    this.thermalName = agent.getName();
                    LOG.log(Level.INFO, "Starting to listen to messages from thermal subsystem {0}.", this.thermalName);
                    Predicate filter = BusMessageFilterFactory.messageOrigin((String)this.thermalName).and(BusMessageFilterFactory.messageClass(StatusSubsystemData.class));
                    this.getMessagingAccess().addStatusMessageListener((StatusMessageListener)this, filter);
                } else {
                    LOG.log(Level.SEVERE, "More than one thermal subsystem on the buses!!! Currently listening to {0} and just connected {1}!!", new Object[]{this.thermalName, agent.getName()});
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnected(AgentInfo ... agents) {
        for (AgentInfo agent : agents) {
            Object object = this.listeningLock;
            synchronized (object) {
                if (this.isListeningToThermal && agent.getName().equals(this.thermalName)) {
                    LOG.log(Level.INFO, "Thermal subsystem {0} disconnected. No longer listening to its messages.", this.thermalName);
                    this.getMessagingAccess().removeStatusMessageListener((StatusMessageListener)this);
                    this.isListeningToThermal = false;
                    this.thermalName = null;
                }
            }
        }
    }

    public String vetoTransitionToNormalMode() {
        return this.isListeningToThermal ? null : "Chiller is not listening to Thermal.";
    }
}

