/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.services.AgentLockService;
import org.lsst.ccs.services.UnauthorizedLevelException;
import org.lsst.ccs.services.UnauthorizedLockException;

public class MCMCommandSender {
    private static final Logger LOG = Logger.getLogger(MCMCommandSender.class.getName());
    private final ConcurrentMessagingUtils cmu;
    private final String target;
    private final AgentLockService lockService;
    private final AgentMessagingLayer agentMessagingLayer;

    MCMCommandSender(String target, AgentMessagingLayer agentMessagingLayer, AgentLockService lockService) {
        this.target = target;
        this.lockService = lockService;
        this.agentMessagingLayer = agentMessagingLayer;
        this.cmu = new ConcurrentMessagingUtils(agentMessagingLayer);
    }

    void sendCommand(String command, Object ... args) throws ExecutionException {
        this.sendCommand(Void.TYPE, null, command, args);
    }

    <T> T sendCommand(Class<T> returnType, String command, Object ... args) throws ExecutionException {
        return this.sendCommand(returnType, null, command, args);
    }

    <T> T sendCommand(Class<T> returnType, Duration timeout, String command, Object ... args) throws ExecutionException {
        CommandRequest request = new CommandRequest(this.target, command, args);
        try {
            LOG.log(Level.INFO, "Sending {0} to {1}", new Object[]{command, this.target});
            long start = System.nanoTime();
            Object result = timeout == null ? this.cmu.sendSynchronousCommand(request) : this.cmu.sendSynchronousCommand(request, timeout);
            long stop = System.nanoTime();
            LOG.log(Level.INFO, "Sent {0} to {1} took {2}ns", new Object[]{command, this.target, stop - start});
            return returnType.cast(result);
        }
        catch (Exception ex) {
            throw new ExecutionException(String.format("Error sending command %s to %s", command, this.target), ex);
        }
    }

    void lock(int level) throws UnauthorizedLevelException, UnauthorizedLockException, IOException {
        this.lockService.setLevelForAgent(this.target, level);
    }

    void unlock() {
    }
}

