/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.DataProviderDictionary;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.DataProviderDictionaryService;
import org.lsst.ccs.subsystem.ocsbridge.OCSBridgeConfig;
import org.lsst.ccs.subsystem.ocsbridge.xml.Mapping;
import org.lsst.ccs.subsystem.ocsbridge.xml.SALClassDescription;
import org.lsst.ccs.subsystem.ocsbridge.xml.SALClassDescriptionMaker;

public class DictionaryProvider
implements HasLifecycle {
    private static final Logger LOG = Logger.getLogger(DictionaryProvider.class.getName());
    @LookupField(strategy=LookupField.Strategy.TREE)
    private DataProviderDictionaryService dpdService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private OCSBridgeConfig config;
    private final Listener listener = new Listener();
    private final Map<String, SALClassDescription> salMonitoringClassDescriptions = new HashMap<String, SALClassDescription>();
    private final Map<String, SALClassDescription> salConfigurationClassDescriptions = new HashMap<String, SALClassDescription>();

    public void start() {
        this.dpdService.addDataProviderDictionaryListener((DataProviderDictionaryService.DataProviderDictionaryListener)this.listener);
    }

    Map<String, SALClassDescription> getStatusClassDescriptions() {
        return this.salMonitoringClassDescriptions;
    }

    Map<String, SALClassDescription> getConfigurationClassDescriptions() {
        return this.salConfigurationClassDescriptions;
    }

    private class Listener
    implements DataProviderDictionaryService.DataProviderDictionaryListener {
        Mapping mapping = Mapping.defaultMapping();

        private Listener() {
        }

        public void dataProviderDictionaryUpdate(DataProviderDictionaryService.DataProviderDictionaryEvent evt) {
            try {
                AgentInfo.AgentType type;
                if (evt.getEventType() == DataProviderDictionaryService.DataProviderDictionaryEvent.EventType.ADDED && ((type = evt.getAgentInfo().getType()) == AgentInfo.AgentType.WORKER || type == AgentInfo.AgentType.SERVICE)) {
                    String name = evt.getAgentInfo().getName();
                    DataProviderDictionary dictionary = evt.getDictionary();
                    int levelForAgent = this.getLevelForAgent(name);
                    SALClassDescriptionMaker maker = new SALClassDescriptionMaker(dictionary, DictionaryProvider.this.config.getCSCRoot(), name, levelForAgent, this.mapping, "MONITORING", "trending");
                    DictionaryProvider.this.salMonitoringClassDescriptions.putAll(maker.getSALClassDescriptions());
                    SALClassDescriptionMaker configMaker = new SALClassDescriptionMaker(dictionary, DictionaryProvider.this.config.getCSCRoot(), name, levelForAgent, this.mapping, DataProviderInfo.Type.CONFIGURATION.name(), "SettingsApplied");
                    DictionaryProvider.this.salConfigurationClassDescriptions.putAll(configMaker.getSALClassDescriptions());
                    LOG.log(Level.INFO, "Added dictionaries for {0} at level {1}", new Object[]{name, levelForAgent});
                }
            }
            catch (Throwable t) {
                LOG.log(Level.SEVERE, "Exception adding dictionary", t);
            }
        }

        private int getLevelForAgent(String name) {
            switch (name) {
                case "ats": {
                    return 0;
                }
                case "ats-power": {
                    return 0;
                }
                case "comcam-fcs": {
                    return 0;
                }
            }
            return 1;
        }
    }
}

