/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.plotter.style.editor;

import hep.aida.IPlotterStyle;
import hep.aida.ref.xml.AidaStyleXMLWriter;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.freehep.application.RecentItemTextField;

public class SaveAidaStylePanel
extends JPanel {
    private Component parent;
    private RecentItemTextField outputFile = new RecentItemTextField("hep.aida.ref.plotter.style.editor.SaveAidaStylePanel.OutputFile", 15, false);
    private JCheckBox writeSetParameters = new JCheckBox("Write Only Set Parameters");
    private JFileChooser outputChooser = new JFileChooser();
    private JButton outputBrowse = new JButton("Browse...");
    private JPanel thisPanel;
    private IPlotterStyle style;

    public SaveAidaStylePanel() {
        this(null, null);
    }

    public SaveAidaStylePanel(Component parent) {
        this(parent, null);
    }

    public SaveAidaStylePanel(IPlotterStyle style) {
        this(null, style);
    }

    public SaveAidaStylePanel(Component parent, IPlotterStyle style) {
        this.parent = parent;
        this.style = style;
        this.thisPanel = this;
        this.initComponents();
    }

    private void initComponents() {
        this.outputFile.setMinWidth(20);
        this.outputBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int returnVal = SaveAidaStylePanel.this.outputChooser.showOpenDialog(SaveAidaStylePanel.this.thisPanel);
                if (returnVal == 0) {
                    File file = SaveAidaStylePanel.this.outputChooser.getSelectedFile();
                    String fileName = file.getAbsolutePath();
                    SaveAidaStylePanel.this.outputFile.setText(fileName);
                }
            }
        });
        this.writeSetParameters.setSelected(true);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.gridy = 0;
        gbc.gridx = 0;
        this.add((Component)new JLabel("Output File: "), gbc);
        gbc.gridx = 1;
        this.add((Component)this.outputFile, gbc);
        gbc.gridx = 2;
        this.add((Component)this.outputBrowse, gbc);
        gbc.gridy = 1;
        gbc.gridx = 1;
        this.add((Component)this.writeSetParameters, gbc);
    }

    public void setStyle(IPlotterStyle style) {
        this.style = style;
    }

    public IPlotterStyle getStyle() {
        return this.style;
    }

    public void saveStyle() throws IOException {
        int reply;
        String title = "Select Output File if You Want to Save Style";
        Component comp = this.parent;
        if (comp == null) {
            comp = SwingUtilities.getAncestorOfClass(Frame.class, this);
        }
        if ((reply = JOptionPane.showOptionDialog(comp, this, title, 0, -1, null, new String[]{"Ok", "Cancel"}, "Cancel")) != 0) {
            return;
        }
        String fileName = this.outputFile.getText();
        boolean writeAll = !this.writeSetParameters.isSelected();
        AidaStyleXMLWriter.writeToFile(fileName, this.style, writeAll);
        this.outputFile.saveState();
    }
}

