/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.rotator;

import java.util.Date;
import java.util.concurrent.TimeoutException;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.rotator.Position;
import org.lsst.ccs.drivers.rotator.RotatorDriver;
import org.lsst.ccs.drivers.rotator.RotatorState;
import org.lsst.sal.rotator.event.SummaryStateEvent;

public class RotatorDriverTest {
    private final RotatorDriver driver = new RotatorDriver();

    public RotatorDriverTest() {
        this.driver.addStateChangeListener(event -> System.out.println("StateChange: " + event.getRotatorState()));
        this.driver.addPositionListener(event -> System.out.println("Position: " + event.getPosition()));
    }

    @Command(name="move", alias="mv", description="Move to position")
    public void move(double position) throws DriverException, TimeoutException {
        this.driver.move(position);
    }

    @Command(name="enable", description="Enable")
    public void enable() throws DriverException, TimeoutException {
        this.driver.enable();
    }

    @Command(name="disable", description="Enable")
    public void disable() throws DriverException, TimeoutException {
        this.driver.disable();
    }

    @Command(name="standby", description="Standby")
    public void standby() throws DriverException, TimeoutException {
        this.driver.standby();
    }

    @Command(name="start", description="Start")
    public void start(String config) throws DriverException, TimeoutException {
        this.driver.start(config);
    }

    @Command(name="enterControl", description="EnterControl")
    public void enterControl() throws DriverException, TimeoutException {
        this.driver.enterControl();
    }

    @Command(name="exitControl", description="ExitControl")
    public void exitControl() throws DriverException, TimeoutException {
        this.driver.exitControl();
    }

    @Command(name="clearError", description="ClearError")
    public void clearError() throws DriverException, TimeoutException {
        this.driver.clearError();
    }

    @Command(name="lastHeartbeat", alias="hb", description="Get the last heartbeat time")
    public Date lastHeartbeat() {
        return this.driver.getLastHeartbeat();
    }

    @Command(name="summaryState", alias="ss", description="Get the current summary state")
    public SummaryStateEvent.SummaryState summaryState() {
        return this.driver.getSummaryState();
    }

    @Command(name="rotatorState", alias="rs", description="Get the current rotator state")
    public RotatorState controllerState() {
        return this.driver.getRotatorState();
    }

    @Command(name="position", alias="p", description="Get the current position")
    public Position position() {
        return this.driver.getPosition();
    }
}

