/*
 * Decompiled with CFR 0.152.
 */
package org.indilib.i4j.protocol.io;

import java.io.IOException;
import java.io.InputStream;

public class MinimalBlockinInputStream
extends InputStream {
    private final InputStream in;

    public MinimalBlockinInputStream(InputStream in) {
        this.in = in;
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (len > 0) {
            if (this.in.available() > 0) {
                return this.in.read(b, off, Math.min(this.in.available(), len));
            }
            int count = this.in.read(b, off, 1);
            if (this.in.available() > 0) {
                return this.in.read(b, off + count, Math.min(this.in.available(), len - count)) + count;
            }
            return count;
        }
        return 0;
    }

    @Override
    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.in.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.in.reset();
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }
}

