/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.io.Serializable;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.services.alert.AlertEvent;
import org.lsst.ccs.services.alert.AlertListener;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.common.MonitorTaskControl;
import org.lsst.ccs.subsystem.refrig.PcpPlutoDevice;
import org.lsst.ccs.subsystem.refrig.PowerDevice;
import org.lsst.ccs.subsystem.refrig.constants.ConditionState;
import org.lsst.ccs.subsystem.refrig.constants.LatchState;
import org.lsst.ccs.subsystem.refrig.constants.PLCState;
import org.lsst.ccs.subsystem.refrig.constants.PcpAlert;
import org.lsst.ccs.subsystem.refrig.constants.PcpHeaterState;
import org.lsst.ccs.subsystem.refrig.constants.PcpLatches;
import org.lsst.ccs.subsystem.refrig.constants.PcpSwitchState;
import org.lsst.ccs.subsystem.refrig.constants.PcpSwitches;
import org.lsst.ccs.subsystem.refrig.data.PcpSysState;
import org.lsst.ccs.subsystem.refrig.data.RefrigException;

public class PrototypeColdPlateSubsystem
extends Subsystem
implements HasLifecycle,
AlertListener {
    private static final Map<Integer, PcpAlert> alertMap = new HashMap<Integer, PcpAlert>();
    private static final Map<String, String> revAlertMap;
    @LookupName
    private String name;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPropertiesService propertiesService;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private PcpPlutoDevice plutoDevc;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private PowerDevice powerDevice;
    private int[] powerChans;
    private static final Logger LOG;
    private final PcpSysState pcpState = new PcpSysState();
    private MonitorTaskControl monitorControl;
    private boolean running = false;
    private boolean gotCommand = false;
    private boolean[] powerInited;

    public PrototypeColdPlateSubsystem() {
        super("prototype-cold-plate", AgentInfo.AgentType.WORKER);
    }

    public void build() {
        this.monitorControl = MonitorTaskControl.createNode((Subsystem)this, (String)"MonitorControl");
        AgentPeriodicTask pt = new AgentPeriodicTask("pcp-state", () -> this.updatePcpState()).withPeriod(Duration.ofMillis(1000L));
        this.periodicTaskService.scheduleAgentPeriodicTask(pt);
    }

    public void init() {
        for (PcpAlert alert : PcpAlert.values()) {
            this.alertService.registerAlert(alert.getAlert());
        }
    }

    public void postInit() {
        this.propertiesService.setAgentProperty("pcpType", PrototypeColdPlateSubsystem.class.getCanonicalName());
        this.alertService.addListener((AlertListener)this);
        if (this.powerChans == null) {
            LOG.info("No heater channels specified");
        } else if (this.powerChans.length != 3) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"powerChans", (String)"does not contain exactly 3 items");
        }
        this.powerInited = new boolean[this.powerChans.length];
        if (this.plutoDevc != null) {
            int cond;
            for (cond = 0; cond < 3; ++cond) {
                this.pcpState.setLatch(cond, LatchState.CLEAR);
            }
            for (cond = 0; cond < 2; ++cond) {
                this.pcpState.setCondition(cond, ConditionState.NO);
            }
        } else {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"Pluto device", (String)"not specified");
        }
    }

    public void postStart() {
        LOG.info("Prototype cold plate subsystem started");
        this.running = true;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the PCP system state")
    public PcpSysState getSystemState() {
        this.pcpState.setTickMillis(this.monitorControl.getFastPeriod());
        return this.pcpState;
    }

    @Command(type=Command.CommandType.QUERY, description="Get switch names")
    public List<String> getSwitchNames() throws RefrigException {
        return PcpSwitches.getNames();
    }

    @Command(type=Command.CommandType.ACTION, description="Turn on/off a named switch")
    public void setNamedSwitchOn(@Argument(description="The switch name") String swch, @Argument(description="Whether to turn on") boolean on) throws RefrigException {
        this.gotCommand = true;
        int sw = PcpSwitches.getId(swch);
        PcpSwitchState state = this.pcpState.getSwitchState(sw);
        if (state == PcpSwitchState.OFFLINE) {
            return;
        }
        this.plutoDevc.setSwitchOn(sw, on);
    }

    @Command(type=Command.CommandType.QUERY, description="Get latched condition names")
    public List<String> getLatchNames() throws RefrigException {
        return PcpLatches.getNames();
    }

    @Command(type=Command.CommandType.ACTION, description="Clear a latched condition")
    public void clearLatch(@Argument(description="The condition name") String cond) throws RefrigException {
        this.gotCommand = true;
        this.plutoDevc.clearLatch(PcpLatches.getId(cond));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, description="Set an aux heater power enabled state")
    public void setAuxHeaterState(int htr, boolean on) throws DriverException {
        this.gotCommand = true;
        PcpSysState pcpSysState = this.pcpState;
        synchronized (pcpSysState) {
            PcpHeaterState oldState = this.pcpState.getHeaterState(htr);
            if (oldState != PcpHeaterState.OFFLINE && oldState != PcpHeaterState.DISABLD) {
                PcpHeaterState newState;
                PcpHeaterState pcpHeaterState = newState = on ? PcpHeaterState.ON : PcpHeaterState.OFF;
                if (newState != oldState) {
                    this.pcpState.setHeaterState(htr, newState);
                    this.setAuxHeaterPower(htr);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, description="Set an aux heater power set point")
    public void setAuxHeaterPower(int htr, double value) {
        this.gotCommand = true;
        PcpSysState pcpSysState = this.pcpState;
        synchronized (pcpSysState) {
            this.pcpState.setHeaterPower(htr, value);
            this.setAuxHeaterPower(htr);
        }
    }

    private void setAuxHeaterPower(int htr) {
        int chan = this.powerChans[htr];
        if (PcpHeaterState.isOnState(this.pcpState.getHeaterState(htr))) {
            this.powerDevice.enableOutput(chan, true);
            this.powerDevice.setPower(chan, this.pcpState.getHeaterPower(htr));
        } else {
            this.powerDevice.enableOutput(chan, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePcpState() {
        if (!this.running) {
            return;
        }
        boolean changed = this.monitorControl.hasPeriodChanged();
        PcpSysState pcpSysState = this.pcpState;
        synchronized (pcpSysState) {
            Enum state;
            Boolean active;
            int cond;
            PLCState newState;
            Boolean plcActive = this.plutoDevc.isPlcActive();
            PLCState pLCState = plcActive == null ? PLCState.OFFLINE : (newState = plcActive != false ? PLCState.ALIVE : PLCState.DEAD);
            if (newState != this.pcpState.getPlcState()) {
                changed = true;
                this.pcpState.setPlcState(newState);
                PcpAlert alert = PcpAlert.CHILLER_PLC_NOT_ALIVE;
                String plcDesc = "PCP protection PLC ";
                if (newState == PLCState.ALIVE) {
                    this.lowerAlert(alert, plcDesc + "is alive");
                } else {
                    String errDesc = newState == PLCState.DEAD ? "has died: error = " + this.plutoDevc.getErrorCode() : "is offline";
                    this.raiseAlert(alert, plcDesc + errDesc);
                }
            }
            for (int sw = 0; sw < 2; ++sw) {
                PcpSwitchState state2 = this.plutoDevc.getSwitchState(sw);
                if (state2 == this.pcpState.getSwitchState(sw)) continue;
                this.pcpState.setSwitchState(sw, state2);
                changed = true;
            }
            for (cond = 0; cond < 3; ++cond) {
                active = this.plutoDevc.isLatchActive(cond);
                Boolean latched = this.plutoDevc.isLatchLatched(cond);
                state = active == null || latched == null ? LatchState.OFFLINE : (latched != false ? LatchState.LATCHED : (active != false ? LatchState.ACTIVE : LatchState.CLEAR));
                PcpAlert alert = alertMap.get(cond);
                LatchState oldState = this.pcpState.getLatch(cond);
                if (state == oldState) continue;
                this.pcpState.setLatch(cond, (LatchState)state);
                if (state == LatchState.ACTIVE) {
                    this.raiseAlert(alert, "Protection PLC error condition set");
                } else if (state != LatchState.OFFLINE) {
                    if (oldState != LatchState.ACTIVE && state == LatchState.LATCHED) {
                        this.raiseAlert(alert, "Protection PLC error condition set");
                    }
                    if (oldState == LatchState.ACTIVE || state == LatchState.LATCHED) {
                        this.lowerAlert(alert, "Protection PLC error condition cleared");
                    }
                }
                changed = true;
            }
            for (cond = 0; cond < 2; ++cond) {
                ConditionState state3;
                active = this.plutoDevc.isConditionActive(cond);
                ConditionState conditionState = active == null ? ConditionState.OFF : (state3 = active != false ? ConditionState.YES : ConditionState.NO);
                if (state3 == this.pcpState.getCondition(cond)) continue;
                this.pcpState.setCondition(cond, state3);
                changed = true;
            }
            if (this.pcpState.getLimit(0) == Integer.MAX_VALUE) {
                int[] limits = this.plutoDevc.getTempLimits();
                for (int j = 0; j < 2; ++j) {
                    this.pcpState.setLimit(j, limits[j]);
                }
                changed |= this.pcpState.getLimit(0) != Integer.MAX_VALUE;
            }
            for (int htr = 0; htr < 3; ++htr) {
                PcpHeaterState oldState = this.pcpState.getHeaterState(htr);
                int chan = this.powerChans[htr];
                Enum enum_ = !this.powerDevice.isOnline() ? PcpHeaterState.OFFLINE : (!this.powerDevice.isEnabled(chan) ? PcpHeaterState.OFF : (this.powerDevice.hasVoltError(chan) ? PcpHeaterState.VOLTERR : (state = this.powerDevice.hasNoLoad(chan) ? PcpHeaterState.NOLOAD : PcpHeaterState.ON)));
                if (state == oldState) continue;
                this.pcpState.setHeaterState(htr, (PcpHeaterState)state);
                if (oldState == PcpHeaterState.OFFLINE && !this.powerInited[htr]) {
                    if (this.powerDevice.isEnabled(chan)) {
                        double power = this.powerDevice.getPower(chan);
                        this.pcpState.setHeaterPower(htr, power);
                    }
                    this.powerInited[htr] = true;
                }
                this.setAuxHeaterPower(htr);
                changed = true;
            }
        }
        if (this.gotCommand) {
            changed = true;
            this.gotCommand = false;
        }
        if (changed) {
            this.publishState();
        }
    }

    private void raiseAlert(PcpAlert alert, String cond) {
        this.alertService.raiseAlert(alert.getAlert(), AlertState.ALARM, cond);
    }

    private void lowerAlert(PcpAlert alert, String cond) {
        this.alertService.raiseAlert(alert.getAlert(), AlertState.NOMINAL, cond);
    }

    public void onAlert(AlertEvent event) {
        if (event.getType() != AlertEvent.AlertEventType.ALERT_CLEARED) {
            return;
        }
        for (String id : event.getClearedIds()) {
            String cond = revAlertMap.get(id);
            if (cond == null) continue;
            try {
                this.clearLatch(cond);
            }
            catch (RefrigException e) {
                LOG.log(Level.SEVERE, "Error clearing latched PLC condition ({0}): {1}", new Object[]{cond, e});
            }
        }
    }

    private void publishState() {
        this.pcpState.setTickMillis(this.monitorControl.getFastPeriod());
        this.publishSubsystemDataOnStatusBus(new KeyValueData("PcpState", (Serializable)this.pcpState));
    }

    static {
        alertMap.put(1, PcpAlert.COLD_TEMP_HIGH);
        alertMap.put(2, PcpAlert.COLD_TEMP_LOW);
        alertMap.put(0, PcpAlert.SMOKE_DETC);
        revAlertMap = new HashMap<String, String>();
        for (Map.Entry<Integer, PcpAlert> e : alertMap.entrySet()) {
            revAlertMap.put(e.getValue().getId(), PcpLatches.getName(e.getKey()));
        }
        LOG = Logger.getLogger(PrototypeColdPlateSubsystem.class.getName());
    }
}

