/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20Device;
import org.lsst.ccs.subsystem.refrig.PcpPlutoDevice;
import org.lsst.ccs.subsystem.refrig.PcpPowerControl;
import org.lsst.ccs.subsystem.refrig.PowerDevice;

public class PcpPowerDevice
extends PowerDevice {
    public static final int N_HW_CHANS = 3;
    private static final int TYPE_VOLTAGE = 0;
    private static final int TYPE_CURRENT = 1;
    private static final int TYPE_POWER = 2;
    private static final Map<String, Integer> typeMap = new HashMap<String, Integer>();
    private static final Map<Integer, Integer> plutoSwitches;
    @LookupField(strategy=LookupField.Strategy.ANCESTORS)
    protected Maq20Device maqDevc;
    @LookupField(strategy=LookupField.Strategy.SIBLINGS)
    private final List<PcpPowerControl> controlList = new ArrayList<PcpPowerControl>();
    @LookupField(strategy=LookupField.Strategy.TREE)
    private PcpPlutoDevice plutoDevc;
    private static final Logger LOG;
    private final PcpPowerControl[] controls = new PcpPowerControl[3];
    private final double[] voltages = new double[3];
    private final double[] currents = new double[3];

    public PcpPowerDevice() {
        super("PcpPower", null, 0, 0, 2);
        this.connType = DriverConstants.ConnType.NET;
        this.devcId = "";
    }

    @Override
    protected void initDevice() {
        Iterator<PcpPowerControl> iterator = this.controlList.iterator();
        while (iterator.hasNext()) {
            PcpPowerControl ctrl;
            this.controls[ctrl.getIdent()] = ctrl = iterator.next();
        }
        for (int j = 0; j < this.controls.length; ++j) {
            if (this.controls[j] != null) continue;
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.path, (String)("PcpPowerControl object with ident " + j), (String)"has not been defined");
        }
        if (this.plutoDevc == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.path, (String)"PcpPlutoDevice object", (String)"has not been defined");
        }
        this.fullName = this.getPath() + " (Pcp load power supply)";
    }

    @Override
    protected void initialize() {
        this.setOnline(this.maqDevc.isOnline());
    }

    @Override
    protected void close() {
    }

    @Override
    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        Integer iType = typeMap.get(type.toUpperCase());
        if (iType == null) {
            ErrorUtils.reportChannelError((Logger)LOG, (String)name, (String)"type", (Object)type);
        }
        if (hwChan < 0 || hwChan >= 3) {
            ErrorUtils.reportChannelError((Logger)LOG, (String)name, (String)"HW channel", (Object)hwChan);
        }
        return new int[]{iType, 0};
    }

    @Override
    protected void readChannelGroup() {
        if (!this.isOnline()) {
            return;
        }
        try {
            for (int chan = 0; chan < 3; ++chan) {
                PcpPowerControl ctrl = this.controls[chan];
                this.currents[chan] = ctrl.readCurrent();
                this.voltages[chan] = ctrl.readVoltage();
            }
        }
        catch (DriverException e) {
            LOG.log(Level.SEVERE, "Error reading currents & voltages from {0}: {1}", new Object[]{this.fullName, e});
            this.setOnline(false);
        }
    }

    @Override
    protected double readChannel(int hwChan, int type) {
        double value = Double.NaN;
        if (this.isOnline()) {
            switch (type) {
                case 0: {
                    value = this.voltages[hwChan];
                    break;
                }
                case 1: {
                    value = this.currents[hwChan];
                    break;
                }
                case 2: {
                    value = this.voltages[hwChan] * this.currents[hwChan];
                }
            }
        }
        return value;
    }

    @Override
    @Command(type=Command.CommandType.ACTION)
    public void setOutput(int chan, boolean value) throws DriverException {
        this.plutoDevc.setSwitchOn(plutoSwitches.get(chan), value);
    }

    @Override
    @Command(type=Command.CommandType.ACTION)
    public boolean getOutput(int chan) throws DriverException {
        return this.controls[chan].isOutputOn();
    }

    @Override
    @Command(type=Command.CommandType.ACTION)
    public void setVoltage(int chan, double value) throws DriverException {
        this.controls[chan].setVoltage(value);
    }

    @Override
    @Command(type=Command.CommandType.ACTION)
    public double readVoltage(int chan) throws DriverException {
        return this.controls[chan].readVoltage();
    }

    @Override
    @Command(type=Command.CommandType.ACTION)
    public void setCurrent(int chan, double value) throws DriverException {
        this.controls[chan].setCurrent(value);
    }

    @Override
    @Command(type=Command.CommandType.ACTION)
    public double readCurrent(int chan) throws DriverException {
        return this.controls[chan].readCurrent();
    }

    static {
        typeMap.put("VOLTAGE", 0);
        typeMap.put("CURRENT", 1);
        typeMap.put("POWER", 2);
        plutoSwitches = new HashMap<Integer, Integer>();
        plutoSwitches.put(0, 2);
        plutoSwitches.put(1, 3);
        plutoSwitches.put(2, 4);
        LOG = Logger.getLogger(PcpPowerDevice.class.getName());
    }
}

