/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.util.Arrays;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.subsystem.common.devices.pluto.PlutoDevice;
import org.lsst.ccs.subsystem.refrig.constants.PcpSwitchState;

public class PcpPlutoDevice
extends PlutoDevice {
    private static final int NUM_AREAS = 30;
    private static final int SWDI_ON_BIT = 0;
    private static final int SWDI_OFF_BIT = 1;
    private static final int SWDI_READ_AREA = 2;
    private static final int SWDI_READ_BIT = 3;
    private static final int LTDI_RESET_BIT = 0;
    private static final int LTDI_READ_AREA = 1;
    private static final int LTDI_READ_BIT = 2;
    private static final int LTDI_PEND_AREA = 3;
    private static final int LTDI_PEND_BIT = 4;
    private static final int CNDI_READ_AREA = 0;
    private static final int CNDI_READ_BIT = 1;
    private static final int PLC_STATUS_MASK = 1;
    private static final int ERROR_AREA = 6;
    private static final int OFFSET_CELSIUS = -273;
    private static final int[][] switches = new int[5][];
    private static final int[][] latches;
    private static final int[][] conditions;
    private final int[] tempLimits = new int[2];
    private boolean limitsRead = false;
    private final boolean[] swIsAlarm = new boolean[5];

    public PcpPlutoDevice() {
        super(30);
        Arrays.fill(this.tempLimits, Integer.MAX_VALUE);
    }

    public Boolean isPlcActive() {
        try {
            int status = this.plu.readModuleStatus();
            return (status & 1) != 0;
        }
        catch (DriverException e) {
            return null;
        }
    }

    protected void setSwitchOn(int sw, boolean on) {
        int bitNum = switches[sw][on ? 0 : 1];
        this.toggleBit(bitNum / 16, bitNum & 0xF);
    }

    public void setSwitchOn(int sw, boolean on, boolean alarm) {
        if (alarm) {
            this.swIsAlarm[sw] = on;
            if (!on) {
                return;
            }
        } else if (!on && this.swIsAlarm[sw]) {
            return;
        }
        this.setSwitchOn(sw, on);
    }

    public PcpSwitchState getSwitchState(int sw) {
        Boolean isOn = this.isSwitchOn(sw);
        return isOn != null ? (isOn.booleanValue() ? (this.swIsAlarm[sw] ? PcpSwitchState.ALARM : PcpSwitchState.ON) : PcpSwitchState.OFF) : PcpSwitchState.OFFLINE;
    }

    protected Boolean isSwitchOn(int sw) {
        int[] swData = switches[sw];
        Integer value = this.readAddBit(swData[2], swData[3] + 16);
        return value != null ? Boolean.valueOf(value != 0) : null;
    }

    public Boolean isLatchActive(int cond) {
        int[] condData = latches[cond];
        Integer value = this.readAddBit(condData[1], condData[2] + 16);
        return value != null ? Boolean.valueOf(value == 0) : null;
    }

    public Boolean isLatchLatched(int cond) {
        int[] condData = latches[cond];
        Integer value = this.readAddBit(condData[3], condData[4] + 16);
        return value != null ? Boolean.valueOf(value != 0) : null;
    }

    public void clearLatch(int cond) {
        int bitNum = latches[cond][0];
        this.toggleBit(bitNum / 16, bitNum & 0xF);
    }

    public Boolean isConditionActive(int cond) {
        int[] condData = conditions[cond];
        Integer value = this.readAddBit(condData[0], condData[1] + 16);
        return value != null ? Boolean.valueOf(value != 0) : null;
    }

    public int[] getTempLimits() {
        if (!this.limitsRead && this.isOnline()) {
            this.tempLimits[1] = this.readAddWord(4, 0) + -273;
            this.tempLimits[0] = this.readAddWord(4, 1) + -273;
            this.limitsRead = true;
        }
        return this.tempLimits;
    }

    public int getErrorCode() {
        return this.readAddWord(6, 0);
    }

    static {
        PcpPlutoDevice.switches[1] = new int[]{2, 3, 6, 6};
        PcpPlutoDevice.switches[0] = new int[]{4, 5, 7, 6};
        PcpPlutoDevice.switches[2] = new int[]{7, 8, 0, 0};
        PcpPlutoDevice.switches[3] = new int[]{9, 10, 0, 0};
        PcpPlutoDevice.switches[4] = new int[]{11, 12, 0, 0};
        latches = new int[3][];
        PcpPlutoDevice.latches[0] = new int[]{6, 7, 8, 7, 8};
        PcpPlutoDevice.latches[1] = new int[]{0, 6, 2, 6, 4};
        PcpPlutoDevice.latches[2] = new int[]{1, 7, 2, 7, 4};
        conditions = new int[2][];
        PcpPlutoDevice.conditions[0] = new int[]{7, 9};
        PcpPlutoDevice.conditions[1] = new int[]{6, 9};
    }
}

