/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.airwatch.main;

import java.io.Serializable;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public abstract class DataPoint {
    private final boolean limitViolation;
    private final boolean malfunction;
    private final String quality;
    private final Instant time;

    public DataPoint(boolean limitViolation, boolean malfunction, String quality, String isoTime) {
        this.limitViolation = limitViolation;
        this.malfunction = malfunction;
        this.quality = quality;
        this.time = Instant.from(DateTimeFormatter.ISO_DATE_TIME.parse(isoTime));
    }

    public final boolean hasLimitViolation() {
        return this.limitViolation;
    }

    public final boolean hasMalfunction() {
        return this.malfunction;
    }

    public final String getQuality() {
        return this.quality;
    }

    public final Instant getTime() {
        return this.time;
    }

    public abstract void checkData(AlertService var1, String var2, String var3);

    public KeyValueDataList makeKvdList(String locName, String chanName) {
        KeyValueDataList kvdl = new KeyValueDataList(String.format("%s/%s", locName, chanName), CCSTimeStamp.currentTimeFromMillis((long)this.time.toEpochMilli()));
        kvdl.addData(kvdl.getKey() + "/limitViolation", (Serializable)Integer.valueOf(this.hasLimitViolation() ? 1 : 0));
        kvdl.addData(kvdl.getKey() + "/malfunction", (Serializable)Integer.valueOf(this.hasMalfunction() ? 1 : 0));
        return kvdl;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("limitViolation=").append(this.limitViolation);
        sb.append(", malfunction=").append(this.malfunction);
        sb.append(", quality=").append(this.quality);
        sb.append(", time=").append(this.time);
        return sb.toString();
    }
}

