/*
 * Decompiled with CFR 0.152.
 */
package com.ifountain.opsgenie.client;

import com.ifountain.opsgenie.client.OpsGenieClientException;
import com.ifountain.opsgenie.client.http.OpsGenieHttpClient;
import com.ifountain.opsgenie.client.http.OpsGenieHttpResponse;
import com.ifountain.opsgenie.client.model.BaseRequest;
import com.ifountain.opsgenie.client.model.BaseRequestWithHttpParameters;
import com.ifountain.opsgenie.client.model.BaseResponse;
import com.ifountain.opsgenie.client.util.JsonUtils;
import com.ifountain.opsgenie.client.util.LogUtils;
import java.io.IOException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.http.HttpEntity;
import org.apache.http.entity.mime.MultipartEntity;

public abstract class AbstractOpsGenieHttpClient {
    protected Log log;
    protected OpsGenieHttpClient httpClient;
    private String apiKey;
    private String rootUri = "https://api.opsgenie.com";

    public AbstractOpsGenieHttpClient(OpsGenieHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    protected String getRootUri() {
        return this.rootUri;
    }

    protected void setRootUri(String rootUri) {
        this.rootUri = rootUri;
    }

    public void close() {
        this.httpClient.close();
    }

    protected BaseResponse doPostRequest(BaseRequest request) throws IOException, OpsGenieClientException, ParseException {
        if (request.getApiKey() == null) {
            request.setApiKey(this.getApiKey());
        }
        request.validate();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json; charset=utf-8");
        String uri = this.rootUri + request.getEndPoint();
        String json = JsonUtils.toJson(request);
        this.log.info((Object)("Executing OpsGenie request to [" + uri + "] with content Parameters:" + LogUtils.getInsensitiveLogMessage(JsonUtils.toMap(request))));
        OpsGenieHttpResponse httpResponse = this.httpClient.post(uri, json, headers);
        this.handleResponse(httpResponse);
        return this.populateResponse(request, httpResponse);
    }

    protected BaseResponse doPostRequest(BaseRequestWithHttpParameters request) throws OpsGenieClientException, IOException, ParseException {
        if (request.getApiKey() == null) {
            request.setApiKey(this.getApiKey());
        }
        request.validate();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json; charset=utf-8");
        String uri = this.rootUri + request.getEndPoint();
        String json = JsonUtils.toJson(request);
        this.log.info((Object)("Executing OpsGenie request to [" + uri + "] with content Parameters:" + LogUtils.getInsensitiveLogMessage(JsonUtils.toMap(request))));
        OpsGenieHttpResponse httpResponse = this.httpClient.post(uri, json, headers, request.getHttpParameters());
        this.handleResponse(httpResponse);
        return this.populateResponse(request, httpResponse);
    }

    protected BaseResponse doPostRequest(BaseRequest request, MultipartEntity entity) throws IOException, OpsGenieClientException, ParseException {
        if (request.getApiKey() == null) {
            request.setApiKey(this.getApiKey());
        }
        request.validate();
        String uri = this.rootUri + request.getEndPoint();
        this.log.info((Object)("Executing OpsGenie request to [" + uri + "] with multipart data"));
        OpsGenieHttpResponse httpResponse = this.httpClient.post(uri, (HttpEntity)entity);
        this.handleResponse(httpResponse);
        return this.populateResponse(request, httpResponse);
    }

    protected BaseResponse doDeleteRequest(BaseRequest request) throws OpsGenieClientException, IOException, ParseException {
        if (request.getApiKey() == null) {
            request.setApiKey(this.getApiKey());
        }
        request.validate();
        String uri = this.rootUri + request.getEndPoint();
        Map parameters = JsonUtils.toMap(request);
        this.log.info((Object)("Executing OpsGenie request to [" + uri + "] with Parameters:" + LogUtils.getInsensitiveLogMessage(parameters)));
        OpsGenieHttpResponse httpResponse = this.httpClient.delete(uri, parameters);
        this.handleResponse(httpResponse);
        return this.populateResponse(request, httpResponse);
    }

    protected BaseResponse doGetRequest(BaseRequest request) throws OpsGenieClientException, IOException, ParseException {
        if (request.getApiKey() == null) {
            request.setApiKey(this.getApiKey());
        }
        request.validate();
        String uri = this.rootUri + request.getEndPoint();
        Map parameters = JsonUtils.toMap(request);
        this.log.info((Object)("Executing OpsGenie request to [" + uri + "] with Parameters:" + LogUtils.getInsensitiveLogMessage(parameters)));
        OpsGenieHttpResponse httpResponse = this.httpClient.get(uri, parameters);
        this.handleResponse(httpResponse);
        return this.populateResponse(request, httpResponse);
    }

    protected void handleResponse(OpsGenieHttpResponse response) throws IOException, OpsGenieClientException {
        if (response.getStatusCode() != 200) {
            String contentType = response.getHeaders().get("Content-Type");
            if (contentType != null && contentType.toLowerCase().startsWith("application/json")) {
                Map error = JsonUtils.parse(response.getContent());
                throw new OpsGenieClientException((String)error.get("error"), (Integer)error.get("code"));
            }
            throw new IOException(new String(response.getContent(), "UTF-8"));
        }
    }

    protected BaseResponse populateResponse(BaseRequest request, OpsGenieHttpResponse httpResponse) throws ParseException, IOException {
        return request.createResponse();
    }
}

