/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.vacuum;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.Measurement;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.services.alert.AlertEvent;
import org.lsst.ccs.services.alert.AlertListener;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.common.MonitorTaskControl;
import org.lsst.ccs.subsystem.common.actions.MpmAction;
import org.lsst.ccs.subsystem.vacuum.IonPumpDevice;
import org.lsst.ccs.subsystem.vacuum.SwitchDevice;
import org.lsst.ccs.subsystem.vacuum.SwitchInfo;
import org.lsst.ccs.subsystem.vacuum.VacPlutoDevice;
import org.lsst.ccs.subsystem.vacuum.VacTurboDevice;
import org.lsst.ccs.subsystem.vacuum.constants.ConditionState;
import org.lsst.ccs.subsystem.vacuum.constants.CryoVacuumState;
import org.lsst.ccs.subsystem.vacuum.constants.DeviceState;
import org.lsst.ccs.subsystem.vacuum.constants.Devices;
import org.lsst.ccs.subsystem.vacuum.constants.HxVacuumState;
import org.lsst.ccs.subsystem.vacuum.constants.LatchState;
import org.lsst.ccs.subsystem.vacuum.constants.PLCState;
import org.lsst.ccs.subsystem.vacuum.constants.SwitchEnable;
import org.lsst.ccs.subsystem.vacuum.constants.SwitchState;
import org.lsst.ccs.subsystem.vacuum.constants.Switches;
import org.lsst.ccs.subsystem.vacuum.constants.VacuumAlert;
import org.lsst.ccs.subsystem.vacuum.data.VacSysState;
import org.lsst.ccs.subsystem.vacuum.data.VacuumException;

public class VacuumMain
extends Subsystem
implements HasLifecycle,
AlertListener {
    private static final double PRESS_ATMOS = 759.0;
    private static final double SPEED_CRYO_TURBO_MAX = 60000.0;
    private static final double SPEED_HX_TURBO_MAX = 81000.0;
    private static final int MAX_PRESS_ERRORS = 2;
    private static final int MAX_SPEED_ERRORS = 0;
    private static final int MAX_TEMP_ERRORS = 0;
    private static final int MAX_POWER_ERRORS = 0;
    private static final int MAX_AIR_ERRORS = 0;
    private static final int DELAY_ION_OFF = 10000;
    private static final int DELAY_VACUUM_BAD = 10000;
    private static final Map<Integer, VacuumAlert> latchAlertMap = new HashMap<Integer, VacuumAlert>();
    private static final Map<String, Integer> revLatchAlertMap;
    private static final List<Integer> cryoIonPumps;
    private static final List<Integer> hxIonPumps;
    private static final List<Integer> utSwitches;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPropertiesService propertiesService;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private final List<SwitchDevice> switchDevcs = new ArrayList<SwitchDevice>();
    private Channel cryoVacPressure;
    private Channel cryoTurboPressure;
    private Channel cryoTurboTemp;
    private Channel cryoTurboPower;
    private Channel cryoFlinePressure;
    private Channel cryoTurboSpeed;
    private Channel hxVacPressure;
    private Channel hxTurboPressure;
    private Channel hxTurboTemp;
    private Channel hxTurboPower;
    private Channel hxFlinePressure;
    private Channel hxTurboSpeed;
    private Channel airPressure;
    @ConfigurationParameter(category="Vacuum", isFinal=false, range="0.0..0.5", units="Torr")
    private volatile double pressTurboLow;
    @ConfigurationParameter(category="Vacuum", isFinal=false, range="0.0..0.5", units="Torr")
    private volatile double pressForelineLow;
    @ConfigurationParameter(category="Vacuum", isFinal=false, range="0.00..0.09", units="Torr")
    private volatile double pressDiffLow;
    @ConfigurationParameter(category="Vacuum", isFinal=true)
    private volatile double pressDiffHigh;
    @ConfigurationParameter(category="Vacuum", isFinal=false, range="1.0e-6..1.1e-5", units="Torr")
    private volatile double pressIonOff;
    @ConfigurationParameter(category="Vacuum", isFinal=true)
    private volatile double pressIonEnable;
    @ConfigurationParameter(category="Vacuum", isFinal=true)
    private volatile double pressVacuum;
    @ConfigurationParameter(category="Vacuum", isFinal=true)
    private volatile double pressRefrigOk;
    @ConfigurationParameter(category="Vacuum", isFinal=false, range="0.0..0.1")
    private volatile double speedFractTurboLow;
    @ConfigurationParameter(category="Vacuum", isFinal=false, range="6.0e-5..2.0e-4", units="Torr")
    private volatile double pressCCEnable;
    @ConfigurationParameter(category="Vacuum", isFinal=false, range="1.2e-5..1.2e-4", units="Torr")
    private volatile double pressCCOff;
    @ConfigurationParameter(category="Vacuum", isFinal=false, range="0..300000", units="ms")
    private volatile double delayCCOff;
    private static final Logger LOG;
    private double speedCryoTurboLow;
    private double speedHxTurboLow;
    private MonitorTaskControl monitorControl;
    private final SwitchDevice[] switchDevices = new SwitchDevice[9];
    private VacPlutoDevice vacPlutoDevc;
    private IonPumpDevice ionPumpDevc;
    private VacTurboDevice cryoTurboDevc;
    private VacTurboDevice hxTurboDevc;
    private final VacSysState vacState = new VacSysState();
    private final Map<String, Boolean> activeAlarmMap = new HashMap<String, Boolean>();
    private long cryoIonOverStartTime = 0L;
    private long hxIonOverStartTime = 0L;
    private long cryoVacCCOverStartTime = 0L;
    private long hxVacCCOverStartTime = 0L;
    private long cryoTurboCCOverStartTime = 0L;
    private long hxTurboCCOverStartTime = 0L;
    private long vacBadTime = 0L;
    private SensorData cryoFlinePrs;
    private SensorData cryoMainPrs;
    private SensorData cryoTurboPrs;
    private SensorData cryoTurboSpd;
    private SensorData cryoTurboTmp;
    private SensorData cryoTurboPwr;
    private SensorData hxFlinePrs;
    private SensorData hxMainPrs;
    private SensorData hxTurboPrs;
    private SensorData hxTurboSpd;
    private SensorData hxTurboTmp;
    private SensorData hxTurboPwr;
    private SensorData cmpAirPrs;
    private boolean gotCommand = false;

    public VacuumMain() {
        super("vacuum", AgentInfo.AgentType.WORKER);
    }

    public void build() {
        this.monitorControl = MonitorTaskControl.createNode((Subsystem)this, (String)"MonitorControl");
        AgentPeriodicTask pt = new AgentPeriodicTask("vacuum-state", () -> this.updateVacuumState()).withPeriod(Duration.ofMillis(1000L));
        this.periodicTaskService.scheduleAgentPeriodicTask(pt);
        this.stateService.registerState(CryoVacuumState.class, "Cryo vacuum state", (Object)this);
        this.stateService.updateAgentState(new Enum[]{CryoVacuumState.UNKNOWN});
        this.stateService.registerState(HxVacuumState.class, "HX vacuum state", (Object)this);
        this.stateService.updateAgentState(new Enum[]{HxVacuumState.UNKNOWN});
        for (VacuumAlert alert : VacuumAlert.values()) {
            this.activeAlarmMap.put(alert.getId(), false);
        }
    }

    public void init() {
        for (VacuumAlert alert : VacuumAlert.values()) {
            this.alertService.registerAlert(alert.getAlert());
        }
    }

    public void postInit() {
        this.propertiesService.setAgentProperty("vacuumType", VacuumMain.class.getCanonicalName());
        this.alertService.addListener((AlertListener)this);
        for (SwitchDevice device : this.switchDevcs) {
            int id = device.getSwitchDevice();
            if (id < -1 || id >= 9) {
                throw new RuntimeException("Device of class " + device.getClass().getSimpleName() + " has invalid id: " + id);
            }
            if (id == -1) continue;
            this.switchDevices[id] = device;
        }
        for (int id = 0; id < 9; ++id) {
            if (this.switchDevices[id] != null) continue;
            throw new RuntimeException(Devices.getDescription(id) + " device not defined");
        }
        this.vacPlutoDevc = (VacPlutoDevice)this.switchDevices[0];
        this.ionPumpDevc = (IonPumpDevice)this.switchDevices[1];
        this.cryoTurboDevc = (VacTurboDevice)this.switchDevices[2];
        this.hxTurboDevc = (VacTurboDevice)this.switchDevices[3];
        if (this.cryoFlinePressure == null) {
            throw new RuntimeException("Cryo foreline pressure channel (cryoFlinePressure) not specified");
        }
        this.cryoFlinePrs = new SensorData(this.cryoFlinePressure, 2);
        if (this.cryoVacPressure == null) {
            throw new RuntimeException("Cryo vacuum pressure channel (cryoVacPressure) not specified");
        }
        this.cryoMainPrs = new SensorData(this.cryoVacPressure, 2);
        this.ionPumpDevc.setCryoPressureChannel(this.cryoVacPressure);
        if (this.cryoTurboPressure == null) {
            throw new RuntimeException("Cryo turbo pump pressure channel (cryoTurboPressure) not specified");
        }
        this.cryoTurboPrs = new SensorData(this.cryoTurboPressure, 2);
        if (this.cryoTurboSpeed == null) {
            throw new RuntimeException("Cryo turbo pump speed channel (cryoTurboSpeed) not specified");
        }
        this.cryoTurboSpd = new SensorData(this.cryoTurboSpeed, 0);
        if (this.cryoTurboTemp == null) {
            throw new RuntimeException("Cryo turbo pump temperature channel (cryoTurboTemp) not specified");
        }
        this.cryoTurboTmp = new SensorData(this.cryoTurboTemp, 0, true);
        if (this.cryoTurboPower == null) {
            throw new RuntimeException("Cryo turbo pump power channel (cryoTurboPower) not specified");
        }
        this.cryoTurboPwr = new SensorData(this.cryoTurboPower, 0, true);
        if (this.hxFlinePressure == null) {
            throw new RuntimeException("HX foreline pressure channel (hxFlinePressure) not specified");
        }
        this.hxFlinePrs = new SensorData(this.hxFlinePressure, 2);
        if (this.hxVacPressure == null) {
            throw new RuntimeException("HX vacuum pressure channel (hxVacPressure) not specified");
        }
        this.hxMainPrs = new SensorData(this.hxVacPressure, 2);
        this.ionPumpDevc.setHxPressureChannel(this.hxVacPressure);
        if (this.hxTurboPressure == null) {
            throw new RuntimeException("HX turbo pump pressure channel (hxTurboPressure) not specified");
        }
        this.hxTurboPrs = new SensorData(this.hxTurboPressure, 2);
        if (this.hxTurboSpeed == null) {
            throw new RuntimeException("HX turbo pump speed channel (hxTurboSpeed) not specified");
        }
        this.hxTurboSpd = new SensorData(this.hxTurboSpeed, 0);
        if (this.hxTurboTemp == null) {
            throw new RuntimeException("HX turbo pump temperature channel (hxTurboTemp) not specified");
        }
        this.hxTurboTmp = new SensorData(this.hxTurboTemp, 0);
        if (this.hxTurboPower == null) {
            throw new RuntimeException("HX turbo pump power channel (hxTurboPower) not specified");
        }
        this.hxTurboPwr = new SensorData(this.hxTurboPower, 0);
        if (this.airPressure == null) {
            throw new RuntimeException("Compressed air pressure channel (airPressure) not specified");
        }
        this.cmpAirPrs = new SensorData(this.airPressure, 0, true);
        this.speedCryoTurboLow = this.speedFractTurboLow * 60000.0;
        this.speedHxTurboLow = this.speedFractTurboLow * 81000.0;
    }

    public void postStart() {
        LOG.info("Vacuum subsystem started");
    }

    @Command(type=Command.CommandType.QUERY, description="Get the vacuum system state", level=0)
    public VacSysState getVacuumState() {
        this.vacState.setTickMillis(this.monitorControl.getFastPeriod());
        return this.vacState;
    }

    @Command(type=Command.CommandType.QUERY, description="Get switch names", level=0)
    public List<String> getSwitchNames() throws VacuumException {
        return Switches.getNames();
    }

    @Command(type=Command.CommandType.ACTION, description="Turn on/off a named switch")
    public void setSwitchOn(@Argument(description="The switch name") String name, @Argument(description="Whether to turn on") boolean on) throws VacuumException {
        this.gotCommand = true;
        this.setSwitch(Switches.getId(name), on);
    }

    @Command(type=Command.CommandType.QUERY, description="Print enable and state for switch")
    public String checkSwitch(@Argument(description="The switch name") String name) throws VacuumException {
        int sw = Switches.getId(name);
        SwitchEnable enable = this.vacState.getSwitchEnable(sw);
        SwitchState state = this.vacState.getSwitchState(sw);
        return "enable=" + enable.name() + ", state=" + state.name();
    }

    private void setSwitch(int sw, boolean on) throws VacuumException {
        SwitchState state = this.vacState.getSwitchState(sw);
        if (state == SwitchState.OFFLINE) {
            return;
        }
        SwitchEnable enable = this.vacState.getSwitchEnable(sw);
        if (on && enable != SwitchEnable.ON) {
            return;
        }
        try {
            this.switchDevices[Switches.getDevice(sw)].setSwitch(SwitchInfo.getSwitch(sw), on);
        }
        catch (DriverException e) {
            throw new VacuumException("Error setting switch for " + Devices.getDescription(Switches.getDevice(sw)) + " device: " + (Object)((Object)e));
        }
    }

    private Boolean isSwitchOn(int sw) {
        return this.switchDevices[Switches.getDevice(sw)].isSwitchOn(SwitchInfo.getSwitch(sw));
    }

    @Command(type=Command.CommandType.ACTION, description="Clear a condition")
    public void clearLatch(@Argument(description="The condition number") int cond) throws VacuumException {
        this.gotCommand = true;
        this.vacPlutoDevc.clearLatch(cond);
    }

    private void updateVacuumState() {
        boolean changed = this.monitorControl.hasPeriodChanged();
        changed |= this.updatePlcState();
        changed |= this.updateLatchState();
        changed |= this.updateCondState();
        if (this.readSensors()) {
            changed |= this.updateSwitchState();
            changed |= this.updateCryoState();
            changed |= this.updateHxState();
            this.checkRefrigVacuum();
        }
        if (this.gotCommand) {
            this.gotCommand = false;
            changed = true;
        }
        if (changed) {
            this.publishState();
        }
    }

    private boolean updatePlcState() {
        boolean changed = false;
        Boolean plcActive = this.vacPlutoDevc.isPLCActive();
        if (plcActive == null) {
            if (this.vacState.getPlcState() != PLCState.OFFLINE) {
                this.raiseAlarm(VacuumAlert.VACUUM_PLC_NOT_ALIVE, "Vacuum PLC is offline", null);
                this.vacState.setPlcState(PLCState.OFFLINE);
                changed = true;
            }
        } else if (!plcActive.booleanValue()) {
            if (this.vacState.getPlcState() != PLCState.DEAD) {
                this.raiseAlarm(VacuumAlert.VACUUM_PLC_NOT_ALIVE, "Vacuum PLC has died", null);
                this.vacState.setPlcState(PLCState.DEAD);
                changed = true;
            }
        } else if (this.vacState.getPlcState() != PLCState.ALIVE) {
            this.lowerAlarm(VacuumAlert.VACUUM_PLC_NOT_ALIVE, "Vacuum PLC is alive", null);
            this.vacState.setPlcState(PLCState.ALIVE);
            changed = true;
        }
        return changed;
    }

    private boolean updateLatchState() {
        boolean changed = false;
        for (int cond = 0; cond < 8; ++cond) {
            LatchState oldState;
            Boolean active = this.vacPlutoDevc.isLatchActive(cond);
            Boolean latched = this.vacPlutoDevc.isLatchLatched(cond);
            LatchState state = active == null || latched == null ? LatchState.OFFLINE : (latched != false ? LatchState.LATCHED : (active != false ? LatchState.ACTIVE : LatchState.CLEAR));
            if (state == (oldState = this.vacState.getLatch(cond))) continue;
            this.vacState.setLatch(cond, state);
            VacuumAlert alert = latchAlertMap.get(cond);
            if (state == LatchState.ACTIVE) {
                this.raiseAlarm(alert, "Vacuum PLC error condition set", null);
            } else if (state != LatchState.OFFLINE && oldState != LatchState.OFFLINE) {
                if (state == LatchState.LATCHED && oldState == LatchState.CLEAR) {
                    this.raiseAlarm(alert, "Vacuum PLC error condition set", null);
                }
                if (state == LatchState.LATCHED || oldState == LatchState.ACTIVE) {
                    this.lowerAlarm(alert, "Vacuum PLC error condition cleared", null);
                }
            }
            changed = true;
        }
        return changed;
    }

    private boolean updateCondState() {
        boolean changed = false;
        for (int cond = 0; cond < 10; ++cond) {
            ConditionState state;
            Boolean active = this.vacPlutoDevc.isConditionActive(cond);
            ConditionState conditionState = active == null ? ConditionState.OFF : (state = active != false ? ConditionState.YES : ConditionState.NO);
            if (state == this.vacState.getCondition(cond)) continue;
            this.vacState.setCondition(cond, state);
            changed = true;
        }
        return changed;
    }

    private boolean readSensors() {
        boolean valid = true;
        valid &= this.readSensor(this.cryoFlinePrs);
        valid &= this.readSensor(this.cryoMainPrs);
        valid &= this.readSensor(this.cryoTurboPrs);
        valid &= this.readSensor(this.cryoTurboSpd);
        valid &= this.readSensor(this.cryoTurboTmp);
        valid &= this.readSensor(this.cryoTurboPwr);
        valid &= this.readSensor(this.hxFlinePrs);
        valid &= this.readSensor(this.hxMainPrs);
        valid &= this.readSensor(this.hxTurboPrs);
        valid &= this.readSensor(this.hxTurboSpd);
        valid &= this.readSensor(this.hxTurboTmp);
        valid &= this.readSensor(this.hxTurboPwr);
        return valid &= this.readSensor(this.cmpAirPrs);
    }

    private boolean readSensor(SensorData data) {
        Measurement meas = data.channel.getLastMeasurement();
        if (meas.getCCSTimestamp() == null) {
            return false;
        }
        data.value = meas.getValue();
        if (!Double.isNaN(data.value)) {
            data.goodValue = data.value;
            data.numErrors = 0;
        } else if (data.numErrors++ < data.maxErrors) {
            data.value = data.goodValue;
        }
        if (data.getLimits) {
            data.lowLimit = data.channel.getLimitLo();
            data.highLimit = data.channel.getLimitHi();
        }
        return true;
    }

    private boolean updateSwitchState() {
        boolean changed = false;
        changed |= this.updateCryoGateValve();
        changed |= this.updateCryoTurboPump();
        changed |= this.updateCryoIonPumps();
        changed |= this.updateHxGateValve();
        changed |= this.updateHxTurboPump();
        changed |= this.updateHxIonPumps();
        changed |= this.updateUtSwitches();
        changed |= this.updateCryoVacCC();
        changed |= this.updateCryoTurboCC();
        changed |= this.updateHxVacCC();
        return changed |= this.updateHxTurboCC();
    }

    private boolean updateCryoGateValve() {
        boolean cryoTurbAvail;
        boolean enable = false;
        boolean bl = cryoTurbAvail = !Double.isNaN(this.cryoMainPrs.value) && !Double.isNaN(this.cryoTurboPrs.value) && !Double.isNaN(this.cryoTurboSpd.value);
        if (cryoTurbAvail) {
            double prDiff = Math.abs(this.cryoTurboPrs.value - this.cryoMainPrs.value);
            enable = (prDiff <= this.pressDiffHigh && this.cryoTurboSpd.value <= this.speedCryoTurboLow || prDiff <= this.pressDiffLow && this.cryoTurboSpd.value > this.speedCryoTurboLow) && this.cmpAirPrs.value > this.cmpAirPrs.lowLimit && this.cmpAirPrs.value <= this.cmpAirPrs.highLimit;
        }
        boolean enable2 = cryoTurbAvail && (this.cryoFlinePrs.value < this.pressForelineLow || this.cryoTurboSpd.value <= this.speedCryoTurboLow) && this.cryoTurboTmp.value < this.cryoTurboTmp.highLimit && this.cryoTurboPwr.value < this.cryoTurboPwr.highLimit;
        enable &= enable2;
        return this.updateSwitch(7, enable &= this.cryoMainPrs.value + 5.0E-5 + 0.026 * this.cryoTurboPrs.value > this.cryoTurboPrs.value, !enable2, this.vacPlutoDevc.getSwitchState(SwitchInfo.getSwitch(7)), VacuumAlert.CRYO_GATE_CLOSED);
    }

    private boolean updateCryoTurboPump() {
        boolean enable = false;
        if (!(Double.isNaN(this.cryoTurboPrs.value) || Double.isNaN(this.cryoFlinePrs.value) || Double.isNaN(this.cryoTurboSpd.value))) {
            enable = this.cryoTurboPrs.value < this.pressTurboLow && (this.cryoFlinePrs.value < this.pressForelineLow || this.cryoTurboSpd.value < this.speedCryoTurboLow);
        }
        return this.updateSwitch(0, enable, !enable, this.cryoTurboDevc.getDeviceState(), VacuumAlert.CRYO_TURBO_PUMP_STOPPED);
    }

    private boolean updateCryoIonPumps() {
        boolean changed = false;
        boolean enable = false;
        boolean turnOff = false;
        if (!Double.isNaN(this.cryoMainPrs.value)) {
            boolean bl = enable = this.cryoMainPrs.value < this.pressIonEnable;
            if (this.cryoMainPrs.value >= this.pressIonOff) {
                if (this.cryoIonOverStartTime == 0L) {
                    this.cryoIonOverStartTime = System.currentTimeMillis();
                } else {
                    turnOff = System.currentTimeMillis() - this.cryoIonOverStartTime >= 10000L;
                }
            } else {
                this.cryoIonOverStartTime = 0L;
            }
        } else {
            turnOff = true;
        }
        for (int sw : cryoIonPumps) {
            changed |= this.updateSwitch(sw, enable, turnOff, null, VacuumAlert.CRYO_ION_PUMPS_STOPPED);
        }
        return changed;
    }

    private boolean updateHxGateValve() {
        boolean hxTurbAvail;
        boolean enable = false;
        boolean bl = hxTurbAvail = !Double.isNaN(this.hxMainPrs.value) && !Double.isNaN(this.hxTurboPrs.value) && !Double.isNaN(this.hxTurboSpd.value);
        if (hxTurbAvail) {
            double prDiff = Math.abs(this.hxTurboPrs.value - this.hxMainPrs.value);
            enable = (prDiff <= this.pressDiffHigh && this.hxTurboSpd.value <= this.speedHxTurboLow || prDiff <= this.pressDiffLow && this.hxTurboSpd.value > this.speedHxTurboLow) && this.cmpAirPrs.value > this.cmpAirPrs.lowLimit && this.cmpAirPrs.value <= this.cmpAirPrs.highLimit;
        }
        boolean enable2 = hxTurbAvail && (this.hxFlinePrs.value < this.pressForelineLow || this.hxTurboSpd.value <= this.speedHxTurboLow) && this.hxTurboTmp.value < this.hxTurboTmp.highLimit && this.hxTurboPwr.value < this.hxTurboPwr.highLimit;
        enable &= enable2;
        return this.updateSwitch(12, enable &= this.hxMainPrs.value + 5.0E-5 + 0.026 * this.hxTurboPrs.value > this.hxTurboPrs.value, !enable2, this.vacPlutoDevc.getSwitchState(SwitchInfo.getSwitch(12)), VacuumAlert.HX_GATE_CLOSED);
    }

    private boolean updateHxTurboPump() {
        boolean enable = false;
        if (!(Double.isNaN(this.hxTurboPrs.value) || Double.isNaN(this.hxFlinePrs.value) || Double.isNaN(this.hxTurboSpd.value))) {
            enable = this.hxTurboPrs.value < this.pressTurboLow && (this.hxFlinePrs.value < this.pressForelineLow || this.hxTurboSpd.value < this.speedHxTurboLow);
        }
        return this.updateSwitch(9, enable, !enable, this.hxTurboDevc.getDeviceState(), VacuumAlert.HX_TURBO_PUMP_STOPPED);
    }

    private boolean updateHxIonPumps() {
        boolean changed = false;
        boolean enable = false;
        boolean turnOff = false;
        if (!Double.isNaN(this.hxMainPrs.value)) {
            boolean bl = enable = this.hxMainPrs.value < this.pressIonEnable;
            if (this.hxMainPrs.value >= this.pressIonOff) {
                if (this.hxIonOverStartTime == 0L) {
                    this.hxIonOverStartTime = System.currentTimeMillis();
                } else {
                    turnOff = System.currentTimeMillis() - this.hxIonOverStartTime >= 10000L;
                }
            } else {
                this.hxIonOverStartTime = 0L;
            }
        } else {
            turnOff = true;
        }
        for (int sw : hxIonPumps) {
            changed |= this.updateSwitch(sw, enable, turnOff, null, VacuumAlert.HX_ION_PUMPS_STOPPED);
        }
        return changed;
    }

    private boolean updateCryoVacCC() {
        boolean changed = false;
        boolean enable = false;
        boolean turnOff = false;
        if (!Double.isNaN(this.cryoMainPrs.value)) {
            boolean bl = enable = this.cryoMainPrs.value <= this.pressCCEnable;
            if (this.cryoMainPrs.value >= this.pressCCOff) {
                if (this.cryoVacCCOverStartTime == 0L) {
                    this.cryoVacCCOverStartTime = System.currentTimeMillis();
                } else {
                    turnOff = (double)(System.currentTimeMillis() - this.cryoVacCCOverStartTime) >= this.delayCCOff;
                }
            } else {
                this.cryoVacCCOverStartTime = 0L;
            }
        } else {
            turnOff = true;
        }
        return changed |= this.updateSwitch(19, enable, turnOff, null, VacuumAlert.CRYO_VAC_CC_STOPPED);
    }

    private boolean updateCryoTurboCC() {
        boolean changed = false;
        boolean enable = false;
        boolean turnOff = false;
        if (!Double.isNaN(this.cryoTurboPrs.value)) {
            boolean bl = enable = this.cryoTurboPrs.value < this.pressCCEnable;
            if (this.cryoTurboPrs.value >= this.pressCCOff) {
                if (this.cryoTurboCCOverStartTime == 0L) {
                    this.cryoTurboCCOverStartTime = System.currentTimeMillis();
                } else {
                    turnOff = (double)(System.currentTimeMillis() - this.cryoTurboCCOverStartTime) >= this.delayCCOff;
                }
            } else {
                this.cryoTurboCCOverStartTime = 0L;
            }
        } else {
            turnOff = true;
        }
        return changed |= this.updateSwitch(20, enable, turnOff, null, VacuumAlert.CRYO_TURBO_CC_STOPPED);
    }

    private boolean updateHxVacCC() {
        boolean changed = false;
        boolean enable = false;
        boolean turnOff = false;
        if (!Double.isNaN(this.hxMainPrs.value)) {
            boolean bl = enable = this.hxMainPrs.value < this.pressCCEnable;
            if (this.hxMainPrs.value >= this.pressCCOff) {
                if (this.hxVacCCOverStartTime == 0L) {
                    this.hxVacCCOverStartTime = System.currentTimeMillis();
                } else {
                    turnOff = (double)(System.currentTimeMillis() - this.hxVacCCOverStartTime) >= this.delayCCOff;
                }
            } else {
                this.hxVacCCOverStartTime = 0L;
            }
        } else {
            turnOff = true;
        }
        return changed |= this.updateSwitch(21, enable, turnOff, null, VacuumAlert.HX_VAC_CC_STOPPED);
    }

    private boolean updateHxTurboCC() {
        boolean changed = false;
        boolean enable = false;
        boolean turnOff = false;
        if (!Double.isNaN(this.hxTurboPrs.value)) {
            boolean bl = enable = this.hxTurboPrs.value < this.pressCCEnable;
            if (this.hxTurboPrs.value >= this.pressCCOff) {
                if (this.hxTurboCCOverStartTime == 0L) {
                    this.hxTurboCCOverStartTime = System.currentTimeMillis();
                } else {
                    turnOff = (double)(System.currentTimeMillis() - this.hxTurboCCOverStartTime) >= this.delayCCOff;
                }
            } else {
                this.hxTurboCCOverStartTime = 0L;
            }
        } else {
            turnOff = true;
        }
        return changed |= this.updateSwitch(22, enable, turnOff, null, VacuumAlert.HX_TURBO_CC_STOPPED);
    }

    private boolean updateUtSwitches() {
        boolean changed = false;
        for (int sw : utSwitches) {
            changed |= this.updateSwitch(sw, true, false, null, null);
        }
        return changed;
    }

    private boolean updateSwitch(int sw, boolean enable, boolean turnOff, DeviceState devState, VacuumAlert alert) {
        SwitchEnable enabled;
        Boolean isOn;
        boolean changed = false;
        SwitchState oldState = this.vacState.getSwitchState(sw);
        if (turnOff && oldState == SwitchState.ON) {
            try {
                this.setSwitch(sw, false);
                this.raiseAlarm(alert, "Switch was forced to open", null);
            }
            catch (VacuumException e) {
                LOG.log(Level.SEVERE, "Error setting switch: {0}", e);
            }
        }
        SwitchState state = (isOn = this.isSwitchOn(sw)) != null ? (isOn.booleanValue() ? SwitchState.ON : SwitchState.OFF) : SwitchState.OFFLINE;
        SwitchEnable switchEnable = enabled = enable ? SwitchEnable.ON : SwitchEnable.OFF;
        if (state != oldState || enabled != this.vacState.getSwitchEnable(sw)) {
            this.vacState.setSwitchState(sw, state);
            this.vacState.setSwitchEnable(sw, enabled);
            changed = true;
            if (enable && alert != null && this.isAlarmRaised(alert)) {
                this.lowerAlarm(alert, "Switch has become re-enabled", null);
            }
        }
        if (devState != this.vacState.getDeviceState(sw)) {
            this.vacState.setDeviceState(sw, devState);
            changed = true;
        }
        return changed;
    }

    private void checkRefrigVacuum() {
        boolean haveAlarm = this.isAlarmRaised(VacuumAlert.REFRIG_NOT_PERMITTED);
        if (this.cryoMainPrs.value < this.pressRefrigOk && this.hxMainPrs.value < this.pressRefrigOk) {
            if (haveAlarm) {
                this.lowerAlarm(VacuumAlert.REFRIG_NOT_PERMITTED, "Cryo & HX vacuums are good (< " + this.pressRefrigOk + ")", MpmAction.Action.BLOCK_REFRIG);
            }
            this.vacBadTime = 0L;
        } else {
            long time = System.currentTimeMillis();
            if (this.vacBadTime == 0L) {
                this.vacBadTime = time;
            } else if (time - this.vacBadTime >= 10000L && !haveAlarm) {
                this.raiseAlarm(VacuumAlert.REFRIG_NOT_PERMITTED, "Cryo or HX vacuum is bad (>= " + this.pressRefrigOk + ")", MpmAction.Action.BLOCK_REFRIG);
            }
        }
    }

    private boolean updateCryoState() {
        boolean changed = false;
        CryoVacuumState cvState = Double.isNaN(this.cryoMainPrs.value) ? CryoVacuumState.UNKNOWN : (this.cryoMainPrs.value <= this.pressVacuum ? CryoVacuumState.VACUUM : (this.vacState.getSwitchState(1) == SwitchState.ON ? CryoVacuumState.ION_ON : (this.vacState.getSwitchEnable(1) == SwitchEnable.ON ? CryoVacuumState.ION_OFF : (this.vacState.getSwitchState(0) == SwitchState.ON ? CryoVacuumState.TURBO_ON : (this.vacState.getSwitchEnable(0) == SwitchEnable.ON ? CryoVacuumState.TURBO_OFF : (this.cryoMainPrs.value < 759.0 ? CryoVacuumState.FORELINE : CryoVacuumState.OFF))))));
        if (cvState != this.vacState.getCryoVacuumState()) {
            this.vacState.setCryoVacuumState(cvState);
            this.stateService.updateAgentState(new Enum[]{cvState});
            changed = true;
        }
        return changed;
    }

    private boolean updateHxState() {
        boolean changed = false;
        HxVacuumState hvState = Double.isNaN(this.hxMainPrs.value) ? HxVacuumState.UNKNOWN : (this.hxMainPrs.value <= this.pressVacuum ? HxVacuumState.VACUUM : (this.vacState.getSwitchState(10) == SwitchState.ON ? HxVacuumState.ION_ON : (this.vacState.getSwitchEnable(10) == SwitchEnable.ON ? HxVacuumState.ION_OFF : (this.vacState.getSwitchState(9) == SwitchState.ON ? HxVacuumState.TURBO_ON : (this.vacState.getSwitchEnable(9) == SwitchEnable.ON ? HxVacuumState.TURBO_OFF : (this.hxMainPrs.value < 759.0 ? HxVacuumState.FORELINE : HxVacuumState.OFF))))));
        if (hvState != this.vacState.getHxVacuumState()) {
            this.vacState.setHxVacuumState(hvState);
            this.stateService.updateAgentState(new Enum[]{hvState});
            changed = true;
        }
        return changed;
    }

    private void raiseAlarm(VacuumAlert alert, String cond, MpmAction.Action action) {
        Alert al = alert.getAlert();
        if (action != null) {
            MpmAction.addData((Alert)al, (MpmAction.Action)action);
        }
        this.alertService.raiseAlert(al, AlertState.ALARM, cond);
        this.activeAlarmMap.put(alert.getId(), true);
    }

    private void lowerAlarm(VacuumAlert alert, String cond, MpmAction.Action action) {
        Alert al = alert.getAlert();
        if (action != null) {
            MpmAction.addData((Alert)al, (MpmAction.Action)action);
        }
        this.alertService.raiseAlert(al, AlertState.NOMINAL, cond);
        this.activeAlarmMap.put(alert.getId(), false);
    }

    private boolean isAlarmRaised(VacuumAlert alert) {
        return this.activeAlarmMap.get(alert.getId()) == Boolean.TRUE;
    }

    public void onAlert(AlertEvent event) {
        if (event.getType() != AlertEvent.AlertEventType.ALERT_CLEARED) {
            return;
        }
        for (String id : event.getClearedIds()) {
            Integer cond = revLatchAlertMap.get(id);
            if (cond == null) continue;
            try {
                this.clearLatch(cond);
            }
            catch (VacuumException e) {
                LOG.log(Level.SEVERE, "Error clearing latched PLC condition ({0}): {1}", new Object[]{cond, e});
            }
        }
    }

    private void publishState() {
        this.publishSubsystemDataOnStatusBus(new KeyValueData("VacuumState", (Serializable)this.getVacuumState()));
    }

    static {
        latchAlertMap.put(0, VacuumAlert.CRYO_VACUUM_BAD);
        latchAlertMap.put(1, VacuumAlert.CRYO_GATE_FORCED_SHUT);
        latchAlertMap.put(2, VacuumAlert.CRYO_GATE_CANNOT_OPEN);
        latchAlertMap.put(3, VacuumAlert.CRYO_TURBO_PUMP_BAD);
        latchAlertMap.put(4, VacuumAlert.HX_VACUUM_BAD);
        latchAlertMap.put(5, VacuumAlert.HX_GATE_FORCED_SHUT);
        latchAlertMap.put(6, VacuumAlert.HX_GATE_CANNOT_OPEN);
        latchAlertMap.put(7, VacuumAlert.HX_TURBO_PUMP_BAD);
        revLatchAlertMap = new HashMap<String, Integer>();
        for (int cond : latchAlertMap.keySet()) {
            revLatchAlertMap.put(latchAlertMap.get(cond).getId(), cond);
        }
        cryoIonPumps = new ArrayList<Integer>();
        cryoIonPumps.add(1);
        cryoIonPumps.add(2);
        cryoIonPumps.add(3);
        cryoIonPumps.add(4);
        cryoIonPumps.add(5);
        cryoIonPumps.add(6);
        hxIonPumps = new ArrayList<Integer>();
        hxIonPumps.add(10);
        hxIonPumps.add(11);
        utSwitches = new ArrayList<Integer>();
        utSwitches.add(15);
        utSwitches.add(14);
        utSwitches.add(16);
        utSwitches.add(17);
        utSwitches.add(18);
        utSwitches.add(8);
        utSwitches.add(13);
        LOG = Logger.getLogger(VacuumMain.class.getName());
    }

    static class SensorData {
        Channel channel;
        int maxErrors;
        int numErrors = 0;
        boolean getLimits = false;
        double value = 0.0;
        double goodValue = Double.NaN;
        double lowLimit;
        double highLimit;

        private SensorData(Channel channel, int maxErrors, boolean getLimits) {
            this.channel = channel;
            this.maxErrors = maxErrors;
            this.getLimits = getLimits;
        }

        private SensorData(Channel channel, int maxErrors) {
            this(channel, maxErrors, false);
        }
    }
}

