/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.vacuum;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.monitor.Device;

public class SimMks9xxDevice
extends Device {
    private static final Logger LOG = Logger.getLogger(SimMks9xxDevice.class.getName());
    private double vacValue = 760.0;
    private boolean isOnline = true;

    public void initDevice() {
        this.fullName = "Simulated MKS model 9XX";
    }

    public void initialize() {
        if (this.isOnline) {
            super.setOnline(true);
            LOG.log(Level.INFO, "Connected to {0}", this.fullName);
        }
    }

    public void close() {
    }

    public double readChannel(int hwChan, int type) {
        return this.vacValue;
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Set the pressure")
    public void setPressure(@Argument(description="Pressure value") double pressure) {
        this.vacValue = pressure;
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Set online state")
    public void setOnline(@Argument(description="Whether online") boolean on) {
        this.isOnline = on;
        if (!this.isOnline) {
            super.setOnline(false);
        }
    }
}

