/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupPath;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.subsystems.fcs.Autochanger;
import org.lsst.ccs.subsystems.fcs.AutochangerTwoLatches;
import org.lsst.ccs.subsystems.fcs.AutochangerTwoTrucks;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.common.EPOSControllerForLinearRail;
import org.lsst.ccs.subsystems.fcs.common.FilterHolder;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.simulation.SimuAutochangerPlutoGateway;
import org.lsst.ccs.subsystems.fcs.simulation.SimuEPOSController;
import org.lsst.ccs.subsystems.fcs.simulation.SimuTTC580;

public class SimuAutochangerLinearRailController
extends SimuEPOSController
implements EPOSControllerForLinearRail {
    @ConfigurationParameter(description="minimal position of the encoder ribbon.", category="controller")
    private volatile int encoderRibbonMinValue;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private Autochanger autochanger;
    private AutochangerTwoTrucks trucks;
    @LookupField(strategy=LookupField.Strategy.SIBLINGS)
    private SimuAutochangerPlutoGateway plutoGateway;
    @LookupPath
    private String nodePath;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private SimuTTC580 hyttc580;
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter="carousel")
    private FilterHolder carousel;
    private AutochangerTwoLatches latches;
    private SimuAutochangerLinearRailController slaveController;
    private boolean homingDone = true;
    private boolean brakeActivatedPub;

    @Override
    public boolean isBrakeActivatedPub() {
        return this.brakeActivatedPub;
    }

    @Override
    public void setBrakeActivatedPub(boolean brakeActivatedToPublish) {
        this.brakeActivatedPub = brakeActivatedToPublish;
    }

    public void setSsiPosition(int ssiPosition) {
        this.ssiPosition = ssiPosition;
    }

    public int getEncoderRibbonMinValue() {
        return this.encoderRibbonMinValue;
    }

    private void setTrucksPosition(int pos) {
        this.position = pos;
        if (this.isMaster()) {
            this.slaveController.setPosition(pos);
        }
        this.ssiPosition = this.encoderRibbonMinValue + pos;
    }

    private boolean isMaster() {
        return this.getName().contains(this.trucks.getMasterSide());
    }

    @Override
    public void init() {
        if (this.plutoGateway == null) {
            throw new RuntimeException("Invalid initialization. An instance of SimuAutochangerPlutoGateway should have been picked up from the Lookup tree from the siblinds of this node: " + this.nodePath);
        }
        ComponentLookup lookup = this.subs.getComponentLookup();
        this.trucks = (AutochangerTwoTrucks)lookup.getComponentByPath("autochangerTrucks");
        this.latches = (AutochangerTwoLatches)lookup.getComponentByPath("latches");
        this.setSsiPosition(this.encoderRibbonMinValue);
        if (this.isMaster()) {
            this.slaveController = "Xminus".contains(this.trucks.getMasterSide()) ? (SimuAutochangerLinearRailController)lookup.getComponentByPath("acTruckXplusController") : (SimuAutochangerLinearRailController)lookup.getComponentByPath("acTruckXminusController");
        }
        if (!this.isMaster()) {
            this.mode = EPOSEnumerations.EposMode.MASTER_ENCODER;
        }
    }

    @Override
    public void writeTargetPosition(int positionToReached) {
        this.targetPosition = positionToReached;
        int positionInitiale = this.position;
        FCSCst.FCSLOG.debug((Object)"AC trucks are moving.");
        FCSCst.FCSLOG.debug((Object)(this.name + "=> initial position = " + this.position));
        int stepsNB = Math.abs(this.targetPosition - this.position) > 10000 ? 20 : 5;
        int stepHeight = (this.targetPosition - this.position) / stepsNB;
        this.simulateTrucksMotion(positionInitiale, stepsNB, stepHeight);
        this.setTrucksPosition(this.targetPosition);
        this.trucks.updatePosition();
        this.trucks.publishData();
        FCSCst.FCSLOG.info((Object)("plutoGateway=" + this.plutoGateway.toString()));
        if (this.position == this.trucks.getHandoffPosition()) {
            FCSCst.FCSLOG.info((Object)"simulateAutochangerTrucksIsAtHandoff");
            this.plutoGateway.simulateAutochangerTrucksAreAtHandoff();
        } else if (this.position == this.trucks.getStandbyPosition()) {
            this.plutoGateway.simulateAutochangerTrucksAreAtStandby();
            if (this.carousel.isHoldingFilter()) {
                FCSCst.FCSLOG.info((Object)"simulateFilterIsOnAutochanger");
                this.plutoGateway.simulateFilterIsOnAutochanger();
            }
        } else if (this.position == this.trucks.getOnlinePosition()) {
            FCSCst.FCSLOG.info((Object)"simulateAutochangerTrucksIsOnline");
            this.plutoGateway.simulateAutochangerTrucksAreOnline();
        } else if (this.position <= this.trucks.getApproachOnlinePosition() && this.position > this.trucks.getOnlinePosition()) {
            this.plutoGateway.simulateOnlineSensorsOn();
        } else {
            FCSCst.FCSLOG.info((Object)"simulateAutochangerTrucksIsInTravel");
            this.plutoGateway.simulateAutochangerTrucksAreInTravel();
        }
        if (this.hyttc580 != null && this.autochanger.isHoldingFilter()) {
            this.updateSocketAtStandbyState(positionInitiale, this.position, this.autochanger.getFilterID());
        }
        FCSCst.FCSLOG.info((Object)("plutoGateway=" + this.plutoGateway.toString()));
    }

    private void simulateFilterPresenceSensors(int positionInitiale, int stepHeight) {
        if (positionInitiale < this.trucks.getStandbyPosition() && this.position > this.trucks.getStandbyPosition() - 2 * stepHeight && this.carousel.isHoldingFilter()) {
            FCSCst.FCSLOG.info((Object)"simulateFilterIsOnAutochanger");
            this.plutoGateway.simulateFilterIsOnAutochanger();
            if (this.carousel.getFilterID() != 0) {
                this.plutoGateway.simulateFilterIDOnAutochanger(this.carousel.getFilterID());
            }
        } else if (positionInitiale == this.trucks.getStandbyPosition() && this.position < this.trucks.getStandbyPosition() - 2 * stepHeight && this.latches.isOpened()) {
            FCSCst.FCSLOG.info((Object)"simulateAutochangerIsEmpty");
            this.plutoGateway.simulateAutochangerIsEmpty();
        }
        this.autochanger.updateStateWithSensors();
        this.trucks.publishData();
    }

    private void simulateTrucksMotion(int positionInitiale, int stepsNB, int stepHeight) {
        for (int i = 1; i < stepsNB; ++i) {
            this.setTrucksPosition(positionInitiale + i * stepHeight);
            this.trucks.updatePosition();
            FCSCst.FCSLOG.info((Object)("trucks Position=" + this.trucks.readPosition()));
            this.simulateFilterPresenceSensors(positionInitiale, stepHeight);
            FCSCst.FCSLOG.debug((Object)(this.name + "i=" + i + ",position=" + this.position));
            try {
                Thread.sleep(100L);
                if (!this.trucks.getHaltRequired().get()) continue;
                FCSCst.FCSLOG.debug((Object)(this.name + " STOP simulated trucks motion."));
                return;
            }
            catch (InterruptedException ex) {
                FCSCst.FCSLOG.error((Object)ex);
                throw new RejectedCommandException(this.name + " sleep was interrupted.");
            }
        }
    }

    private void updateSocketAtStandbyState(int initialPosition, int finalPosition, int filterID) {
        if (finalPosition == this.trucks.getApproachStandbyPosition() && initialPosition == this.trucks.getStandbyPosition()) {
            this.hyttc580.updateDisengageFromAC();
        }
        if (finalPosition == this.trucks.getStandbyPosition() && initialPosition == this.trucks.getApproachStandbyPosition()) {
            FCSCst.FCSLOG.finest((Object)("filter ID on AC before hyttc580.updateStoreFilterOnCarousel = " + this.autochanger.getFilterID()));
            this.hyttc580.updateStoreFilterOnCarousel(filterID);
            FCSCst.FCSLOG.finest((Object)("filter ID on AC after hyttc580.updateStoreFilterOnCarousel = " + this.autochanger.getFilterID()));
            this.plutoGateway.simulateFilterIDOnAutochanger(filterID);
        }
    }

    @Override
    public void configureDigitalInputOfLinearRails() {
    }

    @Override
    public void configureDigitalOutputOfLinearRails() {
    }

    @Override
    public void homing() {
        this.homingDone = true;
    }

    @Override
    public boolean isHomingDone() {
        return this.homingDone;
    }

    @Override
    public void activateBrakeAndDisable() {
        this.activateBrake();
        this.shutdownController();
    }

    @Override
    public void doReleaseBrake() {
        this.brakeActivatedPub = false;
    }

    @Override
    public boolean isBrakeActivated() {
        return this.brakeActivatedPub;
    }

    @Override
    public void activateBrake() {
        this.brakeActivatedPub = true;
    }
}

