/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.sql.Timestamp;
import java.util.Map;
import java.util.TreeMap;
import org.h2.compress.CompressDeflate;
import org.h2.compress.CompressLZF;
import org.h2.compress.Compressor;
import org.h2.message.DbException;
import org.h2.mvstore.Chunk;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.WriteBuffer;
import org.h2.mvstore.type.DataType;
import org.h2.mvstore.type.StringDataType;
import org.h2.store.fs.FilePath;
import org.h2.store.fs.FileUtils;

public class MVStoreTool {
    public static void main(String ... stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            if ("-dump".equals(stringArray[i])) {
                string = stringArray[++i];
                MVStoreTool.dump(string, new PrintWriter(System.out), true);
                continue;
            }
            if ("-info".equals(stringArray[i])) {
                string = stringArray[++i];
                MVStoreTool.info(string, new PrintWriter(System.out));
                continue;
            }
            if ("-compact".equals(stringArray[i])) {
                string = stringArray[++i];
                MVStoreTool.compact(string, false);
                continue;
            }
            if (!"-compress".equals(stringArray[i])) continue;
            string = stringArray[++i];
            MVStoreTool.compact(string, true);
        }
    }

    public static void dump(String string, boolean bl) {
        MVStoreTool.dump(string, new PrintWriter(System.out), bl);
    }

    public static void info(String string) {
        MVStoreTool.info(string, new PrintWriter(System.out));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dump(String string, Writer writer, boolean bl) {
        PrintWriter printWriter = new PrintWriter(writer, true);
        if (!FilePath.get(string).exists()) {
            printWriter.println("File not found: " + string);
            return;
        }
        long l = FileUtils.size(string);
        printWriter.printf("File %s, %d bytes, %d MB\n", string, l, l / 1024L / 1024L);
        FileChannel fileChannel = null;
        int n = 4096;
        TreeMap<Integer, Long> treeMap = new TreeMap<Integer, Long>();
        long l2 = 0L;
        try {
            int n2;
            fileChannel = FilePath.get(string).open("r");
            long l3 = fileChannel.size();
            int n3 = Long.toHexString(l3).length();
            ByteBuffer byteBuffer = ByteBuffer.allocate(4096);
            long l4 = 0L;
            long l5 = 0L;
            while (l5 < l3) {
                int n4;
                int n5;
                Object object;
                byteBuffer.rewind();
                DataUtils.readFully(fileChannel, l5, byteBuffer);
                byteBuffer.rewind();
                n2 = byteBuffer.get();
                if (n2 == 72) {
                    object = new String(byteBuffer.array(), DataUtils.LATIN).trim();
                    printWriter.printf("%0" + n3 + "x fileHeader %s%n", l5, object);
                    l5 += (long)n;
                    continue;
                }
                if (n2 != 99) {
                    l5 += (long)n;
                    continue;
                }
                byteBuffer.position(0);
                object = null;
                try {
                    object = Chunk.readChunkHeader(byteBuffer, l5);
                }
                catch (IllegalStateException illegalStateException) {
                    l5 += (long)n;
                    continue;
                }
                if (((Chunk)object).len <= 0) {
                    l5 += (long)n;
                    continue;
                }
                int n6 = ((Chunk)object).len * 4096;
                printWriter.printf("%n%0" + n3 + "x chunkHeader %s%n", l5, ((Chunk)object).toString());
                ByteBuffer byteBuffer2 = ByteBuffer.allocate(n6);
                DataUtils.readFully(fileChannel, l5, byteBuffer2);
                int n7 = byteBuffer.position();
                l5 += (long)n6;
                int n8 = ((Chunk)object).pageCount;
                l4 += (long)((Chunk)object).pageCount;
                TreeMap<Integer, Integer> treeMap2 = new TreeMap<Integer, Integer>();
                int n9 = 0;
                while (n8 > 0) {
                    boolean bl2;
                    n5 = n7;
                    try {
                        byteBuffer2.position(n7);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        printWriter.printf("ERROR illegal position %d%n", n7);
                        break;
                    }
                    int n10 = byteBuffer2.getInt();
                    byteBuffer2.getShort();
                    n4 = DataUtils.readVarInt(byteBuffer2);
                    int n11 = DataUtils.readVarInt(byteBuffer2);
                    byte by = byteBuffer2.get();
                    boolean bl3 = (by & 2) != 0;
                    boolean bl4 = bl2 = (by & 1) != 0;
                    if (bl) {
                        printWriter.printf("+%0" + n3 + "x %s, map %x, %d entries, %d bytes, maxLen %x%n", n7, (bl2 ? "node" : "leaf") + (bl3 ? " compressed" : ""), n4, bl2 ? n11 + 1 : n11, n10, DataUtils.getPageMaxLength(DataUtils.getPagePos(0, 0, n10, 0)));
                    }
                    n7 += n10;
                    Integer n12 = (Integer)treeMap2.get(n4);
                    if (n12 == null) {
                        n12 = 0;
                    }
                    treeMap2.put(n4, n12 + n10);
                    Long l6 = (Long)treeMap.get(n4);
                    if (l6 == null) {
                        l6 = 0L;
                    }
                    treeMap.put(n4, l6 + (long)n10);
                    n9 += n10;
                    l2 += (long)n10;
                    --n8;
                    long[] lArray = null;
                    long[] lArray2 = null;
                    if (bl2) {
                        int n13;
                        lArray = new long[n11 + 1];
                        for (n13 = 0; n13 <= n11; ++n13) {
                            lArray[n13] = byteBuffer2.getLong();
                        }
                        lArray2 = new long[n11 + 1];
                        for (n13 = 0; n13 <= n11; ++n13) {
                            long l7;
                            lArray2[n13] = l7 = DataUtils.readVarLong(byteBuffer2);
                        }
                    }
                    String[] stringArray = new String[n11];
                    if (n4 == 0 && bl) {
                        int n14;
                        ByteBuffer byteBuffer3;
                        Object object2;
                        int n15;
                        if (bl3) {
                            n15 = (by & 6) != 6 ? 1 : 0;
                            object2 = MVStoreTool.getCompressor(n15 != 0);
                            int n16 = DataUtils.readVarInt(byteBuffer2);
                            int n17 = n10 + n5 - byteBuffer2.position();
                            byte[] byArray = DataUtils.newBytes(n17);
                            byteBuffer2.get(byArray);
                            int n18 = n17 + n16;
                            byteBuffer3 = ByteBuffer.allocate(n18);
                            object2.expand(byArray, 0, n17, byteBuffer3.array(), 0, n18);
                        } else {
                            byteBuffer3 = byteBuffer2;
                        }
                        for (n15 = 0; n15 < n11; ++n15) {
                            stringArray[n15] = object2 = StringDataType.INSTANCE.read(byteBuffer3);
                        }
                        if (bl2) {
                            for (n15 = 0; n15 < n11; ++n15) {
                                long l8 = lArray[n15];
                                printWriter.printf("    %d children < %s @ chunk %x +%0" + n3 + "x%n", lArray2[n15], stringArray[n15], DataUtils.getPageChunkId(l8), DataUtils.getPageOffset(l8));
                            }
                            long l9 = lArray[n11];
                            printWriter.printf("    %d children >= %s @ chunk %x +%0" + n3 + "x%n", lArray2[n11], stringArray.length >= n11 ? null : stringArray[n11], DataUtils.getPageChunkId(l9), DataUtils.getPageOffset(l9));
                            continue;
                        }
                        String[] stringArray2 = new String[n11];
                        for (n14 = 0; n14 < n11; ++n14) {
                            String string2;
                            stringArray2[n14] = string2 = StringDataType.INSTANCE.read(byteBuffer3);
                        }
                        for (n14 = 0; n14 < n11; ++n14) {
                            printWriter.println("    " + stringArray[n14] + " = " + stringArray2[n14]);
                        }
                        continue;
                    }
                    if (!bl2 || !bl) continue;
                    for (int i = 0; i <= n11; ++i) {
                        long l10 = lArray[i];
                        printWriter.printf("    %d children @ chunk %x +%0" + n3 + "x%n", lArray2[i], DataUtils.getPageChunkId(l10), DataUtils.getPageOffset(l10));
                    }
                }
                n9 = Math.max(1, n9);
                for (Integer n19 : treeMap2.keySet()) {
                    n4 = 100 * (Integer)treeMap2.get(n19) / n9;
                    printWriter.printf("map %x: %d bytes, %d%%%n", n19, treeMap2.get(n19), n4);
                }
                n5 = byteBuffer2.limit() - 128;
                try {
                    byteBuffer2.position(n5);
                    printWriter.printf("+%0" + n3 + "x chunkFooter %s%n", n5, new String(byteBuffer2.array(), byteBuffer2.position(), 128, DataUtils.LATIN).trim());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    printWriter.printf("ERROR illegal footer position %d%n", n5);
                }
            }
            printWriter.printf("%n%0" + n3 + "x eof%n", l3);
            printWriter.printf("\n", new Object[0]);
            l4 = Math.max(1L, l4);
            printWriter.printf("page size total: %d bytes, page count: %d, average page size: %d bytes\n", l2, l4, l2 / l4);
            l2 = Math.max(1L, l2);
            for (Integer n20 : treeMap.keySet()) {
                n2 = (int)(100L * (Long)treeMap.get(n20) / l2);
                printWriter.printf("map %x: %d bytes, %d%%%n", n20, treeMap.get(n20), n2);
            }
        }
        catch (IOException iOException) {
            printWriter.println("ERROR: " + iOException);
            iOException.printStackTrace(printWriter);
        }
        finally {
            if (fileChannel != null) {
                try {
                    fileChannel.close();
                }
                catch (IOException iOException) {}
            }
        }
        printWriter.flush();
    }

    private static Compressor getCompressor(boolean bl) {
        return bl ? new CompressLZF() : new CompressDeflate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void info(String string, Writer writer) {
        PrintWriter printWriter = new PrintWriter(writer, true);
        if (!FilePath.get(string).exists()) {
            printWriter.println("File not found: " + string);
            return;
        }
        long l = FileUtils.size(string);
        MVStore mVStore = new MVStore.Builder().fileName(string).readOnly().open();
        try {
            Object object;
            MVMap<String, String> mVMap = mVStore.getMetaMap();
            Map<String, Object> map = mVStore.getStoreHeader();
            long l2 = DataUtils.readHexLong(map, "created", 0L);
            TreeMap<Integer, Chunk> treeMap = new TreeMap<Integer, Chunk>();
            long l3 = 0L;
            long l4 = 0L;
            long l5 = 0L;
            long l6 = 0L;
            for (Map.Entry<String, String> entry : mVMap.entrySet()) {
                object = entry.getKey();
                if (!((String)object).startsWith("chunk.")) continue;
                Chunk chunk = Chunk.fromString(entry.getValue());
                treeMap.put(chunk.id, chunk);
                l3 += (long)(chunk.len * 4096);
                l4 += chunk.maxLen;
                l5 += chunk.maxLenLive;
                if (chunk.maxLenLive <= 0L) continue;
                l6 += chunk.maxLen;
            }
            printWriter.printf("Created: %s\n", MVStoreTool.formatTimestamp(l2, l2));
            printWriter.printf("Last modified: %s\n", MVStoreTool.formatTimestamp(FileUtils.lastModified(string), l2));
            printWriter.printf("File length: %d\n", l);
            printWriter.printf("The last chunk is not listed\n", new Object[0]);
            printWriter.printf("Chunk length: %d\n", l3);
            printWriter.printf("Chunk count: %d\n", treeMap.size());
            printWriter.printf("Used space: %d%%\n", MVStoreTool.getPercent(l3, l));
            printWriter.printf("Chunk fill rate: %d%%\n", l4 == 0L ? 100 : MVStoreTool.getPercent(l5, l4));
            printWriter.printf("Chunk fill rate excluding empty chunks: %d%%\n", l6 == 0L ? 100 : MVStoreTool.getPercent(l5, l6));
            for (Map.Entry<String, String> entry : treeMap.entrySet()) {
                object = (Chunk)((Object)entry.getValue());
                long l7 = l2 + ((Chunk)object).time;
                printWriter.printf("  Chunk %d: %s, %d%% used, %d blocks", ((Chunk)object).id, MVStoreTool.formatTimestamp(l7, l2), MVStoreTool.getPercent(((Chunk)object).maxLenLive, ((Chunk)object).maxLen), ((Chunk)object).len);
                if (((Chunk)object).maxLenLive == 0L) {
                    printWriter.printf(", unused: %s", MVStoreTool.formatTimestamp(l2 + ((Chunk)object).unused, l2));
                }
                printWriter.printf("\n", new Object[0]);
            }
            printWriter.printf("\n", new Object[0]);
        }
        catch (Exception exception) {
            printWriter.println("ERROR: " + exception);
            exception.printStackTrace(printWriter);
        }
        finally {
            mVStore.close();
        }
        printWriter.flush();
    }

    private static String formatTimestamp(long l, long l2) {
        String string = new Timestamp(l).toString();
        String string2 = string.substring(0, 19);
        string2 = string2 + " (+" + (l - l2) / 1000L + " s)";
        return string2;
    }

    private static int getPercent(long l, long l2) {
        if (l == 0L) {
            return 0;
        }
        if (l == l2) {
            return 100;
        }
        return (int)(1L + 98L * l / Math.max(1L, l2));
    }

    public static void compact(String string, boolean bl) {
        String string2 = string + ".tempFile";
        FileUtils.delete(string2);
        MVStoreTool.compact(string, string2, bl);
        try {
            FileUtils.moveAtomicReplace(string2, string);
        }
        catch (DbException dbException) {
            String string3 = string + ".newFile";
            FileUtils.delete(string3);
            FileUtils.move(string2, string3);
            FileUtils.delete(string);
            FileUtils.move(string3, string);
        }
    }

    public static void compactCleanUp(String string) {
        String string2;
        String string3 = string + ".tempFile";
        if (FileUtils.exists(string3)) {
            FileUtils.delete(string3);
        }
        if (FileUtils.exists(string2 = string + ".newFile")) {
            if (FileUtils.exists(string)) {
                FileUtils.delete(string2);
            } else {
                FileUtils.move(string2, string);
            }
        }
    }

    public static void compact(String string, String string2, boolean bl) {
        MVStore mVStore = new MVStore.Builder().fileName(string).readOnly().open();
        FileUtils.delete(string2);
        MVStore.Builder builder = new MVStore.Builder().fileName(string2);
        if (bl) {
            builder.compress();
        }
        MVStore mVStore2 = builder.open();
        MVStoreTool.compact(mVStore, mVStore2);
        mVStore2.close();
        mVStore.close();
    }

    public static void compact(MVStore mVStore, MVStore mVStore2) {
        Object object;
        MVMap<String, String> mVMap = mVStore.getMetaMap();
        MVMap<String, String> mVMap2 = mVStore2.getMetaMap();
        for (Map.Entry<String, String> entry : mVMap.entrySet()) {
            object = entry.getKey();
            if (((String)object).startsWith("chunk.") || ((String)object).startsWith("map.") || ((String)object).startsWith("name.") || ((String)object).startsWith("root.")) continue;
            mVMap2.put((String)object, entry.getValue());
        }
        for (String string : mVStore.getMapNames()) {
            object = new MVMap.Builder().keyType(new GenericDataType()).valueType(new GenericDataType());
            Object m = mVStore.openMap(string, object);
            Object m2 = mVStore2.openMap(string, object);
            ((MVMap)m2).copyFrom(m);
        }
    }

    static class GenericDataType
    implements DataType {
        GenericDataType() {
        }

        @Override
        public int compare(Object object, Object object2) {
            throw DataUtils.newUnsupportedOperationException("Can not compare");
        }

        @Override
        public int getMemory(Object object) {
            return object == null ? 0 : ((byte[])object).length * 8;
        }

        @Override
        public void write(WriteBuffer writeBuffer, Object object) {
            if (object != null) {
                writeBuffer.put((byte[])object);
            }
        }

        @Override
        public void write(WriteBuffer writeBuffer, Object[] objectArray, int n, boolean bl) {
            for (Object object : objectArray) {
                this.write(writeBuffer, object);
            }
        }

        @Override
        public Object read(ByteBuffer byteBuffer) {
            int n = byteBuffer.remaining();
            if (n == 0) {
                return null;
            }
            byte[] byArray = new byte[n];
            byteBuffer.get(byArray);
            return byArray;
        }

        @Override
        public void read(ByteBuffer byteBuffer, Object[] objectArray, int n, boolean bl) {
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = this.read(byteBuffer);
            }
        }
    }
}

