/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.rotator.event;

import org.lsst.sal.SALEvent;

public class SettingsAppliedEvent
extends SALEvent {
    private final double positionAngleUpperLimit;
    private final double velocityLimit;
    private final double accelerationLimit;
    private final double positionErrorThreshold;
    private final double positionAngleLowerLimit;
    private final double followingErrorThreshold;
    private final double trackingSuccessPositionThreshold;
    private final double trackingLostTimeout;

    public SettingsAppliedEvent(int priority, double positionAngleUpperLimit, double velocityLimit, double accelerationLimit, double positionErrorThreshold, double positionAngleLowerLimit, double followingErrorThreshold, double trackingSuccessPositionThreshold, double trackingLostTimeout) {
        super(priority);
        this.positionAngleUpperLimit = positionAngleUpperLimit;
        this.velocityLimit = velocityLimit;
        this.accelerationLimit = accelerationLimit;
        this.positionErrorThreshold = positionErrorThreshold;
        this.positionAngleLowerLimit = positionAngleLowerLimit;
        this.followingErrorThreshold = followingErrorThreshold;
        this.trackingSuccessPositionThreshold = trackingSuccessPositionThreshold;
        this.trackingLostTimeout = trackingLostTimeout;
    }

    public double getPositionAngleUpperLimit() {
        return this.positionAngleUpperLimit;
    }

    public double getVelocityLimit() {
        return this.velocityLimit;
    }

    public double getAccelerationLimit() {
        return this.accelerationLimit;
    }

    public double getPositionErrorThreshold() {
        return this.positionErrorThreshold;
    }

    public double getPositionAngleLowerLimit() {
        return this.positionAngleLowerLimit;
    }

    public double getFollowingErrorThreshold() {
        return this.followingErrorThreshold;
    }

    public double getTrackingSuccessPositionThreshold() {
        return this.trackingSuccessPositionThreshold;
    }

    public double getTrackingLostTimeout() {
        return this.trackingLostTimeout;
    }

    public String toString() {
        return "SettingsAppliedEvent{positionAngleUpperLimit=" + this.positionAngleUpperLimit + ", velocityLimit=" + this.velocityLimit + ", accelerationLimit=" + this.accelerationLimit + ", positionErrorThreshold=" + this.positionErrorThreshold + ", positionAngleLowerLimit=" + this.positionAngleLowerLimit + ", followingErrorThreshold=" + this.followingErrorThreshold + ", trackingSuccessPositionThreshold=" + this.trackingSuccessPositionThreshold + ", trackingLostTimeout=" + this.trackingLostTimeout + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int priority;
        private double positionAngleUpperLimit;
        private double velocityLimit;
        private double accelerationLimit;
        private double positionErrorThreshold;
        private double positionAngleLowerLimit;
        private double followingErrorThreshold;
        private double trackingSuccessPositionThreshold;
        private double trackingLostTimeout;

        private Builder() {
        }

        public Builder priority(int priority) {
            this.priority = priority;
            return this;
        }

        public Builder positionAngleUpperLimit(double positionAngleUpperLimit) {
            this.positionAngleUpperLimit = positionAngleUpperLimit;
            return this;
        }

        public Builder velocityLimit(double velocityLimit) {
            this.velocityLimit = velocityLimit;
            return this;
        }

        public Builder accelerationLimit(double accelerationLimit) {
            this.accelerationLimit = accelerationLimit;
            return this;
        }

        public Builder positionErrorThreshold(double positionErrorThreshold) {
            this.positionErrorThreshold = positionErrorThreshold;
            return this;
        }

        public Builder positionAngleLowerLimit(double positionAngleLowerLimit) {
            this.positionAngleLowerLimit = positionAngleLowerLimit;
            return this;
        }

        public Builder followingErrorThreshold(double followingErrorThreshold) {
            this.followingErrorThreshold = followingErrorThreshold;
            return this;
        }

        public Builder trackingSuccessPositionThreshold(double trackingSuccessPositionThreshold) {
            this.trackingSuccessPositionThreshold = trackingSuccessPositionThreshold;
            return this;
        }

        public Builder trackingLostTimeout(double trackingLostTimeout) {
            this.trackingLostTimeout = trackingLostTimeout;
            return this;
        }

        public SettingsAppliedEvent build() {
            return new SettingsAppliedEvent(this.priority, this.positionAngleUpperLimit, this.velocityLimit, this.accelerationLimit, this.positionErrorThreshold, this.positionAngleLowerLimit, this.followingErrorThreshold, this.trackingSuccessPositionThreshold, this.trackingLostTimeout);
        }
    }
}

