/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.cablerotator;

import java.io.Serializable;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.RaisedAlertHistory;
import org.lsst.ccs.bus.data.RunMode;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.cablerotator.Aerotech;
import org.lsst.ccs.subsystem.cablerotator.Axis;
import org.lsst.ccs.subsystem.cablerotator.MockAscii;
import org.lsst.ccs.subsystem.motorplatform.bus.AxisStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.ChangeAxisEnable;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearAllFaults;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearAxisFaults;
import org.lsst.ccs.subsystem.motorplatform.bus.ControllerStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.DisableAllAxes;
import org.lsst.ccs.subsystem.motorplatform.bus.EnableAllAxes;
import org.lsst.ccs.subsystem.motorplatform.bus.HomeAxis;
import org.lsst.ccs.subsystem.motorplatform.bus.MotorCommandListener;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisAbsolute;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisRelative;
import org.lsst.ccs.subsystem.motorplatform.bus.PlatformConfig;
import org.lsst.ccs.subsystem.motorplatform.bus.SendAxisStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.SendConfiguration;
import org.lsst.ccs.subsystem.motorplatform.bus.SendControllerStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.StopAllMotion;

public class Controller
implements HasLifecycle,
MotorCommandListener {
    private static final Logger LOG = Logger.getLogger(Controller.class.getName());
    private static final int AEROTECH_TCP_PORT = 8000;
    private static final int AEROTECH_MOTION_TASK_NUMBER = 1;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private Subsystem subsys;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private volatile Axis axisComponent;
    @ConfigurationParameter(description="The name of the configuration used.", isFinal=true)
    private volatile String configurationName = "<none>";
    @ConfigurationParameter(description="How long to wait for the Aerotech controller to responds to a command.", isFinal=true)
    private volatile Duration commandTimeout = Duration.ofSeconds(10L);
    @ConfigurationParameter(description="The IP address of the motor controller.", isFinal=true)
    private volatile String IPv4Address = "192.168.10.40";
    private volatile Aerotech aeroLink;
    private volatile ControllerStatus controllerStat;
    private volatile AxisStatus axisStat;
    private volatile PlatformConfig motorConfig = new PlatformConfig(Arrays.asList("unknown"), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), "unknown", Arrays.asList("unknown"));
    private volatile ConnectionStatus connectionStat = ConnectionStatus.OFFLINE;
    private static final Alert ROTATOR_ALERT = new Alert("CABLE_ROTATOR", "Trouble with the cable rotator.");

    public Controller() {
        this.controllerStat = new ControllerStatus("DOWN", false, "unknown");
        this.axisStat = new AxisStatus("unknown", false, false, false, false, false, Arrays.asList("Controller not yet contacted"), -9999.0);
    }

    public void build() {
        AgentPeriodicTaskService tasksrv = (AgentPeriodicTaskService)this.subsys.getAgentService(AgentPeriodicTaskService.class);
        tasksrv.createScheduler("statusReader", 1);
        AgentPeriodicTask task = new AgentPeriodicTask("readerTask", this::updateStatus).withIsFixedRate(false);
        tasksrv.scheduleAgentPeriodicTask(task, "statusReader");
    }

    public void init() {
        this.alertService.registerAlert(ROTATOR_ALERT);
    }

    public void start() {
        this.motorConfig = new PlatformConfig(Arrays.asList(this.axisComponent.getName()), this.motorConfig.getCapture(), this.motorConfig.getDigitalInputNames(), this.motorConfig.getDigitalOutputNames(), this.motorConfig.getAnalogInputDescriptions(), this.configurationName, Arrays.asList(this.axisComponent.getUnits()));
        try {
            this.contactController();
        }
        catch (DriverException exc) {
            this.handleDriverException(exc, "Can't contact the Aerotech controller.");
        }
    }

    public void stopAllMotion(StopAllMotion cmd) {
        this.runAerotechCommands(() -> {
            this.aeroLink.stopProgram(1);
            this.aeroLink.abortAxes(this.axisComponent.getName());
        });
    }

    public void sendControllerStatus(SendControllerStatus cmd) {
        this.subsys.publishSubsystemDataOnStatusBus(new KeyValueData("ControllerStatus", (Serializable)this.controllerStat));
    }

    public void sendConfiguration(SendConfiguration cmd) {
        this.subsys.publishSubsystemDataOnStatusBus(new KeyValueData("PlatformConfig", (Serializable)this.motorConfig));
    }

    public void sendAxisStatus(SendAxisStatus cmd) {
        this.subsys.publishSubsystemDataOnStatusBus(new KeyValueData("AxisStatus", (Serializable)this.axisStat));
    }

    public void homeAxis(HomeAxis cmd) {
        Axis axis = this.getAxis(cmd.getAxisName());
        this.runAerotechCommands(() -> axis.home(this.aeroLink));
    }

    public void moveAxisAbsolute(MoveAxisAbsolute cmd) {
        Axis axis = this.getAxis(cmd.getAxisName());
        this.runAerotechCommands(() -> axis.moveAbsolute(this.aeroLink, cmd));
    }

    public void moveAxisRelative(MoveAxisRelative cmd) {
        Axis axis = this.getAxis(cmd.getAxisName());
        this.runAerotechCommands(() -> axis.moveRelative(this.aeroLink, cmd));
    }

    public void disableAllAxes(DisableAllAxes cmd) {
        this.runAerotechCommands(() -> this.axisComponent.disable(this.aeroLink));
    }

    public void enableAllAxes(EnableAllAxes cmd) {
        this.runAerotechCommands(() -> this.axisComponent.enable(this.aeroLink));
    }

    public void clearAxisFaults(ClearAxisFaults cmd) {
        Axis axis = this.getAxis(cmd.getAxisName());
        this.runAerotechCommands(() -> axis.clearFaults(this.aeroLink));
    }

    public void clearAllFaults(ClearAllFaults cmd) {
        this.runAerotechCommands(() -> this.aeroLink.clearAllFaults());
    }

    public void changeAxisEnable(ChangeAxisEnable cmd) {
        Axis axis = this.getAxis(cmd.getAxisName());
        this.runAerotechCommands(() -> {
            if (cmd.isEnabled()) {
                axis.enable(this.aeroLink);
            } else {
                axis.disable(this.aeroLink);
            }
        });
    }

    AxisStatus getAxisStatus() {
        return this.axisStat;
    }

    private synchronized void runAerotechCommands(DriverCallable cmds) {
        try {
            this.contactController();
            cmds.call();
            this.controllerStat = new ControllerStatus("UP", this.controllerStat.isMotionEnabled(), "OK");
        }
        catch (Aerotech.CommandFailureException exc) {
            LOG.log(Level.SEVERE, "Aerotech command failed.", (Throwable)((Object)exc));
            this.alertService.raiseAlert(ROTATOR_ALERT, AlertState.ALARM, exc.getMessage());
            this.controllerStat = new ControllerStatus(this.connectionStat == ConnectionStatus.ONLINE ? "UP" : "DOWN", this.controllerStat.isMotionEnabled(), "FAILED");
            LOG.severe(String.format("The failing command: %s", exc.reply.command));
            LOG.severe(String.format("The class of failure: %s", new Object[]{exc.reply.status}));
            throw new RuntimeException((Throwable)((Object)exc));
        }
        catch (DriverException exc) {
            this.handleDriverException(exc, "ASCII driver exception.");
            throw new RuntimeException(exc);
        }
        finally {
            if (!this.aeroLink.isOpen()) {
                this.aeroLink.close();
                this.connectionStat = ConnectionStatus.OFFLINE;
            }
        }
    }

    private Axis getAxis(String axisName) {
        assert (this.axisComponent != null);
        assert (axisName != null);
        if (!axisName.equals(this.axisComponent.getName())) {
            throw new IllegalArgumentException(String.format("Axis name '%s' should be '%s'.", axisName, this.axisComponent.getName()));
        }
        return this.axisComponent;
    }

    public void updateStatus() {
        this.runAerotechCommands(() -> {
            AxisStatus axstat = this.axisComponent.getStatus(this.aeroLink);
            boolean estop = this.axisComponent.hasESTOP(this.aeroLink);
            this.axisStat = axstat;
            this.controllerStat = new ControllerStatus("UP", !estop, this.controllerStat.getLastCommandStatus());
        });
        this.sendAxisStatus(new SendAxisStatus(this.axisComponent.getName()));
        this.sendControllerStatus(new SendControllerStatus());
    }

    private void contactController() throws DriverException {
        if (this.connectionStat == ConnectionStatus.OFFLINE) {
            if (this.aeroLink != null) {
                this.aeroLink.close();
            }
            MockAscii link = RunMode.isSimulation() ? new MockAscii() : new Ascii();
            link.setTimeout(this.commandTimeout.toMillis());
            link.openNet(this.IPv4Address, 8000);
            this.aeroLink = new Aerotech(link, Aerotech.ErrorHandling.THROW_EXCEPTIONS);
            this.aeroLink.setWaitMode(Aerotech.WaitMode.NOWAIT);
            this.connectionStat = ConnectionStatus.ONLINE;
            LOG.info("Connected to the Aerotech controller.");
            RaisedAlertHistory history = this.alertService.getRaisedAlertSummary().getRaisedAlert(ROTATOR_ALERT.getAlertId());
            if (history != null && history.getLatestAlertState() != AlertState.NOMINAL) {
                this.alertService.raiseAlert(ROTATOR_ALERT, AlertState.NOMINAL, "Connected to the Aerotech controller.");
            }
        }
    }

    private void handleDriverException(DriverException exc, String msg) {
        LOG.log(Level.SEVERE, msg, exc);
        this.alertService.raiseAlert(ROTATOR_ALERT, AlertState.ALARM, msg + "\n" + exc.getMessage());
        this.controllerStat = new ControllerStatus(this.connectionStat == ConnectionStatus.ONLINE ? "UP" : "DOWN", this.controllerStat.isMotionEnabled(), "FAILED");
    }

    private static enum ConnectionStatus {
        ONLINE,
        OFFLINE;

    }

    @FunctionalInterface
    private static interface DriverCallable {
        public void call() throws DriverException;
    }
}

