/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.messages.StatusStateChangeNotification;
import org.lsst.ccs.bus.states.StateBundle;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.subsystem.focalplane.states.FocalPlaneState;
import org.lsst.ccs.subsystem.ocsbridge.sim.ControlledSubsystem;
import org.lsst.ccs.subsystem.ocsbridge.sim.FocalPlane;
import org.lsst.ccs.subsystem.ocsbridge.sim.FocalPlaneInterface;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCMConfig;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCMSubsystem;
import org.lsst.ccs.subsystem.ocsbridge.util.CCS;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.ccs.utilities.location.LocationSet;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

class FocalPlaneSubsystemLayer
extends ControlledSubsystem
implements FocalPlaneInterface {
    private static final Logger LOG = Logger.getLogger(FocalPlaneSubsystemLayer.class.getName());
    private static final Map<Enum<FocalPlaneState>, Enum<FocalPlane.RaftsState>> FOCALPLANE_TO_RAFTS_STATE = new HashMap<Enum<FocalPlaneState>, Enum<FocalPlane.RaftsState>>();

    FocalPlaneSubsystemLayer(MCMSubsystem mcm, CCS ccs, MCMConfig config) {
        super(mcm, config.getFocalPlaneSubsystemName(), ccs, config);
    }

    @Override
    public void endIntegration(boolean readout, Duration exposure) throws ExecutionException {
        HashMap<String, Double> meta = new HashMap<String, Double>();
        meta.put("ExposureTime", (double)exposure.toMillis() / 1000.0);
        this.commandSender.sendCommand("setHeaderKeywords", meta);
        this.commandSender.sendCommand("endIntegration", new Object[0]);
    }

    @Override
    public void startIntegration(ImageName imageName, Map<String, String> parsedKeyValueData, LocationSet locations, String annotation) throws ExecutionException {
        String imageType = parsedKeyValueData.get("imageType");
        String testType = parsedKeyValueData.get("testType");
        String groupId = parsedKeyValueData.get("groupId");
        HashMap<String, String> meta = new HashMap<String, String>();
        meta.put("GroupId", groupId);
        meta.put("ImageType", imageType);
        if (testType != null) {
            meta.put("TestType", testType);
        }
        this.commandSender.sendCommand("setHeaderKeywords", meta);
        this.commandSender.sendCommand("startNamedIntegration", imageName, annotation, locations);
    }

    @Override
    public void clear(int nClears) throws ExecutionException {
        this.commandSender.sendCommand("clear", nClears);
    }

    @Override
    public void discardRows(int nRows) throws ExecutionException {
        this.commandSender.sendCommand("shiftNRows", nRows);
    }

    @Override
    public void play(String playlist, boolean repeat) throws ExecutionException {
        this.commandSender.sendCommand("play", playlist, repeat);
    }

    @Override
    public void definePlaylist(String playlist, String folder, String ... images) throws ExecutionException {
        this.commandSender.sendCommand("definePlaylist", playlist, folder, images);
    }

    @Override
    protected void onStateChange(StatusStateChangeNotification statusChange) {
        CCSTimeStamp when = statusChange.getCCSTimeStamp();
        StateBundle newStates = statusChange.getNewState();
        StateBundle oldStates = statusChange.getOldState();
        StateBundle changedStates = newStates.diffState(oldStates);
        changedStates.getDecodedStates().entrySet().stream().map(changedState -> (Enum)changedState.getValue()).forEachOrdered(value -> this.translateFocalPlaneStateToRaftsState(when, (Enum)value));
    }

    @Override
    protected void onConnect(AgentInfo agent, StateBundle initialState) {
        LOG.info("Focal plane connected");
        FocalPlaneState state = (FocalPlaneState)initialState.getState(FocalPlaneState.class);
        this.translateFocalPlaneStateToRaftsState(CCSTimeStamp.currentTime(), (Enum)state);
    }

    @Override
    protected void onDisconnect(AgentInfo agent) {
        LOG.info("Focal plane disconnected");
    }

    private void translateFocalPlaneStateToRaftsState(CCSTimeStamp when, Enum value) {
        LOG.log(Level.INFO, "Got focal-plane state {0} ", value);
        Enum<FocalPlane.RaftsState> converted = FOCALPLANE_TO_RAFTS_STATE.get(value);
        if (converted != null) {
            this.ccs.getAggregateStatus().add(when, new State<Enum<FocalPlane.RaftsState>>(converted));
        }
    }

    static {
        FOCALPLANE_TO_RAFTS_STATE.put((Enum<FocalPlaneState>)FocalPlaneState.NEEDS_CLEAR, FocalPlane.RaftsState.NEEDS_CLEAR);
        FOCALPLANE_TO_RAFTS_STATE.put((Enum<FocalPlaneState>)FocalPlaneState.CLEARING, FocalPlane.RaftsState.CLEARING);
        FOCALPLANE_TO_RAFTS_STATE.put((Enum<FocalPlaneState>)FocalPlaneState.INTEGRATING, FocalPlane.RaftsState.INTEGRATING);
        FOCALPLANE_TO_RAFTS_STATE.put((Enum<FocalPlaneState>)FocalPlaneState.READING_OUT, FocalPlane.RaftsState.READING_OUT);
        FOCALPLANE_TO_RAFTS_STATE.put((Enum<FocalPlaneState>)FocalPlaneState.QUIESCENT, FocalPlane.RaftsState.QUIESCENT);
        FOCALPLANE_TO_RAFTS_STATE.put((Enum<FocalPlaneState>)FocalPlaneState.ROW_SHIFT, FocalPlane.RaftsState.DISCARDING);
        FOCALPLANE_TO_RAFTS_STATE.put((Enum<FocalPlaneState>)FocalPlaneState.IMAGE_WAIT, FocalPlane.RaftsState.READING_OUT);
    }
}

