/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.plc;

import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.lsst.ccs.subsystem.shutter.plc.PLCMsg;

public abstract class MsgToPLC
extends PLCMsg {
    public static final UUID subsystemUUID = UUID.randomUUID();
    private static final int MILLISECONDS_PER_DAY = 86400000;
    private static AtomicInteger msgCounter = new AtomicInteger(0);
    private UUID id;
    private int dtime;
    private int sequence;

    protected MsgToPLC() {
        this.id = subsystemUUID;
        this.dtime = (int)(Instant.now().toEpochMilli() % 86400000L);
        this.sequence = msgCounter.incrementAndGet();
    }

    protected MsgToPLC(ByteBuffer data) {
        super(data);
        long uulow = data.getLong();
        long uuhigh = data.getLong();
        this.id = new UUID(uuhigh, uulow);
        this.dtime = data.getInt();
        this.sequence = data.getInt();
    }

    @Override
    public void encode(ByteBuffer data) {
        super.encode(data);
        data.putLong(this.id.getLeastSignificantBits());
        data.putLong(this.id.getMostSignificantBits());
        data.putInt(this.dtime);
        data.putInt(this.sequence);
    }

    public boolean hasSameIdent(MsgToPLC other) {
        return this.dtime == other.dtime && this.sequence == other.sequence && this.getVersion() == other.getVersion() && this.id.getLeastSignificantBits() == other.id.getLeastSignificantBits() && this.id.getMostSignificantBits() == other.id.getMostSignificantBits();
    }

    @Override
    public String toString() {
        return "MsgToPLC{" + super.toString() + " id=" + this.id + ", dtime=" + this.dtime + ", sequence=" + this.sequence + '}';
    }
}

