/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.thorlabs;

import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.ascii.Session;
import org.lsst.ccs.drivers.commons.DriverException;

public class ThorlabsFW {
    private final int BAUD_DEFAULT = 9600;
    private final int CHAR_TIMEOUT = 200;
    private final int INIT_TIMEOUT = 10000;
    private static final String Lbl = "ThorlabsFW ";
    private int initTimeout = 10000;
    private int finalTimeout = 200;
    private final Session session = new Session(0, ">", "", "", null, Ascii.Terminator.CR);

    public void open(String serialName, int baudRate) throws DriverException {
        DataRate dataRate = DataRate.valueOf("BAUD_" + Integer.toString(baudRate));
        this.session.open(Session.ConnType.SERIAL, serialName, baudRate, this.finalTimeout);
        this.session.setTimeout(this.initTimeout);
        try {
            this.setFW(CmndFW.DATA_RATE, dataRate.getCode());
            this.setFW(CmndFW.TRIGGER_MODE, 1);
        }
        catch (DriverException e) {
            this.close();
            throw e;
        }
    }

    public void open(String serialName) throws DriverException {
        this.open(serialName, 9600);
    }

    public void close() throws DriverException {
        this.session.close();
    }

    public void setFW(CmndFW cmnd, int setting) throws DriverException {
        if (!cmnd.setAllowed) {
            throw new DriverException("ThorlabsFW Write not allowed for " + cmnd.toString());
        }
        String[] reply = this.session.receive(cmnd.getCommand() + "=" + Integer.toString(setting));
        if (reply.length > 1) {
            if (reply[1].startsWith("Command error")) {
                throw new DriverException(Lbl + reply[1]);
            }
            throw new DriverException("ThorlabsFW unexpected reply: " + reply[1]);
        }
    }

    public String queryFW(CmndFW query) throws DriverException {
        if (!query.queryAllowed) {
            throw new DriverException("ThorlabsFW Read not allowed for " + query.toString());
        }
        String[] reply = this.session.receive(query.getCommand() + "?");
        if (reply.length != 2) {
            throw new DriverException("ThorlabsFW unexpected reply length: " + reply.length + " lines");
        }
        if (reply[1].startsWith("Command error")) {
            throw new DriverException(Lbl + reply[1]);
        }
        return reply[1];
    }

    public void saveFW() throws DriverException {
        String[] reply = this.session.receive(CmndFW.SAVE_SETTINGS.getCommand());
        if (reply.length > 1) {
            if (reply[1].startsWith("Command error")) {
                throw new DriverException(Lbl + reply[1]);
            }
            throw new DriverException("ThorlabsFW unexpected reply: " + reply[1]);
        }
    }

    void setDebug(boolean debugMode) {
        this.session.setDebug(debugMode);
    }

    static enum DataRate {
        BAUD_9600(0),
        BAUD_115200(1);

        private int rateCode;

        private DataRate(int rateCode) {
            this.rateCode = rateCode;
        }

        private int getCode() {
            return this.rateCode;
        }
    }

    public static enum CmndFW {
        IDENTIFIER("*idn", true, false),
        POSITION("pos", true, true),
        POSITION_COUNT("pcount", true, true),
        TRIGGER_MODE("trig", true, true),
        SPEED_MODE("speed", true, true),
        SENSOR_MODE("sensors", true, true),
        DATA_RATE("baud", true, true),
        SAVE_SETTINGS("save", false, false);

        private String command;
        private boolean queryAllowed;
        private boolean setAllowed;

        private CmndFW(String command, boolean queryAllowed, boolean setAllowed) {
            this.command = command;
            this.queryAllowed = queryAllowed;
            this.setAllowed = setAllowed;
        }

        public String getCommand() {
            return this.command;
        }
    }
}

