/*
 * Decompiled with CFR 0.152.
 */
package com.ifountain.opsgenie.client.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ifountain.opsgenie.client.model.ConvertFromTimeZone;
import com.ifountain.opsgenie.client.model.ObjectWithTimeZone;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.TreeMap;

public class JsonUtils {
    public static Map parse(String json) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return (Map)mapper.readValue(json, Map.class);
    }

    public static Map parse(byte[] json) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return (Map)mapper.readValue(json, Map.class);
    }

    public static String toJson(Map jsonContent) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writeValueAsString((Object)jsonContent);
    }

    public static byte[] toJsonAsBytes(Map jsonContent) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writeValueAsBytes((Object)jsonContent);
    }

    public static void fromMap(Object object, Map map) throws IOException, ParseException {
        ObjectMapper mapper = new ObjectMapper();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        mapper.setDateFormat((DateFormat)sdf);
        mapper.readerForUpdating(object).readValue(mapper.writeValueAsString((Object)map));
        if (object instanceof ConvertFromTimeZone) {
            ((ConvertFromTimeZone)object).setTime();
        }
    }

    public static Map toMap(Object object) throws IOException, ParseException {
        ObjectMapper mapper = new ObjectMapper();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        if (object instanceof ObjectWithTimeZone && ((ObjectWithTimeZone)object).getObjectTimeZone() != null) {
            sdf.setTimeZone(((ObjectWithTimeZone)object).getObjectTimeZone());
        }
        mapper.setDateFormat((DateFormat)sdf);
        return new TreeMap((Map)mapper.convertValue(object, Map.class));
    }

    public static void fromJson(Object object, String json) throws IOException, ParseException {
        ObjectMapper mapper = new ObjectMapper();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        mapper.setDateFormat((DateFormat)sdf);
        mapper.readerForUpdating(object).readValue(json);
        if (object instanceof ConvertFromTimeZone) {
            ((ConvertFromTimeZone)object).setTime();
        }
    }

    public static void fromJsonWithoutParsing(Object object, String json) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.readerForUpdating(object).readValue(json);
    }

    public static void fromJson(Object object, JsonParser parser) throws IOException, ParseException {
        ObjectMapper mapper = new ObjectMapper();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        mapper.setDateFormat((DateFormat)sdf);
        mapper.readerForUpdating(object).readValue(parser);
        if (object instanceof ConvertFromTimeZone) {
            ((ConvertFromTimeZone)object).setTime();
        }
    }

    public static void fromJsonWithoutParsing(Object object, JsonParser parser) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        mapper.setDateFormat((DateFormat)sdf);
        mapper.readerForUpdating(object).readValue(parser);
    }

    public static String toJson(Object object) throws ParseException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        if (object instanceof ObjectWithTimeZone && ((ObjectWithTimeZone)object).getObjectTimeZone() != null) {
            sdf.setTimeZone(((ObjectWithTimeZone)object).getObjectTimeZone());
        }
        mapper.setDateFormat((DateFormat)sdf);
        return mapper.writeValueAsString(object);
    }

    public static String toJsonWithoutParsing(Object object) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        mapper.setDateFormat((DateFormat)sdf);
        return mapper.writeValueAsString(object);
    }
}

