/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.ims;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.lsst.ccs.bus.annotations.SkipEncoding;
import org.lsst.ccs.utilities.location.Location;

public class DAQStats
implements Serializable {
    @SkipEncoding
    final Map<String, Long> statMap;
    @SkipEncoding
    private final Location location;
    private static final long serialVersionUID = 4987149134292057592L;

    DAQStats(int statMapInitialSize, byte bay, byte board) {
        this.statMap = new LinkedHashMap<String, Long>(statMapInitialSize);
        this.location = new Location((int)bay, (int)board);
    }

    public Location getLocation() {
        return this.location;
    }

    public Long getStatistic(String statName) {
        Long result = this.statMap.get(statName);
        if (result == null) {
            throw new IllegalArgumentException("Requested statistic name is not available: " + statName);
        }
        return result;
    }

    public Map<String, Long> getMap() {
        return Collections.unmodifiableMap(this.statMap);
    }
}

