/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.logging.Log;
import org.jgroups.protocols.MsgStats;
import org.jgroups.protocols.TP;
import org.jgroups.protocols.TpHeader;
import org.jgroups.stack.MessageProcessingPolicy;
import org.jgroups.util.AsciiString;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.MessageIterator;
import org.jgroups.util.Util;

public class SubmitToThreadPool
implements MessageProcessingPolicy {
    protected TP tp;
    protected short tp_id;
    protected Log log;

    @Override
    public void init(TP transport) {
        this.tp = transport;
        this.tp_id = this.tp.getId();
        this.log = this.tp.getLog();
    }

    @Override
    public void loopback(Message msg, boolean oob, boolean internal) {
        this.tp.submitToThreadPool(new SingleLoopbackHandler(msg), internal);
    }

    @Override
    public void process(Message msg, boolean oob, boolean internal) {
        this.tp.submitToThreadPool(new SingleMessageHandler(msg), internal);
    }

    @Override
    public void process(MessageBatch batch, boolean oob, boolean internal) {
        if (oob) {
            this.removeAndDispatchNonBundledMessages(batch);
        }
        this.tp.submitToThreadPool(new BatchHandler(batch), internal);
    }

    protected void removeAndDispatchNonBundledMessages(MessageBatch oob_batch) {
        if (oob_batch == null) {
            return;
        }
        AsciiString tmp = oob_batch.clusterName();
        byte[] cname = tmp != null ? tmp.chars() : null;
        MessageIterator it = oob_batch.iterator();
        while (it.hasNext()) {
            Message msg = (Message)it.next();
            if (!msg.isFlagSet(Message.Flag.DONT_BUNDLE) || !msg.isFlagSet(Message.Flag.OOB)) continue;
            boolean internal = msg.isFlagSet(Message.Flag.INTERNAL);
            it.remove();
            if (this.tp.statsEnabled()) {
                this.tp.getMessageStats().incrNumOOBMsgsReceived(1);
            }
            this.tp.submitToThreadPool(new SingleMessageHandlerWithClusterName(msg, cname), internal);
        }
    }

    public class SingleLoopbackHandler
    implements Runnable {
        protected final Message msg;

        public SingleLoopbackHandler(Message msg) {
            this.msg = msg;
        }

        @Override
        public void run() {
            SubmitToThreadPool.this.tp.passMessageUp(this.msg, null, false, this.msg.getDest() == null, false);
        }
    }

    protected class SingleMessageHandler
    implements Runnable {
        protected final Message msg;

        protected SingleMessageHandler(Message msg) {
            this.msg = msg;
        }

        @Override
        public void run() {
            Address dest = this.msg.getDest();
            boolean multicast = dest == null;
            try {
                if (SubmitToThreadPool.this.tp.statsEnabled()) {
                    MsgStats msg_stats = SubmitToThreadPool.this.tp.getMessageStats();
                    if (this.msg.isFlagSet(Message.Flag.OOB)) {
                        msg_stats.incrNumOOBMsgsReceived(1);
                    } else if (this.msg.isFlagSet(Message.Flag.INTERNAL)) {
                        msg_stats.incrNumInternalMsgsReceived(1);
                    } else {
                        msg_stats.incrNumMsgsReceived(1);
                    }
                    msg_stats.incrNumBytesReceived(this.msg.getLength());
                }
                byte[] cname = this.getClusterName();
                SubmitToThreadPool.this.tp.passMessageUp(this.msg, cname, true, multicast, true);
            }
            catch (Throwable t) {
                SubmitToThreadPool.this.log.error(Util.getMessage("PassUpFailure"), t);
            }
        }

        protected byte[] getClusterName() {
            TpHeader hdr = (TpHeader)this.msg.getHeader(SubmitToThreadPool.this.tp_id);
            return hdr.getClusterName();
        }
    }

    protected class BatchHandler
    implements Runnable {
        protected MessageBatch batch;

        public BatchHandler(MessageBatch batch) {
            this.batch = batch;
        }

        @Override
        public void run() {
            if (this.batch == null || !this.batch.multicast() && SubmitToThreadPool.this.tp.unicastDestMismatch(this.batch.dest())) {
                return;
            }
            if (SubmitToThreadPool.this.tp.statsEnabled()) {
                int batch_size = this.batch.size();
                MsgStats msg_stats = SubmitToThreadPool.this.tp.getMessageStats();
                if (this.batch.getMode() == MessageBatch.Mode.OOB) {
                    msg_stats.incrNumOOBMsgsReceived(batch_size);
                } else if (this.batch.getMode() == MessageBatch.Mode.INTERNAL) {
                    msg_stats.incrNumInternalMsgsReceived(batch_size);
                } else {
                    msg_stats.incrNumMsgsReceived(batch_size);
                }
                msg_stats.incrNumBatchesReceived(1);
                msg_stats.incrNumBytesReceived(this.batch.length());
                SubmitToThreadPool.this.tp.avgBatchSize().add(batch_size);
            }
            this.passBatchUp();
        }

        protected void passBatchUp() {
            SubmitToThreadPool.this.tp.passBatchUp(this.batch, true, true);
        }
    }

    protected class SingleMessageHandlerWithClusterName
    extends SingleMessageHandler {
        protected final byte[] cluster;

        @Override
        protected byte[] getClusterName() {
            return this.cluster;
        }

        protected SingleMessageHandlerWithClusterName(Message msg, byte[] cluster_name) {
            super(msg);
            this.cluster = cluster_name;
        }
    }
}

