/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.utility.constants;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.subsystem.utility.data.UtilityException;

public class MpmSwitches {
    public static final int SW_BLOCK_UT_POWER = 0;
    public static final int SW_BLOCK_REB_POWER = 1;
    public static final int SW_BLOCK_COOLANT = 2;
    public static final int SW_BLOCK_COLD_REFG = 3;
    public static final int SW_BLOCK_COLD_HEAT = 4;
    public static final int SW_BLOCK_CRYO_REFG = 5;
    public static final int SW_BLOCK_CRYO_HEAT = 6;
    public static final int NUM_SWITCHES = 7;
    private static final Map<String, Integer> NAME_MAP = new LinkedHashMap<String, Integer>();
    private static final Map<Integer, String> ID_MAP;

    public static List<String> getNames() {
        return new ArrayList<String>(NAME_MAP.keySet());
    }

    public static String getName(int id) {
        return ID_MAP.get(id);
    }

    public static int getId(String name) throws UtilityException {
        Integer id = NAME_MAP.get(name);
        if (id == null) {
            throw new UtilityException("Invalid switch name: " + name);
        }
        return id;
    }

    static {
        NAME_MAP.put("BlockColdHeat", 4);
        NAME_MAP.put("BlockColdRefg", 3);
        NAME_MAP.put("BlockCryoHeat", 6);
        NAME_MAP.put("BlockCryoRefg", 5);
        NAME_MAP.put("BlockCoolant", 2);
        NAME_MAP.put("BlockRebPower", 1);
        NAME_MAP.put("BlockUtPower", 0);
        ID_MAP = new LinkedHashMap<Integer, String>();
        for (Map.Entry<String, Integer> e : NAME_MAP.entrySet()) {
            ID_MAP.put((int)e.getValue(), e.getKey());
        }
    }
}

