import org.lsst.ccs.description.groovy.CCSBuilder;
import org.lsst.ccs.subsystem.motorplatform.main.DummyPlatform;
import org.lsst.ccs.subsystem.motorplatform.main.DummyController;
import org.lsst.ccs.subsystem.motorplatform.main.DummyAxis;
import org.lsst.ccs.subsystem.motorplatform.main.DummyAnalogInput;
import org.lsst.ccs.subsystem.motorplatform.main.DummyDigitalInput;
import org.lsst.ccs.subsystem.motorplatform.main.DummyDigitalOutput;

CCSBuilder builder = ["dummy-motorplatform"]

builder.
    dummy(DummyPlatform) {
        // Subsystem main. Takes commands from the CCS bus and
        // delegates operations to the Controller.
        
        Controller(DummyController) {
            // The Controller sends commands to the motor controller,
            // if any, and publishes status reports.
            
            // Axis names, indexes and units must match those configured in the
            // motor controller.
            XAxis(DummyAxis, axisName:"X", index:0, units:"mm")
            YAxis(DummyAxis, axisName:"Y", index:1, units: "mm")
            ThetaAxis(DummyAxis, axisName:"THETA", index:2, units:"deg")
            
            // In each category of I/O the members must be ordered
            // as the GUI and the worker subsystem expect. You can't rely
            // on the ordering of things in this description file, so
            // there's an integer "order" field used solely to sort each
            // list of I/O object into the correct order. 
            Out0(DummyDigitalOutput, lineName:"Digital out #0", order:0)
            Out1(DummyDigitalOutput, lineName:"Digital out #1", order:1)
            
            In0(DummyDigitalInput, lineName:"Digital in #0", order:0)
            In1(DummyDigitalInput, lineName:"Digital in #1", order:1)
            
            // For analog lines the GUI expects the display format to
            // come after the vertical bar in the description.
            Ana0(DummyAnalogInput, description:"Analog in #0|%10.3e", order:0)
            Ana1(DummyAnalogInput, description:"Analog in #1|%g", order:1)
        }
    
    }
