/*
 * Decompiled with CFR 0.152.
 */
package org.indilib.i4j;

import java.io.File;

public final class FileUtils {
    private static File baseDirectory;

    private FileUtils() {
    }

    public static File getI4JBaseDirectory() {
        if (baseDirectory == null) {
            boolean created;
            String userDirName = System.getProperty("user.home");
            File userDir = new File(userDirName);
            File i4jDir = new File(userDir, ".i4j");
            if (!i4jDir.exists() && !(created = i4jDir.mkdir())) {
                throw new IllegalStateException("can not create indi base directory!" + i4jDir.getAbsolutePath());
            }
            baseDirectory = i4jDir;
        }
        return baseDirectory;
    }

    public static void setI4JBaseDirectory(String newBaseDirectory) {
        boolean created;
        File i4jDir = new File(newBaseDirectory).getAbsoluteFile();
        if (!i4jDir.exists() && !(created = i4jDir.mkdir())) {
            throw new IllegalStateException("can not create indi base directory!" + i4jDir.getAbsolutePath());
        }
        baseDirectory = i4jDir;
    }

    public static String getExtensionOfFile(File file) {
        String ext = null;
        String s = file.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1);
        }
        if (ext == null) {
            return "";
        }
        return ext;
    }
}

