/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.lakeshore;

import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;

public class LS330
extends Ascii {
    public static final int MODE_LOCAL = 0;
    public static final int MODE_REMOTE = 1;
    public static final int MODE_REMOTEWITHLOCKOUT = 2;
    private Boolean verbose = false;
    private Boolean tracedebug = false;
    private Boolean fakeout = false;
    private double setPoint = -95.0;
    private String controlUnits = "C";
    private String sampleUnits = "C";
    private String controlChannel = "A";
    private String sampleChannel = "A";
    private final double maxAllowedTempC = 30.0;
    private final double minAllowedTempC = -120.0;
    private final double maxAllowedTempK = 303.15;
    private final double minAllowedTempK = 153.14999999999998;

    public LS330() {
        this.setOptions(Ascii.Option.NO_NET);
    }

    public void open(DriverConstants.ConnType type, String ident, int parm1, int parm2) throws DriverException {
        int asciiParam = LS330.makeDataCharacteristics((Ascii.DataBits)Ascii.DataBits.SEVEN, (Ascii.StopBits)Ascii.StopBits.ONE, (Ascii.Parity)Ascii.Parity.ODD, (Ascii.FlowCtrl)Ascii.FlowCtrl.NONE);
        super.open(type, ident, parm1, asciiParam);
        this.setCommandTerm(Ascii.Terminator.CRLF);
        this.setMode(Modes.REMOTE);
        this.init();
    }

    public void init() throws DriverException {
        if (this.verbose.booleanValue()) {
            System.out.println("init of Lakeshore 336");
        }
        this.setControlUnits("C");
        this.setControlChannel("A");
        this.setSampleUnits("C");
        this.setSampleChannel("A");
        this.setSetpoint(-95.0);
        this.setHeaterRange(HeaterRange.HIGH.getValue());
        if (this.tracedebug.booleanValue()) {
            System.out.println("Done with init of Lakeshore 336");
        }
    }

    public void setVerbose(boolean flag) {
        this.verbose = flag;
    }

    public void setTracedebug(boolean flag) {
        this.tracedebug = flag;
    }

    public void setFakeout(boolean flag) {
        this.fakeout = flag;
    }

    public String getIdent() throws DriverException {
        if (this.tracedebug.booleanValue()) {
            System.out.println("trace: ls330 getIdent");
        }
        String idstr = this.fakeout != false ? "Fake Lakeshore 330" : this.readLS330("*IDN?");
        if (this.verbose.booleanValue()) {
            System.out.println("ls330 getIdent: ID = " + idstr);
        }
        return idstr;
    }

    public void reset() throws DriverException {
        this.writeLS330("*RST");
    }

    public String getMode() throws DriverException {
        return this.readLS330("MODE?");
    }

    public void setMode(Modes mode) throws DriverException {
        this.writeLS330("MODE " + mode.getValue());
    }

    public double getSetpoint() throws DriverException {
        if (this.tracedebug.booleanValue()) {
            System.out.println("trace: ls330 getSetpoint");
        }
        double setp = this.fakeout != false ? this.setPoint : Double.valueOf(this.readLS330("SETP?"));
        if (this.verbose.booleanValue()) {
            System.out.println("ls330 getSetpoint: Set Point = " + setp);
        }
        this.setPoint = setp;
        return setp;
    }

    public void setSetpoint(double setp) throws DriverException {
        if (this.tracedebug.booleanValue()) {
            System.out.println("trace: ls330 setSetpoint: " + setp);
        }
        if ("C".equals(this.controlUnits) && (setp < -120.0 || setp > 30.0)) {
            throw new DriverException("Invalid set point (C): " + setp);
        }
        if ("K".equals(this.controlUnits) && (setp < 153.14999999999998 || setp > 303.15)) {
            throw new DriverException("Invalid set point (K): " + setp);
        }
        this.writeLS330("SETP " + setp);
        if (this.verbose.booleanValue()) {
            System.out.println("ls330 setSetpoint: Set Point = " + setp);
        }
        this.setPoint = setp;
    }

    public String getControlChannel() throws DriverException {
        if (this.tracedebug.booleanValue()) {
            System.out.println("trace: ls330 getControlChannel");
        }
        String chan = this.fakeout != false ? this.controlChannel : this.readLS330("CCHN?");
        if (this.verbose.booleanValue()) {
            System.out.println("ls330 getControlChannel: channel = " + chan);
        }
        this.controlChannel = chan;
        return chan;
    }

    public void setControlChannel(String chan) throws DriverException {
        if (this.tracedebug.booleanValue()) {
            System.out.println("trace: ls330 setControlChannel: " + chan);
        }
        if (!"A".equals(chan) && !"B".equals(chan)) {
            throw new DriverException("Invalid channel: " + chan);
        }
        if (!this.fakeout.booleanValue()) {
            this.writeLS330("CCHN " + chan);
        }
        if (this.verbose.booleanValue()) {
            System.out.println("ls330 setControlChannel: chan = " + chan);
        }
        this.controlChannel = chan;
    }

    public String getControlUnits() throws DriverException {
        if (this.tracedebug.booleanValue()) {
            System.out.println("trace: ls330 getControlUnits");
        }
        String unitstr = this.fakeout != false ? this.controlUnits : this.readLS330("CUNI?");
        if (this.verbose.booleanValue()) {
            System.out.println("ls330 getControlUnits: units = " + unitstr);
        }
        this.controlUnits = unitstr;
        return unitstr;
    }

    public void setControlUnits(String unitstr) throws DriverException {
        if (this.tracedebug.booleanValue()) {
            System.out.println("trace: ls330 setControlUnits: " + unitstr);
        }
        if (!"C".equals(unitstr) && !"K".equals(unitstr)) {
            throw new DriverException("Invalid units: " + unitstr);
        }
        if (!this.fakeout.booleanValue()) {
            this.writeLS330("CUNI " + unitstr);
        }
        if (this.verbose.booleanValue()) {
            System.out.println("ls330 setControlUnits: units = " + unitstr);
        }
        this.controlUnits = unitstr;
    }

    public Double getControlData() throws DriverException {
        if (this.tracedebug.booleanValue()) {
            System.out.println("trace: ls330 getControlData");
        }
        Double data = this.fakeout != false ? Double.valueOf(-95.0) : Double.valueOf(this.readLS330("CDAT?"));
        if (this.verbose.booleanValue()) {
            System.out.println("ls330 getControlData: data = " + data);
        }
        return data;
    }

    public String getSampleChannel() throws DriverException {
        if (this.tracedebug.booleanValue()) {
            System.out.println("trace: ls330 getSampleChannel");
        }
        String chan = this.fakeout != false ? this.sampleChannel : this.readLS330("SCHN?");
        if (this.verbose.booleanValue()) {
            System.out.println("ls330 getSampleChannel: channel = " + chan);
        }
        this.sampleChannel = chan;
        return chan;
    }

    public void setSampleChannel(String chan) throws DriverException {
        if (this.tracedebug.booleanValue()) {
            System.out.println("trace: ls330 setSampleChannel: " + chan);
        }
        if (!"A".equals(chan) && !"B".equals(chan)) {
            throw new DriverException("Invalid channel: " + chan);
        }
        if (!this.fakeout.booleanValue()) {
            this.writeLS330("SCHN " + chan);
        }
        if (this.verbose.booleanValue()) {
            System.out.println("ls330 setSampleChannel: units = " + chan);
        }
        this.sampleChannel = chan;
    }

    public String getSampleUnits() throws DriverException {
        if (this.tracedebug.booleanValue()) {
            System.out.println("trace: ls330 getSampleUnits");
        }
        String unitstr = this.fakeout != false ? this.sampleUnits : this.readLS330("SUNI?");
        if (this.verbose.booleanValue()) {
            System.out.println("ls330 getSampleUnits: units = " + unitstr);
        }
        this.sampleUnits = unitstr;
        return unitstr;
    }

    public void setSampleUnits(String unitstr) throws DriverException {
        if (this.tracedebug.booleanValue()) {
            System.out.println("trace: ls330 setSampleUnits: " + unitstr);
        }
        if (!"C".equals(unitstr) && !"K".equals(unitstr)) {
            throw new DriverException("Invalid units: " + unitstr);
        }
        if (!this.fakeout.booleanValue()) {
            this.writeLS330("SUNI " + unitstr);
        }
        if (this.verbose.booleanValue()) {
            System.out.println("ls330 setSampleUnits: units = " + unitstr);
        }
        this.sampleUnits = unitstr;
    }

    public Double getSampleData() throws DriverException {
        if (this.tracedebug.booleanValue()) {
            System.out.println("trace: ls330 getSampleData");
        }
        Double data = this.fakeout != false ? Double.valueOf(-95.0) : Double.valueOf(this.readLS330("SDAT?"));
        if (this.verbose.booleanValue()) {
            System.out.println("ls330 getSampleData: data = " + data);
        }
        return data;
    }

    public double getHeater() throws DriverException {
        if (this.tracedebug.booleanValue()) {
            System.out.println("ls330 getHeater: Getting heater status");
        }
        double htrpwr = this.fakeout != false ? 50.0 : Double.valueOf(this.readLS330("HEAT?"));
        if (this.verbose.booleanValue()) {
            System.out.println("ls330 getHeater: HTR = " + htrpwr);
        }
        return htrpwr;
    }

    public int getHeaterRange() throws DriverException {
        if (this.tracedebug.booleanValue()) {
            System.out.println("ls330 getHeaterRange");
        }
        int range = this.fakeout != false ? 0 : Integer.valueOf(this.readLS330("RANG?"));
        if (this.verbose.booleanValue()) {
            System.out.println("ls330 getHeaterRange: RANGE = " + range);
        }
        return range;
    }

    public boolean isInControl() throws DriverException {
        Integer tune = this.fakeout != false ? Integer.valueOf(3) : Integer.valueOf(this.readLS330("TUNE?"));
        if (this.verbose.booleanValue()) {
            System.out.println("ls330 isInControl = " + tune);
        }
        return tune != 0;
    }

    public void setHeaterRange(int range) throws DriverException {
        if (this.tracedebug.booleanValue()) {
            System.out.println("trace: ls330 setHeaterRange: " + range);
        }
        if (!this.fakeout.booleanValue()) {
            this.writeLS330("RANG " + range);
        }
        if (this.verbose.booleanValue()) {
            System.out.println("ls330 setHeaterRange: Range = " + range);
        }
    }

    public synchronized void writeLS330(String command) throws DriverException {
        if (this.fakeout.booleanValue()) {
            System.out.println("Fake LS330 Cmd: " + command);
        } else {
            this.write(command);
        }
    }

    public synchronized String readLS330() throws DriverException {
        return this.read();
    }

    public synchronized String readLS330(String command) throws DriverException {
        this.writeLS330(command);
        return this.readLS330();
    }

    public static enum Modes {
        LOCAL(0),
        REMOTE(1),
        REMOTEWITHLOCALLOCKOUT(2);

        int value;

        private Modes(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum HeaterRange {
        OFF(0),
        LOW(1),
        MEDIUM(2),
        HIGH(3);

        int value;

        private HeaterRange(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum onOff {
        OFF,
        ON;

    }
}

