/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.dataforth;

import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.dataforth.Maq20;
import org.lsst.ccs.drivers.dataforth.Maq20DiscreteFunc;

public class Maq20DiscretePWM
extends Maq20DiscreteFunc {
    private static final short TIMEBASE_ADDR = 3;
    private static final short OUTP2_ENAB_ADDR = 4;
    private static final short PERIOD_ADDR = 6;
    private static final short OUTP1_LOW_ADDR = 8;
    private static final short OUTP2_LOW_ADDR = 10;

    Maq20DiscretePWM(Maq20 maq, int modId) throws DriverException {
        super(maq, modId);
    }

    public void enable(int chan) throws DriverException {
        this.setFunction(chan, 6);
    }

    public boolean isEnabled(int chan) throws DriverException {
        return this.getFunction(chan) == 6;
    }

    public void setTimebase(int chan, int base) throws DriverException {
        this.maq.writeRegister(this.getRegAddr(chan, 6, 3), (short)base);
    }

    public int getTimebase(int chan) throws DriverException {
        return this.maq.readRegister(this.getRegAddr(chan, 6, 3));
    }

    public void enableOutput2(int chan, boolean enable) throws DriverException {
        this.maq.writeRegister(this.getRegAddr(chan, 6, 4), enable ? (short)1 : 0);
    }

    public boolean isOutput2Enabled(int chan) throws DriverException {
        return this.maq.readRegister(this.getRegAddr(chan, 6, 4)) != 0;
    }

    public void setPeriod(int chan, int period) throws DriverException {
        this.maq.writeRegisterPair(this.getRegAddr(chan, 6, 6), period);
    }

    public int getPeriod(int chan) throws DriverException {
        return this.maq.readRegisterPair(this.getRegAddr(chan, 6, 6));
    }

    public void setLowTime1(int chan, int time) throws DriverException {
        this.maq.writeRegisterPair(this.getRegAddr(chan, 6, 8), time);
    }

    public int getLowTime1(int chan) throws DriverException {
        return this.maq.readRegisterPair(this.getRegAddr(chan, 6, 8));
    }

    public void setLowTime2(int chan, int time) throws DriverException {
        this.maq.writeRegisterPair(this.getRegAddr(chan, 6, 10), time);
    }

    public int getLowTime2(int chan) throws DriverException {
        return this.maq.readRegisterPair(this.getRegAddr(chan, 6, 10));
    }
}

