/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.teststand;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.tripplitepdu.TrippLitePDU;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.subsystem.teststand.PDUDevice;
import org.lsst.ccs.subsystem.teststand.data.TSConfig;
import org.lsst.ccs.subsystem.teststand.data.TSState;
import org.lsst.ccs.utilities.logging.Logger;

public class TrippLitePDUDevice
extends Device
implements PDUDevice {
    private static final Map<String, Integer> typeMap = new HashMap<String, Integer>();
    private boolean isconnected = false;
    TSConfig cfg = new TSConfig();
    TrippLitePDU devpdu = null;
    String pdu_host = null;
    int pdu_port = 23;
    TSState.pwrstates kstate = TSState.pwrstates.NOTCONFIGURED;
    boolean open = false;
    boolean failedToInitialize = false;
    private int major_version;

    public TrippLitePDUDevice(String host, int port) throws DriverException {
        this.isconnected = true;
        this.pdu_host = host;
        this.pdu_port = port;
        this.devpdu = new TrippLitePDU();
    }

    public TrippLitePDUDevice() {
        this.devpdu = new TrippLitePDU();
    }

    protected void initDevice() {
        this.fullName = "TrippLitePDU module";
    }

    protected void close() {
        try {
            if (this.devpdu != null) {
                this.devpdu.close();
            }
            this.kstate = TSState.pwrstates.NOTCONFIGURED;
        }
        catch (DriverException e) {
            this.log.error((Object)"TrippLitePDU device failed to close!!!");
        }
    }

    protected void initialize() {
        if (this.isconnected) {
            this.log.debug((Object)"TrippLitePDU device is already initialized");
            this.log.debug((Object)"Setting device online.");
            this.kstate = TSState.pwrstates.OK;
            this.setOnline(true);
        } else if (!this.failedToInitialize) {
            this.log.error((Object)"Tried to initialize unconnected PDU device!");
            this.failedToInitialize = true;
        }
    }

    @Command(name="openftdi", description="Open FTDI connection to device")
    public void openftdi(@Argument(name="serialname", description="Serial device name") String host, @Argument(name="baud", description="baud rate") int port, @Argument(name="major_version", description="major version of PDU firmware") int major_version) throws DriverException {
        this.devpdu.openftdi(host, port, major_version);
        this.major_version = major_version;
        this.kstate = TSState.pwrstates.OK;
    }

    @Override
    @Command(type=Command.CommandType.ACTION, name="setOutletState", description="set the state of an outlet")
    public void setOutletState(@Argument(name="outlet", description="outlet number") int outlet, @Argument(name="otlstate", description="on(true)/off(false) state") boolean otlstate) {
        if (this.devpdu == null) {
            return;
        }
        try {
            this.devpdu.opennet(this.pdu_host, this.pdu_port, this.major_version);
            this.open = true;
        }
        catch (DriverException f) {
            System.out.println("Failed to open connection to TrippLitePDU device!");
            this.isconnected = false;
        }
        try {
            if (this.open) {
                this.devpdu.setOutletState(outlet, otlstate);
            }
        }
        catch (DriverException f) {
            this.log.error((Object)"Failed open/close the TrippLitePDU");
        }
        try {
            this.open = false;
            this.devpdu.close();
        }
        catch (DriverException f) {
            System.out.println("Failed to close connection to TrippLitePDU device!");
        }
    }

    @Override
    @Command(type=Command.CommandType.ACTION, name="getOutletState", description="set the state of an outlet")
    public boolean getOutletState(@Argument(name="outlet", description="outlet number") int outlet) {
        boolean otlstate = false;
        if (this.devpdu == null) {
            return false;
        }
        try {
            this.devpdu.opennet(this.pdu_host, this.pdu_port, this.major_version);
            this.open = true;
        }
        catch (DriverException f) {
            System.out.println("Failed to open connection to TrippLitePDU device!");
            this.open = false;
        }
        try {
            if (this.open) {
                this.Sleep(1.0);
                otlstate = this.devpdu.isOutletOn(outlet);
            }
        }
        catch (DriverException f) {
            this.log.error((Object)"Failed open/close the TrippLitePDU");
        }
        try {
            this.devpdu.close();
        }
        catch (DriverException f) {
            System.out.println("Failed to close connection to TrippLitePDU device!");
        }
        return otlstate;
    }

    public void Sleep(double secs) {
        try {
            Thread.sleep((int)(secs * 1000.0));
        }
        catch (InterruptedException ex) {
            System.out.println("Rude awakening!" + ex);
        }
    }

    private String getOnOff(boolean on) {
        return on ? "on" : "off";
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        Integer iType = typeMap.get(type.toUpperCase());
        if (iType == null) {
            MonitorLogUtils.reportError((Logger)this.log, (String)name, (String)"type", (Object)type);
        } else if (iType != 3) {
            MonitorLogUtils.reportError((Logger)this.log, (String)name, (String)"Wrong channel type specified! type = ", (Object)type);
        }
        return new int[]{iType, 0};
    }

    protected void initChannel(int chan, int type, int subtype) {
        try {
            if (type == 3) {
                this.log.debug((Object)("setting channel online - chan=" + chan));
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Error configuring channel type " + type + ": " + e));
        }
    }

    protected double readChannel(int chan, int type) {
        double value = 0.0;
        this.log.debug((Object)("TrippLitePDUDevice readChannel called! chan=" + chan + " type=" + type));
        try {
            if (type == 3) {
                value = 1.0;
            }
        }
        catch (Exception e) {
            this.log.debug((Object)("Error reading channel type " + type + ": " + e));
        }
        return value;
    }

    @Command(name="setstate", description="set TrippLitePDU device status")
    public void setState(int istate) {
        this.kstate = TSState.pwrstates.values()[istate];
    }

    @Command(name="getstate", description="get TrippLitePDU device status")
    public int getState() {
        return this.kstate.ordinal();
    }
}

