/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.doorman.main;

import java.io.Serializable;
import java.time.Instant;
import java.util.HashMap;
import java.util.Optional;
import java.util.stream.Stream;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.subsystem.doorman.main.DoorChannel;
import org.lsst.ccs.subsystem.doorman.main.Instrument;
import org.lsst.ccs.subsystem.doorman.main.InstrumentConfig;
import org.lsst.ccs.subsystem.doorman.main.InstrumentStatus;
import org.lsst.ccs.subsystem.doorman.main.TrendableRecord;

public class DummyInstrument
implements Instrument {
    private final int index;
    private final boolean enabled;
    private final long nops;
    private final Optional<HardwareException> lastExc;
    private final Optional<TrendableRecord> lastData;
    private final int excCount;
    private static final String LOCATION = "doormanTest/dummyDoor";

    public DummyInstrument(InstrumentConfig config) {
        this.index = config.index;
        this.enabled = false;
        this.nops = 0L;
        this.lastExc = Optional.empty();
        this.lastData = Optional.empty();
        this.excCount = 0;
    }

    private DummyInstrument(int index, boolean enabled, long nops, Optional<HardwareException> exc, Optional<TrendableRecord> data, int excCount) {
        this.index = index;
        this.enabled = enabled;
        this.nops = nops;
        this.lastExc = exc;
        this.lastData = data;
        this.excCount = excCount;
    }

    @Override
    public Optional<HardwareException> getLastException() {
        return this.lastExc;
    }

    @Override
    public int getExceptionCount() {
        return this.excCount;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public InstrumentStatus getStatus() {
        return new InstrumentStatus(this.index, this.enabled, LOCATION);
    }

    @Override
    public Stream<TrendableRecord> getTrendables() {
        return this.lastData.map(Stream::of).orElseGet(Stream::empty);
    }

    @Override
    public Instrument disable() {
        long n = this.nops + 1L;
        Optional<HardwareException> exc = n % 5L == 0L ? Optional.of(new HardwareException("Simulated exception during disable.", null)) : Optional.empty();
        return new DummyInstrument(this.index, false, n, exc, this.lastData, exc.isPresent() ? this.excCount + 1 : 0);
    }

    @Override
    public Instrument enable() {
        long n = this.nops + 1L;
        Optional<HardwareException> exc = n % 5L == 0L ? Optional.of(new HardwareException("Simulated exception during enable.", null)) : Optional.empty();
        return new DummyInstrument(this.index, true, n, exc, this.lastData, exc.isPresent() ? this.excCount + 1 : 0);
    }

    @Override
    public Instrument read() {
        long n = this.nops + 1L;
        if (n % 5L == 0L) {
            return new DummyInstrument(this.index, this.enabled, n, Optional.of(new HardwareException(false, "Simulated exception during read.")), Optional.empty(), this.excCount + 1);
        }
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException exc) {
            Thread.currentThread().interrupt();
            return new DummyInstrument(this.index, this.enabled, n, Optional.empty(), Optional.empty(), this.excCount);
        }
        Instant now = Instant.now();
        HashMap<String, Serializable> channels = new HashMap<String, Serializable>();
        double chanval = Math.cos(now.getEpochSecond());
        channels.put(DoorChannel.ROOM_TEMP.getKey(), Double.valueOf(chanval));
        boolean viol = chanval > 0.8;
        TrendableRecord msg = new TrendableRecord(LOCATION, now, channels);
        return new DummyInstrument(this.index, this.enabled, n, Optional.empty(), Optional.of(msg), 0);
    }
}

