/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal;

import java.time.Duration;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.lsst.sal.SAL;
import org.lsst.sal.SALCommand;
import org.lsst.sal.SALCommandResponse;
import org.lsst.sal.SALEvent;
import org.lsst.sal.SALException;
import org.lsst.sal.SALReceivedCommand;
import org.lsst.sal.SALTelemetry;

public class SALStandaloneImplementation<C extends SALCommand, E extends SALEvent, T extends SALTelemetry>
implements SAL<C, E, T> {
    private final BlockingQueue<SALReceivedCommand> commandQueue = new LinkedBlockingQueue<SALReceivedCommand>();
    private final BlockingQueue<E> eventQueue = new LinkedBlockingQueue();
    private final BlockingQueue<T> telemetryQueue = new LinkedBlockingQueue<T>();
    private final AtomicInteger nextCmdId = new AtomicInteger();

    @Override
    public SALReceivedCommand<C> getNextCommand(Duration timeout) throws SALException {
        try {
            return this.commandQueue.poll(timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            throw new SALException("Interrupt while waiting for command ", ex);
        }
    }

    @Override
    public SALCommandResponse issueCommand(C command) throws SALException {
        int cmdId = this.nextCmdId.getAndIncrement();
        final CompletableFuture ack = new CompletableFuture();
        final CompletableFuture complete = new CompletableFuture();
        SALCommandResponse commandResponse = new SALCommandResponse(){

            @Override
            public Duration waitForAck(Duration timeout) throws SALCommandResponse.CommandFailedException, SALException, TimeoutException {
                try {
                    return (Duration)ack.get(timeout.toMillis(), TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException ex) {
                    throw new SALException("Interrupt while waiting for command ack ", ex);
                }
                catch (ExecutionException ex) {
                    throw new SALException("Command Failed", ex.getCause());
                }
            }

            @Override
            public int waitForCompletion(Duration timeout) throws SALCommandResponse.CommandFailedException, SALException, TimeoutException {
                try {
                    return (Integer)complete.get(timeout.toMillis(), TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException ex) {
                    throw new SALException("Interrupt while waiting for command completion ", ex);
                }
                catch (ExecutionException ex) {
                    throw new SALException("Command Failed", ex.getCause());
                }
            }
        };
        SALReceivedCommand receivedCommand = new SALReceivedCommand(cmdId, (SALCommand)command){

            @Override
            public void acknowledgeCommand(Duration timeToComplete) throws SALException {
                ack.complete(timeToComplete);
            }

            @Override
            public void reportComplete() throws SALException {
                complete.complete(303);
            }

            @Override
            public void reportError(int errorCode, String message) throws SALException {
                complete.complete(errorCode);
            }

            @Override
            public void rejectCommand(String reason, int errorCode) throws SALException {
                complete.complete(-303);
            }
        };
        this.commandQueue.add(receivedCommand);
        return commandResponse;
    }

    @Override
    public void logEvent(E event) throws SALException {
        this.eventQueue.add(event);
    }

    @Override
    public E getNextEvent(Duration timeout) throws SALException {
        try {
            return (E)((SALEvent)this.eventQueue.poll(timeout.toMillis(), TimeUnit.MILLISECONDS));
        }
        catch (InterruptedException ex) {
            throw new SALException("Interrupt while waiting for event ", ex);
        }
    }

    @Override
    public void sendTelemetry(T telemetry) throws SALException {
        this.telemetryQueue.add(telemetry);
    }

    @Override
    public T getTelemetry(Duration timeout) throws SALException {
        try {
            return (T)((SALTelemetry)this.telemetryQueue.poll(timeout.toMillis(), TimeUnit.MILLISECONDS));
        }
        catch (InterruptedException ex) {
            throw new SALException("Interrupt while waiting for telemetry ", ex);
        }
    }

    @Override
    public void close() throws SALException {
    }

    @Override
    public String getSALVersion() {
        return "bogus";
    }

    @Override
    public String getXMLVersion() {
        return "bogus";
    }

    @Override
    public String getOSPLVersion() {
        return "bogus";
    }
}

