/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.vacuum;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.drivers.auxelex.Pdu24VD;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.vacuum.SwitchDevice;

public class VacPduDevice
extends Device
implements SwitchDevice {
    public static final int CHAN_CRYO_SCROLL = 7;
    public static final int CHAN_HEX_SCROLL = 8;
    public static final int CHAN_INST_SCROLL = 9;
    protected static final int MON_TYPE_VOLTAGE = 0;
    protected static final int MON_TYPE_CURRENT = 1;
    private static final Map<String, Integer> mTypeMap = new HashMap<String, Integer>();
    private static final Set<Integer> validChans;
    protected static final Logger LOG;
    @ConfigurationParameter(category="Vacuum", isFinal=true)
    protected volatile Integer node;
    private final Pdu24VD pdu = new Pdu24VD();
    private boolean initError = false;

    protected void initDevice() {
        this.fullName = "24V dirty PDU (" + this.node + ")";
    }

    protected void initialize() {
        block2: {
            try {
                this.pdu.open(this.node.intValue(), 8193);
                this.initSensors();
                LOG.log(Level.INFO, "Connected to {0}", this.fullName);
                this.initError = false;
                this.setOnline(true);
            }
            catch (DriverException e) {
                if (this.initError) break block2;
                LOG.log(Level.SEVERE, "Error connecting to {0}: {1}", new Object[]{this.fullName, e});
                this.initError = true;
            }
        }
    }

    protected void close() {
        try {
            this.pdu.close();
        }
        catch (DriverException e) {
            LOG.log(Level.SEVERE, "Error disconnecting from {0}:{1}", new Object[]{this.fullName, e});
        }
    }

    protected int[] checkChannel(Channel ch) throws Exception {
        int hwChan;
        String type = ch.getTypeStr();
        Integer mType = mTypeMap.get(type.toUpperCase());
        if (mType == null) {
            ErrorUtils.reportChannelError((Logger)LOG, (String)ch.getPath(), (String)"type", (Object)type);
        }
        if (!validChans.contains(hwChan = ch.getHwChan())) {
            ErrorUtils.reportChannelError((Logger)LOG, (String)ch.getPath(), (String)"hwChan", (Object)hwChan);
        }
        return new int[]{mType, 0};
    }

    protected double readChannel(Channel ch) {
        double value = Double.NaN;
        String item = null;
        if (this.isOnline()) {
            try {
                switch (ch.getType()) {
                    case 0: {
                        item = "voltage";
                        value = this.pdu.readVoltage(ch.getHwChan());
                        break;
                    }
                    case 1: {
                        item = "current";
                        value = this.pdu.readCurrent(ch.getHwChan());
                    }
                }
            }
            catch (DriverException e) {
                LOG.log(Level.SEVERE, "Error reading {0} {1}: {2}", new Object[]{this.fullName, item, e});
                this.setOnline(false);
            }
        }
        return value;
    }

    @Override
    public int getSwitchDevice() {
        return 4;
    }

    @Override
    public void setSwitch(int chan, boolean on) throws DriverException {
        if (!validChans.contains(chan)) {
            throw new RuntimeException("Programming error!!  Invalid channel number: " + chan);
        }
        if (on) {
            this.pdu.powerOn(chan);
        } else {
            this.pdu.powerOff(chan);
        }
    }

    @Override
    public Boolean isSwitchOn(int chan) {
        if (!this.isOnline() || !validChans.contains(chan)) {
            return null;
        }
        try {
            return this.pdu.isPowered(chan);
        }
        catch (DriverException e) {
            LOG.log(Level.SEVERE, "Error getting state for {0} channel {1}: {2}", new Object[]{this.path, chan, e});
            this.setOnline(false);
            return null;
        }
    }

    static {
        mTypeMap.put("VOLTAGE", 0);
        mTypeMap.put("CURRENT", 1);
        validChans = new HashSet<Integer>();
        validChans.add(7);
        validChans.add(8);
        validChans.add(9);
        LOG = Logger.getLogger(VacPduDevice.class.getName());
    }
}

