/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power;

import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.PowerSupplyDriver;
import org.lsst.ccs.subsystem.power.PowerDevice;

public class SimPowerDevice
extends PowerDevice {
    private double[] loads;

    public SimPowerDevice() {
        super("Simulated PS", new SimPowerSupply(), DriverConstants.ConnType.NET, "", 0, 14, 0, 0);
    }

    public void init() {
        super.init();
        ((SimPowerSupply)this.getPowerDriver()).setLoads(this.loads);
        this.setMaxChannel(this.loads.length - 1);
    }

    static class SimPowerSupply
    implements PowerSupplyDriver {
        private int nChans;
        private double[] loads;
        private double[] voltages;
        private double[] currents;
        private double[] onDelays;
        private double[] offDelays;
        private boolean[] powerOn;
        private boolean open;

        SimPowerSupply() {
        }

        public void setLoads(double[] loads) {
            this.nChans = loads.length;
            this.loads = loads;
            this.voltages = new double[this.nChans];
            this.currents = new double[this.nChans];
            this.onDelays = new double[this.nChans];
            this.offDelays = new double[this.nChans];
            this.powerOn = new boolean[this.nChans];
        }

        public void open(DriverConstants.ConnType connType, String id, int parm) throws DriverException {
            if (this.open) {
                throw new DriverException("Device already open");
            }
            this.open = true;
        }

        public void close() throws DriverException {
            this.checkOpen();
            this.open = false;
        }

        public void setVoltage(double voltage, int hwChan) throws DriverException {
            this.checkOpen();
            this.voltages[hwChan] = voltage;
        }

        public double getVoltage(int hwChan) throws DriverException {
            this.checkOpen();
            return this.voltages[hwChan];
        }

        public double readVoltage(int hwChan) throws DriverException {
            this.checkOpen();
            double value = 0.0;
            if (this.powerOn[hwChan]) {
                if (this.loads[hwChan] > 0.0) {
                    value = this.voltages[hwChan] / this.loads[hwChan];
                    if (value > this.currents[hwChan]) {
                        value = this.currents[hwChan];
                    }
                    value *= this.loads[hwChan];
                } else {
                    value = this.voltages[hwChan];
                }
                value += 0.01 * Math.random();
            }
            return value;
        }

        public void setCurrent(double current, int hwChan) throws DriverException {
            this.checkOpen();
            this.currents[hwChan] = current;
        }

        public double getCurrent(int hwChan) throws DriverException {
            this.checkOpen();
            return this.currents[hwChan];
        }

        public double readCurrent(int hwChan) throws DriverException {
            this.checkOpen();
            double value = 0.0;
            if (this.powerOn[hwChan] && this.loads[hwChan] > 0.0) {
                value = this.voltages[hwChan] / this.loads[hwChan];
                value = value <= this.currents[hwChan] ? (value += 0.01 * Math.random()) : this.currents[hwChan];
            }
            return value;
        }

        public void setOnDelay(double onDelay, int hwChan) throws DriverException {
            this.checkOpen();
            this.onDelays[hwChan] = onDelay;
        }

        public void setOffDelay(double offDelay, int hwChan) throws DriverException {
            this.checkOpen();
            this.offDelays[hwChan] = offDelay;
        }

        public void setOutput(boolean onState, int hwChan) throws DriverException {
            this.checkOpen();
            this.powerOn[hwChan] = onState;
        }

        public boolean getOutput(int hwChan) throws DriverException {
            this.checkOpen();
            return this.powerOn[hwChan];
        }

        private void checkOpen() throws DriverException {
            if (!this.open) {
                throw new DriverException("Connection not open");
            }
        }
    }
}

