/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common.devices.turbopump;

import java.util.logging.Logger;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupPath;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;
import org.lsst.ccs.drivers.twistorr.TwisTorr84;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.common.alerts.TurboAlerts;
import org.lsst.ccs.subsystem.common.devices.vacuum.states.TurboState;

public class TwisTorr84Device
extends Device {
    @LookupPath
    protected String path;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentStateService stateService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    private final TwisTorr84 turbo = new TwisTorr84();
    private Integer chanKey;
    private volatile TurboState lastState;
    @ConfigurationParameter(isFinal=true, description="serial port")
    protected volatile String devcId;
    @ConfigurationParameter(isFinal=true, description="true/false for model 304/84 pump")
    protected volatile Boolean model304;
    @ConfigurationParameter(isFinal=true, description="true/false for low/normal speed")
    protected volatile Boolean lowSpeedMode;
    @ConfigurationParameter(isFinal=true, description="true/false for water/air cooling")
    protected volatile Boolean waterCooling;
    @ConfigurationParameter(isFinal=true, description="true/false for manual/auto")
    protected volatile Boolean ventValveByCmnd;
    @ConfigurationParameter(isFinal=true, description="true/false for continuous/impulse")
    protected volatile Boolean interlockType;
    @ConfigurationParameter(description="Soft-Start mode <true|false>, settable only if pump is stopped")
    protected volatile Boolean softStartMode;
    @ConfigurationParameter(description="Active-Stop mode <true|false>, settable only if pump is stopped")
    protected volatile Boolean activeStopMode;
    private static final Logger LOG = Logger.getLogger(TwisTorr84Device.class.getName());
    private static final String autotuneMsg = "AStress due to leak, for-pressure too high, gas flow too high, or turbo damage. Mitigate within 15 min to avoid FAIL state.";
    private final int rotfreq_set_84 = 1350;
    private final int rotfreq_set_304 = 1010;
    private final int rotfreq_low_84 = 1100;
    private final int rotfreq_low_304 = 900;
    private final Boolean gasType_84 = false;

    protected void initDevice() {
        this.stateService.registerState(TurboState.class, "Turbo-pump State", (Object)this);
        this.alertService.registerAlert(TurboAlerts.IN_AUTOTUNING.newAlert(this.path));
        this.chanKey = 0;
        if (this.devcId == null) {
            ErrorUtils.reportConfigError(LOG, this.name, "devcId", "is missing");
        }
        this.fullName = "TwisTorr84 (" + this.name + ")";
        if (this.model304 == null) {
            ErrorUtils.reportConfigError(LOG, this.name, "model304", "is missing");
        }
        if (this.lowSpeedMode == null) {
            ErrorUtils.reportConfigError(LOG, this.name, "lowSpeedMode", "is missing");
        }
        if (this.waterCooling == null) {
            ErrorUtils.reportConfigError(LOG, this.name, "waterCooling", "is missing");
        }
        if (this.ventValveByCmnd == null) {
            ErrorUtils.reportConfigError(LOG, this.name, "ventValveByCmnd", "is missing");
        }
        if (this.interlockType == null) {
            ErrorUtils.reportConfigError(LOG, this.name, "interlockType", "is missing");
        }
        if (this.softStartMode == null) {
            ErrorUtils.reportConfigError(LOG, this.name, "softStartMode", "is missing");
        }
        if (this.activeStopMode == null) {
            ErrorUtils.reportConfigError(LOG, this.name, "activeStopMode", "is missing");
        }
    }

    protected void initialize() {
        try {
            this.turbo.open(this.devcId);
            this.turbo.writeBool(TwisTorr84.CmndBool.LOW_SPEED, this.lowSpeedMode.booleanValue());
            this.turbo.writeBool(TwisTorr84.CmndBool.VENTVALVE_BY_CMND, this.ventValveByCmnd.booleanValue());
            int status = this.turbo.readNumeric(TwisTorr84.CmndNumeric.STATUS);
            if (TwisTorr84.PumpStatus.decode((int)status).equals("STOP")) {
                this.turbo.writeBool(TwisTorr84.CmndBool.SOFT_START, this.softStartMode.booleanValue());
                this.turbo.writeBool(TwisTorr84.CmndBool.ACTIVE_STOP, this.activeStopMode.booleanValue());
                this.turbo.writeBool(TwisTorr84.CmndBool.WATER_COOLING, this.waterCooling.booleanValue());
                this.turbo.writeBool(TwisTorr84.CmndBool.INTERLOCK_TYPE, this.interlockType.booleanValue());
                if (!this.model304.booleanValue()) {
                    this.turbo.writeBool(TwisTorr84.CmndBool.GAS_TYPE_ARGON, this.gasType_84.booleanValue());
                    this.turbo.writeNumeric(TwisTorr84.CmndNumeric.ROTFREQ_SET, 1350);
                    this.turbo.writeNumeric(TwisTorr84.CmndNumeric.ROTFREQ_LOW, 1100);
                } else {
                    this.turbo.writeNumeric(TwisTorr84.CmndNumeric.ROTFREQ_SET, 1010);
                    this.turbo.writeNumeric(TwisTorr84.CmndNumeric.ROTFREQ_LOW, 900);
                }
            } else {
                LOG.info("TurboPump not in Stopped state - \n  SOFT_START, ACTIVE_STOP, and a few other settings cannot be changed");
            }
            boolean as = this.turbo.readBool(TwisTorr84.CmndBool.ACTIVE_STOP);
            boolean ss = this.turbo.readBool(TwisTorr84.CmndBool.SOFT_START);
            this.initSensors();
            this.setOnline(true);
            LOG.info("\n Connected to " + this.fullName);
            LOG.info("Hardware initialized for " + this.fullName + "\n Active-Stop mode = " + Boolean.toString(as) + ",  Soft-Start mode  = " + Boolean.toString(ss));
        }
        catch (DriverException e) {
            if (!this.inited) {
                LOG.severe("Error connecting to or initializaing " + this.fullName + ": " + (Object)((Object)e));
            }
            this.close();
        }
        this.inited = true;
    }

    protected void close() {
        try {
            this.turbo.close();
        }
        catch (DriverException driverException) {
            // empty catch block
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ConfigurationParameterChanger(propertyName="softStartMode")
    public void setSoftStartMode(Boolean value) throws DriverException {
        if (this.isOnline()) {
            if (value == null) throw new IllegalArgumentException(this.name + ": improper value for softStartMode, not changed");
            LOG.info(this.name + "config. change request: set SOFT_START = " + value);
            this.turbo.writeBool(TwisTorr84.CmndBool.SOFT_START, value.booleanValue());
            this.softStartMode = value;
            return;
        } else {
            if (value == null) return;
            this.softStartMode = value;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ConfigurationParameterChanger(propertyName="activeStopMode")
    public void setActiveStopMode(Boolean value) throws DriverException {
        if (this.isOnline()) {
            if (value == null) throw new IllegalArgumentException(this.name + ": improper value for activeStopMode, not changed");
            LOG.info(this.name + "config. change request: set ACTIVE_STOP = " + value);
            this.turbo.writeBool(TwisTorr84.CmndBool.ACTIVE_STOP, value.booleanValue());
            this.activeStopMode = value;
            return;
        } else {
            if (value == null) return;
            this.activeStopMode = value;
        }
    }

    @Command(type=Command.CommandType.ACTION, name="startTurboPump", description="Start turbo pump")
    public void startTurboPump() throws DriverException {
        this.turbo.writeBool(TwisTorr84.CmndBool.START_STOP, true);
    }

    @Command(type=Command.CommandType.ACTION, name="stopTurboPump", description="Stop turbo pump")
    public void stopTurboPump() throws DriverException {
        this.turbo.writeBool(TwisTorr84.CmndBool.START_STOP, false);
    }

    protected int[] checkChannel(Channel ch) throws Exception {
        String type = ch.getTypeStr();
        String subtype = ch.getSubTypeStr();
        String name = ch.getName();
        try {
            switch (type) {
                case "Bool": {
                    TwisTorr84.CmndBool.valueOf((String)subtype);
                    break;
                }
                case "Numeric": {
                    TwisTorr84.CmndNumeric.valueOf((String)subtype);
                    break;
                }
                case "Alpha": {
                    TwisTorr84.CmndAlpha.valueOf((String)subtype);
                    break;
                }
                default: {
                    ErrorUtils.reportChannelError(LOG, name, "type", type);
                    break;
                }
            }
        }
        catch (IllegalArgumentException e) {
            ErrorUtils.reportChannelError(LOG, name, type + " subtype ", subtype);
        }
        Object object = this.chanKey;
        Integer n = this.chanKey = Integer.valueOf(this.chanKey + 1);
        return new int[]{this.chanKey, 0};
    }

    protected double readChannel(Channel ch) {
        double value = super.readChannel(ch);
        String itemType = ch.getTypeStr();
        String item = ch.getSubTypeStr();
        try {
            switch (itemType) {
                case "Bool": {
                    if (this.turbo.readBool(TwisTorr84.CmndBool.valueOf((String)item))) {
                        value = 1.0;
                        break;
                    }
                    value = 0.0;
                    break;
                }
                case "Numeric": {
                    value = this.turbo.readNumeric(TwisTorr84.CmndNumeric.valueOf((String)item));
                    if (!item.equals("STATUS")) break;
                    int status = (int)Math.round(value);
                    try {
                        TurboState state = TurboState.getState(status);
                        if (state != this.lastState) {
                            this.stateService.updateAgentComponentState((Object)this, new Enum[]{state});
                            if (state == TurboState.AUTOTUNING && this.lastState != TurboState.AUTOTUNING) {
                                this.alertService.raiseAlert(TurboAlerts.IN_AUTOTUNING.newAlert(this.path), AlertState.WARNING, autotuneMsg);
                            }
                            if (state != TurboState.AUTOTUNING && this.lastState == TurboState.AUTOTUNING) {
                                this.alertService.raiseAlert(TurboAlerts.IN_AUTOTUNING.newAlert(this.path), AlertState.NOMINAL, "out of autotuning state");
                            }
                            this.lastState = state;
                        }
                    }
                    catch (Exception ex) {
                        LOG.severe(this.name + " failed to set state, " + ex);
                    }
                    break;
                }
                case "Alpha": {
                    this.turbo.readAlpha(TwisTorr84.CmndAlpha.valueOf((String)item));
                }
            }
        }
        catch (DriverTimeoutException et) {
            LOG.severe(this.name + ": TurboPump timeout reading data " + item + ": " + (Object)((Object)et));
            this.setOnline(false);
        }
        catch (DriverException e) {
            LOG.severe(this.name + ": TurboPump exception reading data " + item + ": " + (Object)((Object)e));
        }
        return value;
    }

    @Command(type=Command.CommandType.QUERY, level=0, name="readTurboStatus", description="Get pump status, including operating modes and failure")
    public TwisTorr84.PumpStatus readTurboStatus() throws DriverException {
        int status = this.turbo.readNumeric(TwisTorr84.CmndNumeric.STATUS);
        return TwisTorr84.PumpStatus.decodeStatus((int)status);
    }

    @Command(type=Command.CommandType.QUERY, name="readTurboFailCode", description="Find reason(s) for failure", level=0)
    public String readTurboFailCode() throws DriverException {
        int errcode = this.turbo.readNumeric(TwisTorr84.CmndNumeric.ERRCODE);
        return Integer.toString(errcode, 16) + ", " + TwisTorr84.decodeError((int)errcode);
    }

    @Command(type=Command.CommandType.QUERY, level=1, name="readTurboLife", description="show TurboPump running-time in hours")
    public String readTurboLife() throws DriverException {
        int life = this.turbo.readNumeric(TwisTorr84.CmndNumeric.PUMP_HOURS);
        return Integer.toString(life) + " hours";
    }

    @Command(type=Command.CommandType.QUERY, level=1, name="readAll", description="Read all TurboPump controller settings and data")
    public String readAll() {
        String table = "Read all turbo-pump settings and data\n\n";
        TwisTorr84.CmndBool[] cmndB = TwisTorr84.CmndBool.values();
        int nB = cmndB.length;
        for (int i = 0; i < nB; ++i) {
            table = table + String.format("\n   %-22s", cmndB[i]);
            try {
                boolean respB = this.turbo.readBool(cmndB[i]);
                table = table + Boolean.toString(respB);
                continue;
            }
            catch (DriverException ex) {
                table = table + ex.getMessage();
            }
        }
        table = table + "\n";
        TwisTorr84.CmndNumeric[] cmndN = TwisTorr84.CmndNumeric.values();
        int nN = cmndN.length;
        for (int i = 0; i < nN; ++i) {
            table = table + String.format("\n   %-22s", cmndN[i]);
            try {
                int respN = this.turbo.readNumeric(cmndN[i]);
                table = table + Integer.toString(respN);
                continue;
            }
            catch (DriverException ex) {
                table = table + ex.getMessage();
            }
        }
        table = table + "\n";
        TwisTorr84.CmndAlpha[] cmndA = TwisTorr84.CmndAlpha.values();
        int nA = cmndA.length;
        for (int i = 0; i < nA; ++i) {
            table = table + String.format("\n   %-22s", cmndA[i]);
            try {
                String respA = this.turbo.readAlpha(cmndA[i]);
                table = table + respA;
                continue;
            }
            catch (DriverException ex) {
                table = table + ex.getMessage();
            }
        }
        return table;
    }

    public TurboState getTurboState() {
        return this.lastState;
    }
}

