/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.bk;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.ascii.TestAscii;
import org.lsst.ccs.drivers.bk.Model1696;
import org.lsst.ccs.drivers.commons.DriverException;

public class Test1696
extends TestAscii {
    private final Model1696 bk = (Model1696)this.dev;
    private final int chanNum = 1;

    public Test1696() {
        super((Ascii)new Model1696());
    }

    @Command(name="setvoltage", description="Set the voltage")
    public void setVoltage(@Argument(name="value", description="Voltage to set") double value) throws DriverException {
        this.bk.setVoltage(value, 1);
    }

    @Command(name="showvoltage", description="Show the set voltage")
    public String showVoltage() throws DriverException {
        return "Voltage = " + this.bk.getVoltage(1);
    }

    @Command(name="readvoltage", description="Read the actual voltage")
    public String readVoltage() throws DriverException {
        return "Voltage = " + this.bk.readVoltage(1);
    }

    @Command(name="setvoltlim", description="Set the soft voltage limit")
    public void setVoltageLimit(@Argument(name="value", description="Voltage limit to set") double value) throws DriverException {
        this.bk.setVoltageLimit(value, 1);
    }

    @Command(name="showvoltlim", description="Show the soft voltage limit")
    public String showVoltageLimit() throws DriverException {
        return "Voltage limit = " + this.bk.getVoltageLimit(1);
    }

    @Command(name="setcurrent", description="Set the current")
    public void setCurrent(@Argument(name="value", description="Current to set") double value) throws DriverException {
        this.bk.setCurrent(value, 1);
    }

    @Command(name="showcurrent", description="Show the set current")
    public String showCurrent() throws DriverException {
        return "Current = " + this.bk.getCurrent(1);
    }

    @Command(name="readcurrent", description="Read the actual current")
    public String readCurrent() throws DriverException {
        return "Current = " + this.bk.readCurrent(1);
    }

    @Command(name="setoutput", description="Turn output on or off")
    public void setOutput(@Argument(name="state", description="Output state: on or off") OnOff state) throws DriverException {
        this.bk.setOutput(state == OnOff.ON, 1);
    }

    @Command(name="showoutput", description="Show the output state")
    public String showOutput() throws DriverException {
        return "Output state = " + this.getOnOff(this.bk.getOutput(1));
    }

    @Command(name="lock", description="Lock the front panel")
    public void lock() throws DriverException {
        this.bk.lockPanel(true, 1);
    }

    @Command(name="unlock", description="Unlock the front panel")
    public void unlock() throws DriverException {
        this.bk.lockPanel(false, 1);
    }

    @Command(name="showpanel", description="Show the front panel state")
    public String showPanel() throws DriverException {
        Model1696.Panel panel = this.bk.getPanel(1);
        return " Read voltage = " + String.format("%5s", panel.readVoltage) + "   Read current = " + String.format("%5s", panel.readCurrent) + "\n Read power   = " + String.format("%5s", panel.readPower) + "   Set voltage  = " + String.format("%5s", panel.setVoltage) + "\n Set current  = " + String.format("%5s", panel.setCurrent) + "   Timer mins   = " + String.format("%5s", panel.minutes) + "\n Timer secs   = " + String.format("%5s", panel.seconds) + "   Program no.  = " + String.format("%5s", panel.program) + "\n Timer disp   = " + String.format("%5s", panel.timerDisplay) + "   Colon disp   = " + String.format("%5s", panel.colonDisplay) + "\n Vconst disp  = " + String.format("%5s", panel.vConstDisplay) + "   Vset disp    = " + String.format("%5s", panel.vSetDisplay) + "\n Iconst disp  = " + String.format("%5s", panel.iConstDisplay) + "   Iset disp    = " + String.format("%5s", panel.iSetDisplay) + "\n Program disp = " + String.format("%5s", panel.programDisplay) + "   Setting disp = " + String.format("%5s", panel.settingDisplay) + "\n Lock disp    = " + String.format("%5s", panel.lockDisplay) + "   Unlock disp  = " + String.format("%5s", panel.unlockDisplay) + "\n Fault disp   = " + String.format("%5s", panel.faultDisplay) + "   Out on disp  = " + String.format("%5s", panel.onDisplay) + "\n Out off disp = " + String.format("%5s", panel.offDisplay) + "   Remote disp  = " + String.format("%5s", panel.remoteDisplay);
    }

    private String getOnOff(boolean on) {
        return on ? "on" : "off";
    }

    public static enum OnOff {
        OFF,
        ON;

    }
}

