/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.lsst.ccs.PersistencyService;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.Persist;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystems.fcs.Autochanger;
import org.lsst.ccs.subsystems.fcs.ComplementarySensors;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerOnlineClamp;
import org.lsst.ccs.subsystems.fcs.common.ControlledBySensors;
import org.lsst.ccs.subsystems.fcs.common.EPOSControllerForOnlineClamp;
import org.lsst.ccs.subsystems.fcs.common.EPOSControllerWithBrake;
import org.lsst.ccs.subsystems.fcs.common.MobileItem;
import org.lsst.ccs.subsystems.fcs.common.MovedByEPOSController;
import org.lsst.ccs.subsystems.fcs.errors.FailedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class AutochangerOnlineClampProto
extends MobileItem
implements MovedByEPOSController,
ControlledBySensors {
    public static final String CURRENT_MONITOR_TASK_NAME = "-monitorCurrent";
    public static final int TIMEOUT_FOR_CLOSING = 15000;
    public static final int TIMEOUT_FOR_OPENING = 15000;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private Autochanger autochanger;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    private final EPOSControllerForOnlineClamp controller;
    private final ComplementarySensors closeSensors;
    private final ComplementarySensors openSensors;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private PersistencyService persistenceService;
    @ConfigurationParameter(description="current to clamp ONLINE clamp", category="autochanger", units="mA")
    private volatile int currentToClamp = 0;
    @ConfigurationParameter(description="current to open ONLINE clamp", category="autochanger", units="mA")
    private volatile int currentToOpen = 0;
    @Persist
    private volatile int sentCurrent = 0;
    private int currentReadOnController;
    private int position;
    @ConfigurationParameter(description="increment of current to lock in a current ramp", category="autochanger", units="mA")
    private int incrementCurrentToClamp = 250;
    @ConfigurationParameter(description="increment of current to close clamp in a current ramp", category="autochanger", units="mA")
    private int incrementCurrentToClose = 250;
    @ConfigurationParameter(description="increment of current to open clamp in a current ramp", category="autochanger", units="mA")
    private int incrementCurrentToOpen = 250;
    private int initialCurrentToClose = -this.currentToOpen;
    @ConfigurationParameter(description="final current to close clamp in a current ramp", category="autochanger", units="mA")
    private int finalCurrentToClose;
    private FcsEnumerations.LockStatus lockStatus = FcsEnumerations.LockStatus.UNKNOWN;
    private volatile boolean initialized;
    private boolean controllerConfigured = true;
    private ScheduledFuture<?> currentRampHandle;

    public AutochangerOnlineClampProto(EPOSControllerForOnlineClamp controller, ComplementarySensors closeSensors, ComplementarySensors openSensors) {
        this.controller = controller;
        this.closeSensors = closeSensors;
        this.openSensors = openSensors;
    }

    @ConfigurationParameterChanger
    public void setIncrementCurrentToClamp(int stepHeightAbsValue) {
        FcsUtils.checkPositive(stepHeightAbsValue);
        this.incrementCurrentToClamp = stepHeightAbsValue;
    }

    @ConfigurationParameterChanger
    public void setIncrementCurrentToOpen(int incrementCurrentToOpen) {
        FcsUtils.checkPositive(incrementCurrentToOpen);
        this.incrementCurrentToOpen = incrementCurrentToOpen;
    }

    @ConfigurationParameterChanger
    public void setIncrementCurrentToClose(int incrementCurrentToClose) {
        FcsUtils.checkPositive(incrementCurrentToClose);
        this.incrementCurrentToClose = incrementCurrentToClose;
    }

    @Override
    public EPOSControllerWithBrake getController() {
        return this.controller;
    }

    public int getCurrentToOpen() {
        return this.currentToOpen;
    }

    public int getCurrentToClamp() {
        return this.currentToClamp;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if lockSensor and lockSensorC retun the same value. Doesn't read again sensors.")
    public boolean isCloseSensorsInError() {
        return this.closeSensors.isInError();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if unlockSensor and unlockSensorC retun the same value. Doesn't read again sensors.")
    public boolean isOpenSensorsInError() {
        return this.openSensors.isInError();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if in ERROR which means that closeSensor or openSensor is in ERROR or thatopenSensor and closeSensor return non consistant values. Doesn't read again sensors.")
    public boolean isInError() {
        return this.lockStatus == FcsEnumerations.LockStatus.ERROR;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if CLOSED. Doesn't read again sensors.")
    public boolean isClosed() {
        return this.lockStatus == FcsEnumerations.LockStatus.CLOSED;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if homing of controller has been done.")
    public boolean isHomingDone() {
        return this.controller.isHomingDone();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if LOCKED. Doesn't read again sensors.")
    public boolean isLocked() {
        return this.lockStatus == FcsEnumerations.LockStatus.LOCKED;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if OPENED. Doesn't read again sensors.")
    public boolean isOpened() {
        return this.lockStatus == FcsEnumerations.LockStatus.OPENED;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if INTRAVEL. Doesn't read again sensors.")
    public boolean isInTravel() {
        return this.lockStatus == FcsEnumerations.LockStatus.INTRAVEL;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if clamp is initialized : controller is booted and parameters in the controller CPU have been opened and controller is configured.")
    public boolean isInitialized() {
        return this.initialized;
    }

    public void init() {
        this.persistenceService.setAutomatic(true, false);
        ClearAlertHandler alwaysClear = new ClearAlertHandler(){

            public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState alertState) {
                return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
            }
        };
        this.alertService.registerAlert(FcsEnumerations.FcsAlert.HARDWARE_ERROR.getAlert(this.controller.getName()), alwaysClear);
        this.alertService.registerAlert(FcsEnumerations.FcsAlert.SDO_ERROR.getAlert(this.controller.getName()), alwaysClear);
        this.alertService.registerAlert(FcsEnumerations.FcsAlert.AC_SENSOR_ERROR.getAlert(), alwaysClear);
    }

    public void build() {
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if controller is initialized and configured.")
    public boolean myDevicesReady() {
        return this.controller.isInitialized() && this.controllerConfigured;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Check if the onlineClamp can be locked.")
    public void checkConditionsForOpening() {
        this.autochanger.checkConditionsForActioningOnlineClamps();
        if (!this.autochanger.isHoldingFilter()) {
            throw new RejectedCommandException(this.name + " can't be OPENED if autochanger is not HOLDING filter.");
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Check if the onlineClamp can be locked.")
    public void checkConditionsForClosing() {
        this.autochanger.checkConditionsForActioningOnlineClamps();
    }

    public void postStart() {
        FCSLOG.fine((Object)(this.name + " BEGIN postStart."));
        if (this.controller.isBooted()) {
            this.initializeController();
        } else {
            FCSLOG.error((Object)(this.name + " could not initialize controller in postStart. Do it by hand."));
        }
        FCSLOG.fine((Object)(this.name + " END postStart."));
    }

    private void initializeController() {
        try {
            this.controller.initializeAndCheckHardware();
            this.initialized = true;
        }
        catch (FailedCommandException | FcsHardwareException ex) {
            this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, this.name + " couldn't initialize controller", this.controller.getName(), ex);
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Read in the CPU of the controller parameters for mode CURRENT.If a parameter has a different value than in configuration throws an exception.")
    public void enableAndCheckControllerBeforeAction(FcsEnumerations.MobileItemAction action) {
        this.controller.goToOperationEnable();
        this.controller.changeMode(EPOSEnumerations.EposMode.CURRENT);
        this.controller.checkFault();
    }

    public void checkControllerWhenGoingFromEngineeringModeToNormal() {
        this.controller.checkParameters(EPOSEnumerations.EposMode.CURRENT);
        if (!this.controller.isParametersOK()) {
            String msg = this.name + " Some parameter values are not the same in CPU and configuration system.";
            FCSLOG.error((Object)msg);
            throw new FcsHardwareException(msg);
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Configure controller.")
    public void configureController() {
        try {
            this.controllerConfigured = false;
            this.configureDigitalInputOfOnlineClamps();
            this.configureDigitalOutputOfOnlineClamps();
            this.controllerConfigured = true;
        }
        catch (SDORequestException ex) {
            FCSLOG.warning((Object)this.name, (Throwable)ex);
        }
    }

    public void updateStateAndCheckSensors() {
        this.autochanger.updateStateWithSensors();
        this.checkSensors(FcsEnumerations.FcsAlert.AC_SENSOR_ERROR, this.name);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Update state from sensors values.")
    public void updateState() {
        boolean inError;
        boolean closed = this.closeSensors.isOn();
        boolean opened = this.openSensors.isOn();
        boolean someSensorsInError = this.closeSensors.isInError() || this.openSensors.isInError();
        boolean bl = inError = someSensorsInError || closed && opened;
        this.lockStatus = inError ? FcsEnumerations.LockStatus.ERROR : (closed ? FcsEnumerations.LockStatus.CLOSED : (opened ? FcsEnumerations.LockStatus.OPENED : FcsEnumerations.LockStatus.INTRAVEL));
        if (closed && this.sentCurrent == this.currentToClamp) {
            this.lockStatus = FcsEnumerations.LockStatus.LOCKED;
        }
        this.publishData();
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() {
        this.autochanger.updateStateWithSensors();
        this.currentReadOnController = this.controller.readCurrent();
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        if (action == FcsEnumerations.MobileItemAction.CLOSE_ONLINECLAMP_MODE_CURRENT || action == FcsEnumerations.MobileItemAction.UNLOCK_ONLINECLAMP) {
            return this.sentCurrent == this.finalCurrentToClose;
        }
        if (action == FcsEnumerations.MobileItemAction.REOPEN_ONLINECLAMP_MODE_CURRENT || action == FcsEnumerations.MobileItemAction.OPEN_ONLINECLAMP_MODE_CURRENT) {
            return this.isOpened() && this.isCurrentReached(this.currentToOpen);
        }
        if (action == FcsEnumerations.MobileItemAction.LOCK_ONLINECLAMP) {
            return this.isLocked();
        }
        throw new IllegalArgumentException(this.name + " invalid action for ONLINE clamp:" + (Object)((Object)action));
    }

    private boolean isCurrentReached(int currentToReach) {
        int DELTA = 5;
        FCSLOG.debug((Object)("readCurrent=" + this.currentReadOnController + " currentToReached=" + currentToReach));
        return Math.abs(this.currentReadOnController - currentToReach) <= DELTA;
    }

    public boolean isAtPosition(int pos) {
        return Math.abs(this.position - pos) < 500;
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Closes the ONLINE clamp.", timeout=15000)
    public void closeClampInCurrentMode() {
        this.updateStateAndCheckSensors();
        if (this.isOpened() || this.isInTravel()) {
            this.checkConditionsForClosing();
            this.executeAction(FcsEnumerations.MobileItemAction.CLOSE_ONLINECLAMP_MODE_CURRENT, 15000L);
            this.checkCloseSensors();
            this.updateStateAndCheckSensors();
        } else if (this.isClosed()) {
            FCSLOG.info((Object)(this.name + " is already CLOSED. Nothing to do."));
        } else {
            throw new RejectedCommandException(this.name + " has to be OPENED before a close action.");
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Closes the ONLINE clamp in mode PROFILE_POSITION.", timeout=15000)
    public void close() {
        this.closeClampInCurrentMode();
    }

    private void checkCloseSensors() {
        if (!this.isClosed()) {
            throw new FailedCommandException(this.name + " is not CLOSED after close or unlock command.");
        }
        FCSLOG.info((Object)(this.name + " is CLOSED"));
    }

    private void checkOpenSensors() {
        if (!this.isOpened()) {
            throw new FailedCommandException(this.name + " is not OPEN after open or openAndHoming command.");
        }
        FCSLOG.info((Object)(this.name + " is OPEN"));
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Opens the ONLINE clamp.", timeout=15000)
    public void openClampInCurrentMode() {
        this.updateStateAndCheckSensors();
        if (this.isClosed()) {
            this.checkConditionsForOpening();
            this.executeAction(FcsEnumerations.MobileItemAction.OPEN_ONLINECLAMP_MODE_CURRENT, 15000L);
        } else if (this.isOpened() || this.isInTravel()) {
            FCSLOG.info((Object)(this.name + " is already OPENED. Send again currentToOpen."));
            this.executeAction(FcsEnumerations.MobileItemAction.REOPEN_ONLINECLAMP_MODE_CURRENT, 15000L);
        } else {
            throw new RejectedCommandException(this.name + " has to be CLOSED before an open action.");
        }
        this.checkOpenSensors();
        this.updateStateAndCheckSensors();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Opens the ONLINE clamp in PROFILE_POSITION.", timeout=15000)
    public void open() {
        this.openClampInCurrentMode();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Locks the ONLINE clamp : sends currentToClamp to the controller with a ramp of currentfrom currentToClose to currentToRamp.", timeout=15000)
    public void lock() {
        this.updateStateAndCheckSensors();
        if (this.isClosed()) {
            this.executeAction(FcsEnumerations.MobileItemAction.LOCK_ONLINECLAMP, 15000L);
            this.updateStateAndCheckSensors();
        } else if (this.isLocked()) {
            FCSLOG.info((Object)(this.name + " is already LOCKED. Nothing to do."));
        } else {
            throw new RejectedCommandException(this.name + " has to be CLOSED before lock action.");
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Unlocks the ONLINE clamp : sends currentToClamp to the controller  with a ramp of current from currentToClamp to currentToClose.", timeout=15000)
    public void unlock() {
        this.updateStateAndCheckSensors();
        if (this.isLocked()) {
            this.executeAction(FcsEnumerations.MobileItemAction.UNLOCK_ONLINECLAMP, 15000L);
            this.checkCloseSensors();
            this.updateStateAndCheckSensors();
        } else if (this.isClosed()) {
            FCSLOG.info((Object)(this.name + " is already CLOSED. Nothing to do."));
        } else {
            throw new RejectedCommandException(this.name + " has to be LOCKED before unlock action.");
        }
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) {
        this.enableAndCheckControllerBeforeAction(action);
        this.autochanger.checkConditionsForActioningOnlineClamps();
        this.autochanger.increaseCurrentMonitoring();
        this.autochanger.checkOnlineClampMotionAllowed();
        if (action == FcsEnumerations.MobileItemAction.CLOSE_ONLINECLAMP_MODE_CURRENT) {
            this.controller.doReleaseBrake();
            this.sendCurrentToControllerAndSaveValue(this.initialCurrentToClose);
            this.executeCurrentRamp(this.initialCurrentToClose, this.finalCurrentToClose, this.incrementCurrentToClose);
        } else if (action == FcsEnumerations.MobileItemAction.OPEN_ONLINECLAMP_MODE_CURRENT) {
            this.sendCurrentToControllerAndSaveValue(this.finalCurrentToClose);
            FcsUtils.sleep(500, this.name);
            this.controller.doReleaseBrake();
            this.executeCurrentRamp(this.finalCurrentToClose, this.currentToOpen, this.incrementCurrentToOpen);
        } else if (action == FcsEnumerations.MobileItemAction.REOPEN_ONLINECLAMP_MODE_CURRENT) {
            this.controller.enableAndReleaseBrake();
            this.sendCurrentToControllerAndSaveValue(this.currentToOpen);
        } else if (action == FcsEnumerations.MobileItemAction.LOCK_ONLINECLAMP) {
            this.sendCurrentToControllerAndSaveValue(this.finalCurrentToClose);
            FcsUtils.sleep(500, this.name);
            this.controller.doReleaseBrake();
            this.executeCurrentRamp(this.finalCurrentToClose, this.currentToClamp, this.incrementCurrentToClamp);
        } else if (action == FcsEnumerations.MobileItemAction.UNLOCK_ONLINECLAMP) {
            this.sendCurrentToControllerAndSaveValue(this.currentToClamp);
            FcsUtils.sleep(500, this.name);
            this.controller.doReleaseBrake();
            this.executeCurrentRamp(this.currentToClamp, this.finalCurrentToClose, this.incrementCurrentToClamp);
        } else {
            throw new IllegalArgumentException(this.name + " invalid action for ONLINE clamp:" + (Object)((Object)action));
        }
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="sent current to control and save this value")
    public void sendCurrentToControllerAndSaveValue(int current) {
        FCSLOG.finest((Object)(this.name + " current to write to controller " + this.getControllerName() + ":" + current));
        this.controller.changeMode(EPOSEnumerations.EposMode.CURRENT);
        this.controller.writeCurrent((short)current);
        this.sentCurrent = current;
        this.persistenceService.persistNow();
        this.publishData();
    }

    @Override
    public void abortAction(FcsEnumerations.MobileItemAction action, long delay) {
        FCSLOG.debug((Object)(this.name + " is ABORTING action " + action.toString() + " within delay " + delay));
        this.autochanger.decreaseCurrentMonitoring();
        this.controller.activateBrake();
        this.controller.writeCurrent(0);
        this.controller.goToSwitchOnDisabled();
    }

    @Override
    public void endAction(FcsEnumerations.MobileItemAction action) {
        FCSLOG.debug((Object)(this.name + " is ENDING action " + action.toString()));
        this.autochanger.decreaseCurrentMonitoring();
        if (action == FcsEnumerations.MobileItemAction.OPEN_ONLINECLAMP_MODE_CURRENT || action == FcsEnumerations.MobileItemAction.REOPEN_ONLINECLAMP_MODE_CURRENT) {
            FcsUtils.sleep(1000, this.name);
            this.controller.activateBrake();
            this.controller.writeCurrent(0);
        } else {
            this.controller.activateBrake();
        }
        this.controller.goToSwitchOnDisabled();
        FCSLOG.debug((Object)(this.name + " action " + action.toString() + " is ENDED"));
        this.updateState();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="To configure the online clamps controllers.")
    public void configureDigitalInputOfOnlineClamps() {
        this.controller.writeParameter(EPOSEnumerations.Parameter.ConfigurationOfDigitalInput1, 5);
        this.controller.writeParameter(EPOSEnumerations.Parameter.DigitalInputFonctionnalityPolarity, 0);
        this.controller.writeParameter(EPOSEnumerations.Parameter.DigitalInputFonctionnalityMask, 35872);
        this.controller.writeParameter(EPOSEnumerations.Parameter.DigitalInputFonctionnalityExecutionMask, 48);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="To configure the online clamps controllers.")
    public void configureDigitalOutputOfOnlineClamps() {
        this.controller.writeParameter(EPOSEnumerations.Parameter.ConfigurationOfDigitalOutput1, 0);
        this.controller.writeParameter(EPOSEnumerations.Parameter.ConfigurationOfDigitalOutput4, 15);
        this.controller.writeParameter(EPOSEnumerations.Parameter.DigitalOutputFonctionnalityMask, 32769);
        this.controller.writeParameter(EPOSEnumerations.Parameter.DigitalOutputFonctionnalityPolarity, 0);
    }

    public StatusDataPublishedByAutochangerOnlineClamp createStatusDataPublishedByOnlineClamp() {
        StatusDataPublishedByAutochangerOnlineClamp status = new StatusDataPublishedByAutochangerOnlineClamp();
        status.setLockSensorValue(this.closeSensors.isOn());
        status.setUnlockSensorValue(this.openSensors.isOn());
        status.setLockStatus(this.lockStatus);
        status.setLockSensorInError(this.closeSensors.isInError());
        status.setUnlockSensorInError(this.openSensors.isInError());
        status.setInError(this.lockStatus == FcsEnumerations.LockStatus.ERROR);
        status.setSentCurrent(this.sentCurrent);
        status.setHomingDone(this.controller.isHomingDone());
        return status;
    }

    @Override
    public void publishData() {
        this.subs.publishSubsystemDataOnStatusBus(new KeyValueData(this.name, (Serializable)this.createStatusDataPublishedByOnlineClamp()));
    }

    @Override
    public void quickStopAction(FcsEnumerations.MobileItemAction action, long delay) {
        this.controller.quickStop();
    }

    private void cancelCurrentRamp() {
        this.currentRampHandle.cancel(false);
        FCSLOG.debug((Object)" => current ramp ended");
    }

    private void waitForEndOfCurrentRamp(int timeout) {
        FCSLOG.info((Object)(this.name + " BEGIN WAITING FOR END OF CURRENT RAMP"));
        try {
            this.currentRampHandle.get(timeout, TimeUnit.SECONDS);
        }
        catch (CancellationException ex) {
            if (this.currentRampHandle.isDone()) {
                FCSLOG.info((Object)(this.name + " CURRENT RAMP ENDED"));
            } else {
                FCSLOG.error((Object)(this.name + " during action " + (Object)((Object)this.currentAction) + " waiting was cancelled before END of CURRENT RAMP " + ex));
            }
        }
        catch (TimeoutException ex) {
            FCSLOG.error((Object)(this.name + " CURRENT RAMP IS DURING TOO LONG - timeout=" + timeout), (Throwable)ex);
            this.cancelCurrentRamp();
        }
        catch (InterruptedException ex) {
            FCSLOG.error((Object)(this.name + " interrupted while waiting end of current ramp during action=" + (Object)((Object)this.currentAction)), (Throwable)ex);
            throw new FcsHardwareException(this.name + " interrupted while waiting end of current ramp during action=" + (Object)((Object)this.currentAction), ex);
        }
        catch (ExecutionException ex) {
            FCSLOG.error((Object)(this.name + " error during action=" + (Object)((Object)this.currentAction)), (Throwable)ex);
            throw new FcsHardwareException(this.name + " error during action=" + (Object)((Object)this.currentAction), ex);
        }
        finally {
            FCSLOG.info((Object)(this.name + " STOP WAITING FOR END OF CURRENT RAMP"));
        }
    }

    private void writeCurrentRamp(final int initialValue, final int finalValue, final int increment) {
        FCSLOG.debug((Object)"############################");
        FCSLOG.debug((Object)(this.name + "writeCurrentRamp"));
        FCSLOG.debug((Object)("initialValue=" + initialValue));
        FCSLOG.debug((Object)("finalValue=" + finalValue));
        FCSLOG.debug((Object)("|increment|=" + increment));
        FCSLOG.debug((Object)"period=250");
        FCSLOG.debug((Object)"waitTime=250");
        FCSLOG.debug((Object)"############################");
        Runnable currentRamp = new Runnable(){
            private final int adjustedStepHeight;
            private int currentValue;
            {
                this.adjustedStepHeight = FcsUtils.getSignedStepHeight(initialValue, finalValue, increment);
                this.currentValue = initialValue;
            }

            public boolean finalValueReached() {
                boolean reachedUp = this.adjustedStepHeight > 0 && this.currentValue >= finalValue;
                boolean reachedDown = this.adjustedStepHeight < 0 && this.currentValue <= finalValue;
                return reachedUp || reachedDown;
            }

            @Override
            public void run() {
                if (!this.finalValueReached()) {
                    this.currentValue += this.adjustedStepHeight;
                    MobileItem.FCSLOG.info((Object)("ramp write current " + this.currentValue));
                    AutochangerOnlineClampProto.this.sendCurrentToControllerAndSaveValue(this.currentValue);
                }
                if (this.finalValueReached()) {
                    AutochangerOnlineClampProto.this.cancelCurrentRamp();
                }
            }
        };
        this.currentRampHandle = this.scheduler.scheduleAtFixedRate(currentRamp, 250L, 250L, TimeUnit.MILLISECONDS);
    }

    public void executeCurrentRamp(int initialCurrent, int finalCurrent, int incrementCurrent) {
        this.writeCurrentRamp(initialCurrent, finalCurrent, incrementCurrent);
        this.waitForEndOfCurrentRamp(15000);
    }
}

