/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.data.DataProviderDictionary;
import org.lsst.ccs.bus.messages.StatusConfigurationInfo;
import org.lsst.ccs.bus.messages.StatusDataProviderDictionary;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCM;

public class SerializationUtils {
    private static final Logger LOG = Logger.getLogger(SerializationUtils.class.getName());

    public static DataProviderDictionary readDictionaryFromFile(String dictionaryFileName) {
        Object obj = null;
        try (ObjectInputStream ois = new ObjectInputStream(SerializationUtils.getInputStreamFor(dictionaryFileName));){
            obj = ois.readObject();
        }
        catch (IOException | ClassNotFoundException ex) {
            throw new RuntimeException("Failed to read " + dictionaryFileName, ex);
        }
        DataProviderDictionary dict = null;
        if (obj instanceof DataProviderDictionary) {
            dict = (DataProviderDictionary)obj;
        } else if (obj instanceof StatusDataProviderDictionary) {
            dict = ((StatusDataProviderDictionary)obj).getDataProviderDictionary();
        } else if (obj instanceof byte[]) {
            StatusDataProviderDictionary sdpd = new StatusDataProviderDictionary((byte[])obj, "gzip");
            dict = sdpd.getDataProviderDictionary();
        } else {
            throw new RuntimeException("Cannot process serialized object of type " + obj.getClass());
        }
        return dict;
    }

    /*
     * Exception decompiling
     */
    public static StatusConfigurationInfo readStatusConfigurationInfoFromFile(String fileName) throws IOException, ClassNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static StatusSubsystemData readStatusSubsystemData(String fileName) throws IOException, ClassNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static InputStream getInputStreamFor(String fileName) {
        String tmpFullPath = fileName;
        InputStream is = BootstrapResourceUtils.getBootstrapResource((String)fileName, MCM.class);
        if (is == null) {
            File inputFile = new File(fileName);
            if (!inputFile.exists()) {
                throw new RuntimeException("File " + fileName + " does not exist.");
            }
            if (!inputFile.canRead()) {
                throw new RuntimeException("File " + fileName + " cannot be read.");
            }
            tmpFullPath = inputFile.getAbsolutePath();
            try {
                is = new FileInputStream(inputFile);
            }
            catch (FileNotFoundException ex) {
                throw new RuntimeException(ex);
            }
        } else {
            String filePath = BootstrapResourceUtils.getPathOfResourceInUserResourceDirectories((String)fileName);
            if (filePath != null) {
                tmpFullPath = filePath;
            }
        }
        LOG.log(Level.INFO, "Reading file {0}", tmpFullPath);
        return is;
    }
}

